/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractMergeComponentNameHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeLogicalNameHandler
extends AbstractMergeComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof IJBEditor) {
            final IJBEditor editor = (IJBEditor)activePart;
            if (editor.isDirty()) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_SAVE_EDITOR);
                return null;
            }
            editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    Set<IComponentNamePO> compNames = MergeLogicalNameHandler.this.getComponentNames(MergeLogicalNameHandler.this.getSelection());
                    IComponentNamePO selectedCompNamePo = MergeLogicalNameHandler.this.openDialog(compNames);
                    if (selectedCompNamePo != null) {
                        MergeLogicalNameHandler.this.performOperation(editor, compNames, selectedCompNamePo);
                    }
                }
            });
        }
        return null;
    }

    private void performOperation(IJBEditor editor, Set<IComponentNamePO> compNames, IComponentNamePO selectedCompNamePo) {
        this.performOperation(compNames, selectedCompNamePo);
        editor.getEditorHelper().setDirty(true);
        NullProgressMonitor saveProgressMonitor = new NullProgressMonitor();
        editor.doSave((IProgressMonitor)saveProgressMonitor);
        if (!saveProgressMonitor.isCanceled()) {
            this.fireChangeEvents(compNames);
        }
    }
}

