/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.tester.AbstractTableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.StyledTextAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.TableAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.TextComponentAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TableTester
extends AbstractTableTester {
    private Table getTable() {
        return (Table)this.getComponent().getRealComponent();
    }

    public String[] getTextArrayFromComponent() {
        TableColumn[] itemArray = this.getTable().getColumns();
        String[] componentTextArray = this.getTextArrayFromItemArray((Item[])itemArray);
        return componentTextArray;
    }

    protected Object setEditorToReplaceMode(Object editor, boolean replace) {
        if (replace) {
            ControlAdapter textEditor = null;
            if (editor instanceof Text) {
                textEditor = new TextComponentAdapter(editor);
            }
            if (editor instanceof StyledText) {
                textEditor = new StyledTextAdapter(editor);
            }
            if (EnvironmentUtils.isMacOS()) {
                this.getRobot().clickAtCurrentPosition(editor, 3, ValueSets.InteractionMode.primary.rcIntValue().intValue());
            } else {
                this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
            }
            if (textEditor != null && !textEditor.getSelectionText().equals(textEditor.getText())) {
                textEditor.selectAll();
            }
        } else {
            this.getRobot().clickAtCurrentPosition(editor, 2, ValueSets.InteractionMode.primary.rcIntValue().intValue());
        }
        return editor;
    }

    protected Object activateEditor(Cell cell, Rectangle rectangle) {
        TableAdapter table = (TableAdapter)this.getComponent();
        return table.activateEditor(cell);
    }

    protected int getExtendSelectionModifier() {
        return SWT.MOD1;
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        final Table table = this.getTable();
        final java.awt.Point awtMousePos = this.getRobot().getCurrentMousePosition();
        Cell returnvalue = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", (IRunnable)new IRunnable<Cell>(){

            public Cell run() throws StepExecutionException {
                Cell cell = null;
                int itemCount = table.getItemCount();
                int rowCount = table.getTopIndex();
                while (rowCount < itemCount) {
                    if (cell != null) break;
                    int columnCount = table.getColumnCount();
                    if (columnCount > 0) {
                        int col = 0;
                        while (col < columnCount) {
                            TableTester.this.checkRowColBounds(rowCount, col);
                            Rectangle itemBounds = TableTester.getCellBounds(TableTester.this.getEventThreadQueuer(), TableTester.this.getTable(), rowCount, col);
                            Point absItemBounds = table.toDisplay(itemBounds.x, itemBounds.y);
                            Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                            if (absRect.contains(awtMousePos)) {
                                cell = new Cell(rowCount, col);
                                break;
                            }
                            ++col;
                        }
                    } else {
                        TableTester.this.checkRowColBounds(rowCount, 0);
                        Rectangle itemBounds = TableTester.getCellBounds(TableTester.this.getEventThreadQueuer(), TableTester.this.getTable(), rowCount, 0);
                        Point absItemBounds = table.toDisplay(itemBounds.x, itemBounds.y);
                        Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                        if (absRect.contains(awtMousePos)) {
                            cell = new Cell(rowCount, 0);
                        }
                    }
                    ++rowCount;
                }
                if (cell == null) {
                    throw new StepExecutionException("No cell under mouse position found!", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return cell;
            }
        });
        return returnvalue;
    }

    protected boolean isMouseOnHeader() {
        final Table table = this.getTable();
        final ITableComponent adapter = (ITableComponent)this.getComponent();
        Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                return table.getHeaderVisible();
            }
        });
        if (!isVisible.booleanValue()) {
            return false;
        }
        Boolean isOnHeader = new Boolean(false);
        isOnHeader = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                java.awt.Point awtMousePos = TableTester.this.getRobot().getCurrentMousePosition();
                Point mousePos = new Point(awtMousePos.x, awtMousePos.y);
                int j = 0;
                while (j < table.getColumnCount()) {
                    Rectangle constraints = adapter.getHeaderBounds(j);
                    org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getWidgetBounds((Widget)table);
                    if (constraints != null) {
                        Point convertedLocation = TableTester.this.getConvertedLocation(constraints);
                        bounds.x = convertedLocation.x;
                        bounds.y = convertedLocation.y;
                        bounds.height = constraints.height;
                        bounds.width = constraints.width;
                    }
                    if (bounds.contains(mousePos)) {
                        return true;
                    }
                    ++j;
                }
                return false;
            }
        });
        return isOnHeader;
    }

    protected final String[] getTextArrayFromItemArray(Item[] itemArray) {
        String[] itemTextArray;
        if (itemArray == null) {
            itemTextArray = null;
        } else {
            itemTextArray = new String[itemArray.length];
            int i = 0;
            while (i < itemArray.length) {
                Item item = itemArray[i];
                if (item == null) {
                    itemTextArray[i] = null;
                } else {
                    String fallback = SwtUtils.removeMnemonics(item.getText());
                    itemTextArray[i] = CAPUtil.getWidgetText((Widget)item, fallback);
                }
                ++i;
            }
        }
        return itemTextArray;
    }

    private Point getConvertedLocation(final Rectangle constraints) {
        Point convertedLocation = (Point)this.getEventThreadQueuer().invokeAndWait("toDisplay", (IRunnable)new IRunnable<Point>(){

            public Point run() throws StepExecutionException {
                return TableTester.this.getTable().toDisplay(constraints.x, constraints.y);
            }
        });
        return convertedLocation;
    }

    public static Rectangle getCellBounds(IEventThreadQueuer etq, final Table table, final int row, final int col) {
        Rectangle cellBounds = (Rectangle)etq.invokeAndWait("getCellBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() {
                TableItem ti = table.getItem(row);
                int column = table.getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle r = ti.getBounds(column);
                String text = CAPUtil.getWidgetText((Widget)ti, "TEST_TESTABLE_TEXT_" + column, ti.getText(column));
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    finally {
                        gc.dispose();
                    }
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TableColumn tc = table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
        });
        return cellBounds;
    }

    protected Object getSpecificRectangle(Rectangle rectangle) {
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void rcClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        int correctedYPos = this.correctYPos(yPos, yUnits);
        super.rcClickDirect(count, button, xPos, xUnits, correctedYPos, yUnits);
    }

    private int correctYPos(int pos, String units) {
        int correctedPos = pos;
        int headerHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getHeaderHeight", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return ((Table)TableTester.this.getComponent().getRealComponent()).getHeaderHeight();
            }
        });
        if (ValueSets.Unit.pixel.rcValue().equalsIgnoreCase(units)) {
            correctedPos += headerHeight;
        } else {
            int totalHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getWidgetBounds", (IRunnable)new IRunnable<Integer>(){

                public Integer run() throws StepExecutionException {
                    return SwtUtils.getWidgetBounds((Widget)((Widget)TableTester.this.getComponent().getRealComponent())).height;
                }
            });
            long targetHeight = totalHeight - headerHeight;
            long targetPos = Math.round((double)targetHeight * (double)pos / 100.0);
            double heightPercentage = (double)(targetPos += (long)headerHeight) / (double)totalHeight * 100.0;
            correctedPos = (int)Math.round(heightPercentage);
            if (correctedPos > 100) {
                correctedPos = 100;
            }
        }
        return correctedPos;
    }

    public void rcDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.rcSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, ValueSets.BinaryChoice.no.rcValue(), 1);
    }

    public void rcDropCell(final String row, final String rowOperator, final String col, final String colOperator, final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) throws StepExecutionException {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("rcDropCell", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    TableTester.this.rcSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, ValueSets.BinaryChoice.no.rcValue(), 1);
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.rcSelectRowByValue(col, colOperator, value, regexOp, 1, ValueSets.BinaryChoice.no.rcValue(), searchType, 1);
    }

    public void rcDropRowByValue(final String col, final String colOperator, final String value, final String regexOp, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("rcDropRowByValue", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    TableTester.this.selectRowByValue(col, colOperator, value, regexOp, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.selectCellByColValue(row, rowOperator, value, regex, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
    }

    public void rcDropCellByColValue(final String row, final String rowOperator, final String value, final String regex, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("rcDropCellByColValue", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    TableTester.this.selectCellByColValue(row, rowOperator, value, regex, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcVerifyCheckboxInSelectedRow(boolean checked) throws StepExecutionException {
        int row = ((ITableComponent)this.getComponent()).getSelectedCell().getRow();
        this.verifyCheckboxInRow(checked, row);
    }

    public void rcVerifyCheckboxInRowAtMousePosition(boolean checked) {
        int row = this.getCellAtMousePosition().getRow();
        this.verifyCheckboxInRow(checked, row);
    }

    private void verifyCheckboxInRow(boolean checked, final int row) {
        Boolean checkIndex = (Boolean)this.getEventThreadQueuer().invokeAndWait("rcVerifyTableCheckboxIndex", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                Table table = TableTester.this.getTable();
                if ((table.getStyle() & 0x20) == 0) {
                    throw new StepExecutionException("No checkbox found", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotFound"));
                }
                return table.getItem(row).getChecked();
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkIndex);
    }

    public void rcToggleCheckboxInRowAtMousePosition() {
        this.toggleCheckboxInRow(this.getCellAtMousePosition().getRow());
    }

    public void rcToggleCheckboxInSelectedRow() {
        int row = (Integer)this.getEventThreadQueuer().invokeAndWait("get Selection index", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TableTester.this.getTable().getSelectionIndex();
            }
        });
        this.toggleCheckboxInRow(row);
    }

    private void toggleCheckboxInRow(final int row) {
        if (row == -1) {
            this.getEventThreadQueuer().invokeAndWait("No Selection", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    throw new StepExecutionException("No Selection found ", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
                }
            });
        }
        ((ITableComponent)this.getComponent()).scrollCellToVisible(row, 0);
        final Table table = this.getTable();
        org.eclipse.swt.graphics.Rectangle itemBounds = (org.eclipse.swt.graphics.Rectangle)this.getEventThreadQueuer().invokeAndWait("getTableItem", (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() throws StepExecutionException {
                return table.getItem(row).getBounds();
            }
        });
        int itemHeight = itemBounds.height;
        org.eclipse.swt.graphics.Rectangle cbxBounds = new org.eclipse.swt.graphics.Rectangle(0, itemBounds.y, itemBounds.x, itemHeight);
        this.getRobot().click((Object)table, (Object)cbxBounds, ClickOptions.create().left().setScrollToVisible(false), itemBounds.x / 2, true, itemHeight / 2, true);
    }
}

