/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.ComponentGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.GenerateUtil;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public class ClassGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*******************************************************************************" + this.NL + " * Copyright (c) 2014 BREDEX GmbH." + this.NL + " * All rights reserved. This program and the accompanying materials" + this.NL + " * are made available under the terms of the Eclipse Public License v1.0" + this.NL + " * which accompanies this distribution, and is available at" + this.NL + " * http://www.eclipse.org/legal/epl-v10.html" + this.NL + " *" + this.NL + " * Contributors:" + this.NL + " *     BREDEX GmbH - initial API and implementation and/or initial documentation" + this.NL + " *******************************************************************************/" + this.NL + "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import org.eclipse.jdt.annotation.NonNull;" + this.NL + "import org.eclipse.jubula.communication.CAP;" + this.NL + "import org.eclipse.jubula.toolkit.enums.ValueSets.*;" + this.NL + "import javax.annotation.Generated;" + this.NL;
    protected final String TEXT_3 = String.valueOf(this.NL) + "import org.apache.commons.lang.Validate;" + this.NL + "import org.apache.commons.lang.StringUtils;" + this.NL + this.NL + "import org.eclipse.jubula.communication.internal.message.MessageCap;" + this.NL + "import org.eclipse.jubula.communication.internal.message.MessageParam;" + this.NL + "import org.eclipse.jubula.tools.ComponentIdentifier;" + this.NL + "import org.eclipse.jubula.tools.internal.constants.TestDataConstants;" + this.NL + "import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;" + this.NL + "import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;" + this.NL + "import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;";
    protected final String TEXT_4 = String.valueOf(this.NL) + this.NL + "/**" + this.NL + " * ";
    protected final String TEXT_5 = "Interface";
    protected final String TEXT_6 = "Class";
    protected final String TEXT_7 = " representing the ";
    protected final String TEXT_8 = "{@link ";
    protected final String TEXT_9 = "}";
    protected final String TEXT_10 = " component from the ";
    protected final String TEXT_11 = " toolkit.";
    protected final String TEXT_12 = " " + this.NL + " * @noextend This interface is not intended to be extended by clients." + this.NL + " * @noimplement This interface is not intended to be implemented by clients.";
    protected final String TEXT_13 = String.valueOf(this.NL) + " */";
    protected final String TEXT_14 = String.valueOf(this.NL) + "@RealizedType(realizedType=\"";
    protected final String TEXT_15 = "\")";
    protected final String TEXT_16 = String.valueOf(this.NL) + "@TesterClass(testerClass=\"";
    protected final String TEXT_17 = "\")";
    protected final String TEXT_18 = String.valueOf(this.NL) + "@Generated(value = \"";
    protected final String TEXT_19 = "\", " + this.NL + "           date =  \"";
    protected final String TEXT_20 = "\")" + this.NL + "public ";
    protected final String TEXT_21 = "interface";
    protected final String TEXT_22 = "class";
    protected final String TEXT_23 = " ";
    protected final String TEXT_24 = " extends ";
    protected final String TEXT_25 = " implements ";
    protected final String TEXT_26 = " {";
    protected final String TEXT_27 = String.valueOf(this.NL) + "            public ";
    protected final String TEXT_28 = "() {" + this.NL + "                super();" + this.NL + "            }";
    protected final String TEXT_29 = String.valueOf(this.NL) + "            public ";
    protected final String TEXT_30 = "(@NonNull ComponentIdentifier componentIdentifier) {" + this.NL + "                super(componentIdentifier);" + this.NL + "            }";
    protected final String TEXT_31 = String.valueOf(this.NL) + "            public ";
    protected final String TEXT_32 = "() {" + this.NL + "                super();" + this.NL + "            }";
    protected final String TEXT_33 = String.valueOf(this.NL) + "            @NonNull protected IComponentIdentifier m_componentIdentifier;" + this.NL + "            public ";
    protected final String TEXT_34 = "(@NonNull ComponentIdentifier componentIdentifier) {" + this.NL + "                super();" + this.NL + "                Validate.isTrue(componentIdentifier instanceof IComponentIdentifier);" + this.NL + "                m_componentIdentifier = (IComponentIdentifier) componentIdentifier;" + this.NL + "            }";
    protected final String TEXT_35 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_36 = String.valueOf(this.NL) + "    protected IComponentIdentifier getPseudoComponentIdentifier() {";
    protected final String TEXT_37 = String.valueOf(this.NL) + "        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =" + this.NL + "            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();" + this.NL + "        pseudoIdentifier.setComponentClassName(\"";
    protected final String TEXT_38 = "\"); //$NON-NLS-1$" + this.NL + "        return pseudoIdentifier;";
    protected final String TEXT_39 = String.valueOf(this.NL) + "        return null;";
    protected final String TEXT_40 = String.valueOf(this.NL) + "    }";
    protected final String TEXT_41 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_42 = String.valueOf(this.NL) + "        /**" + this.NL + "         * ";
    protected final String TEXT_43 = String.valueOf(this.NL) + "         ";
    protected final String TEXT_44 = "* @param ";
    protected final String TEXT_45 = " " + this.NL + "         *        ";
    protected final String TEXT_46 = String.valueOf(this.NL) + "         ";
    protected final String TEXT_47 = "* @throws IllegalArgumentException if one of the passed parameters is <code>null</code>." + this.NL + "         */";
    protected final String TEXT_48 = "@Deprecated";
    protected final String TEXT_49 = String.valueOf(this.NL) + "        @NonNull public CAP ";
    protected final String TEXT_50 = "(";
    protected final String TEXT_51 = String.valueOf(this.NL) + "            @NonNull ";
    protected final String TEXT_52 = "[]";
    protected final String TEXT_53 = " ";
    protected final String TEXT_54 = ",";
    protected final String TEXT_55 = String.valueOf(this.NL) + "        ) ";
    protected final String TEXT_56 = "throws IllegalArgumentException";
    protected final String TEXT_57 = ";";
    protected final String TEXT_58 = " {" + this.NL + "            MessageCap messageCap = new MessageCap();" + this.NL + "            messageCap.setMethod(\"";
    protected final String TEXT_59 = "\"); //$NON-NLS-1$" + this.NL + "            messageCap.sethasDefaultMapping(";
    protected final String TEXT_60 = ");";
    protected final String TEXT_61 = String.valueOf(this.NL) + "            messageCap.setCi(m_componentIdentifier);";
    protected final String TEXT_62 = String.valueOf(this.NL) + "            messageCap.setCi(getPseudoComponentIdentifier());";
    protected final String TEXT_63 = String.valueOf(this.NL) + "            Validate.notNull(";
    protected final String TEXT_64 = ", \"Argument '";
    protected final String TEXT_65 = "' must not be null\"); //$NON-NLS-1$";
    protected final String TEXT_66 = String.valueOf(this.NL) + "            messageCap.addMessageParam(new MessageParam(";
    protected final String TEXT_67 = ".rcValue(), \"";
    protected final String TEXT_68 = "\")); //$NON-NLS-1$";
    protected final String TEXT_69 = String.valueOf(this.NL) + "            Validate.noNullElements(";
    protected final String TEXT_70 = ", \"Elements of argument '";
    protected final String TEXT_71 = "' must not be null\"); //$NON-NLS-1$" + this.NL + "            messageCap.addMessageParam(new MessageParam(StringUtils.join(";
    protected final String TEXT_72 = ", TestDataConstants.COMBI_VALUE_SEPARATOR), \"";
    protected final String TEXT_73 = "\")); //$NON-NLS-1$";
    protected final String TEXT_74 = String.valueOf(this.NL) + "            messageCap.addMessageParam(new MessageParam(String.valueOf(";
    protected final String TEXT_75 = "), \"";
    protected final String TEXT_76 = "\")); //$NON-NLS-1$";
    protected final String TEXT_77 = String.valueOf(this.NL) + "            return messageCap;" + this.NL + "        }";
    protected final String TEXT_78 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_79 = String.valueOf(this.NL) + "}";
    protected final String TEXT_80 = " ";

    public static synchronized ClassGenerator create(String lineSeparator) {
        nl = lineSeparator;
        ClassGenerator result = new ClassGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        CommonGenInfo genInfo = (CommonGenInfo)argument;
        Object specInfo = genInfo.getSpecificInformation();
        String fqnGeneratorClassName = this.getClass().getName();
        if (specInfo instanceof ComponentGenInfo) {
            ComponentGenInfo compGenInfo = (ComponentGenInfo)specInfo;
            String toolkitName = genInfo.getToolkitName();
            String className = genInfo.getClassName();
            Component component = compGenInfo.getComponent();
            Boolean genInterface = compGenInfo.generatesInterface();
            Boolean hasDefaultMapping = compGenInfo.hasDefaultMapping();
            Map<String, String> compNameMap = compGenInfo.getCompNameMap();
            String packageName = null;
            if (genInterface.booleanValue()) {
                packageName = compGenInfo.getInterfacePackageName();
                compNameMap.put("interfacePackageName", packageName);
                compNameMap.put("componentTypeName", className);
                compNameMap.put("hasDefaultMapping", hasDefaultMapping.toString());
                CommonGenInfo faketory = new CommonGenInfo(component.getToolkitDesriptor(), false);
                compNameMap.put("factoryName", faketory.getFqClassName());
            } else {
                packageName = genInfo.getClassPackageName();
                compNameMap.put("implClassPackageName", packageName);
            }
            String implementedTypeFqn = compGenInfo.getFqInterfaceName();
            NameLoader nameLoader = NameLoader.getInstance();
            ArrayList actions = new ArrayList(component.getActions());
            List realized = component.getRealized();
            Component realizedComponent = realized.size() > 0 ? (Component)realized.get(0) : null;
            Boolean hasRealizedType = realizedComponent != null;
            String realizedType = null;
            CommonGenInfo superInfo = null;
            List superActions = null;
            String realizedTypeFqn = null;
            if (hasRealizedType.booleanValue()) {
                realizedType = realizedComponent.getType();
                superInfo = new CommonGenInfo(realizedComponent);
                superActions = realizedComponent.getActions();
                if (genInterface.booleanValue()) {
                    ComponentGenInfo superCompGenInfo = new ComponentGenInfo(realizedComponent, true, superInfo.getToolkitName(), superInfo.getClassName(), null);
                    realizedTypeFqn = superCompGenInfo.getFqInterfaceName();
                    compNameMap.put("superComp", realizedComponent.getType());
                } else {
                    realizedTypeFqn = superInfo.getFqClassName();
                }
            }
            String testerClass = "";
            String componentClassName = "";
            Boolean hasComponentClass = false;
            if (component instanceof ConcreteComponent) {
                ConcreteComponent concreteComponent = (ConcreteComponent)component;
                testerClass = concreteComponent.getTesterClass();
                componentClassName = concreteComponent.getComponentClass().getName();
                if (!componentClassName.isEmpty()) {
                    hasComponentClass = true;
                }
            }
            stringBuffer.append(this.TEXT_1);
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
            if (!genInterface.booleanValue()) {
                stringBuffer.append(this.TEXT_3);
            }
            stringBuffer.append(this.TEXT_4);
            if (genInterface.booleanValue()) {
                stringBuffer.append("Interface");
            } else {
                stringBuffer.append("Class");
            }
            stringBuffer.append(" representing the ");
            if (!hasDefaultMapping.booleanValue() && hasComponentClass.booleanValue()) {
                stringBuffer.append("{@link ");
                stringBuffer.append(componentClassName);
                stringBuffer.append("}");
            } else {
                stringBuffer.append(className);
            }
            stringBuffer.append(" component from the ");
            stringBuffer.append(toolkitName);
            stringBuffer.append(" toolkit.");
            if (genInterface.booleanValue()) {
                stringBuffer.append(this.TEXT_12);
            }
            stringBuffer.append(this.TEXT_13);
            if (!genInterface.booleanValue()) {
                if (realizedType != null && !realizedType.isEmpty()) {
                    stringBuffer.append(this.TEXT_14);
                    stringBuffer.append(realizedType);
                    stringBuffer.append("\")");
                }
                if (testerClass != null && !testerClass.isEmpty()) {
                    stringBuffer.append(this.TEXT_16);
                    stringBuffer.append(testerClass);
                    stringBuffer.append("\")");
                }
            }
            stringBuffer.append(this.TEXT_18);
            stringBuffer.append(fqnGeneratorClassName);
            stringBuffer.append(this.TEXT_19);
            stringBuffer.append(GenerateUtil.getISO8601Timestamp());
            stringBuffer.append(this.TEXT_20);
            if (genInterface.booleanValue()) {
                stringBuffer.append("interface");
            } else {
                stringBuffer.append("class");
            }
            stringBuffer.append(" ");
            stringBuffer.append(className);
            if (hasRealizedType.booleanValue()) {
                stringBuffer.append(" extends ");
                stringBuffer.append(realizedTypeFqn);
            }
            if (!genInterface.booleanValue()) {
                stringBuffer.append(" implements ");
                stringBuffer.append(implementedTypeFqn);
            }
            stringBuffer.append(" {");
            if (!genInterface.booleanValue()) {
                if (hasRealizedType.booleanValue()) {
                    if (hasDefaultMapping.booleanValue()) {
                        stringBuffer.append(this.TEXT_27);
                        stringBuffer.append(className);
                        stringBuffer.append(this.TEXT_28);
                    } else {
                        stringBuffer.append(this.TEXT_29);
                        stringBuffer.append(className);
                        stringBuffer.append(this.TEXT_30);
                    }
                } else if (hasDefaultMapping.booleanValue()) {
                    stringBuffer.append(this.TEXT_31);
                    stringBuffer.append(className);
                    stringBuffer.append(this.TEXT_32);
                } else {
                    stringBuffer.append(this.TEXT_33);
                    stringBuffer.append(className);
                    stringBuffer.append(this.TEXT_34);
                }
            }
            stringBuffer.append(this.TEXT_35);
            if (!genInterface.booleanValue() && hasDefaultMapping.booleanValue()) {
                stringBuffer.append(this.TEXT_36);
                if (hasComponentClass.booleanValue()) {
                    stringBuffer.append(this.TEXT_37);
                    stringBuffer.append(componentClassName);
                    stringBuffer.append(this.TEXT_38);
                } else {
                    stringBuffer.append(this.TEXT_39);
                }
                stringBuffer.append(this.TEXT_40);
            }
            stringBuffer.append(this.TEXT_41);
            if (superActions != null) {
                actions.removeAll(superActions);
            }
            for (Action action : actions) {
                Param param;
                Iterator paramIterator;
                if (action.isITEInvolved()) continue;
                String methodName = nameLoader.translateFromCompSystem(action.getName());
                String actionDescription = "";
                String actionDescrKey = action.getDescriptionKey();
                if (actionDescrKey != null) {
                    actionDescription = CompSystemI18n.getString((String)actionDescrKey);
                }
                compNameMap.put(action.getName(), methodName);
                List params = action.getParams();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                HashMap<String, String> paramTypeMap = new HashMap<String, String>();
                if (!params.isEmpty()) {
                    paramIterator = params.iterator();
                    stringBuffer.append(this.TEXT_42);
                    stringBuffer.append(actionDescription);
                    stringBuffer.append(this.TEXT_43);
                    while (paramIterator.hasNext()) {
                        param = (Param)paramIterator.next();
                        String paramName = nameLoader.translateFromCompSystem(param.getName());
                        String paramDescription = "";
                        String paramDescrKey = param.getDescriptionKey();
                        if (paramDescrKey != null) {
                            paramDescription = CompSystemI18n.getString((String)paramDescrKey);
                        }
                        stringBuffer.append("* @param ");
                        stringBuffer.append(paramName);
                        stringBuffer.append(this.TEXT_45);
                        stringBuffer.append(paramDescription);
                        stringBuffer.append(this.TEXT_46);
                    }
                    stringBuffer.append(this.TEXT_47);
                }
                if (action.isDeprecated()) {
                    stringBuffer.append("@Deprecated");
                }
                stringBuffer.append(this.TEXT_49);
                stringBuffer.append(methodName);
                stringBuffer.append("(");
                paramIterator = params.iterator();
                while (paramIterator.hasNext()) {
                    param = (Param)paramIterator.next();
                    boolean hasCombineableValueSet = param.hasValueSet() && param.getValueSet().isCombinable();
                    String type = param.getType();
                    String name = param.getName();
                    String fqParamType = nameLoader.findTypeForParameter(type, name);
                    String paramType = NameLoader.beautifyParamType(fqParamType);
                    String paramName = nameLoader.translateFromCompSystem(name);
                    String fixedType = nameLoader.getRealTypeForParameter(type, name);
                    paramMap.put(name, fqParamType);
                    paramTypeMap.put(name, fixedType);
                    stringBuffer.append(this.TEXT_51);
                    stringBuffer.append(paramType);
                    if (hasCombineableValueSet) {
                        stringBuffer.append("[]");
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(paramName);
                    if (!paramIterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.TEXT_55);
                if (!params.isEmpty()) {
                    stringBuffer.append("throws IllegalArgumentException");
                }
                if (genInterface.booleanValue()) {
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_58);
                    stringBuffer.append(action.getMethod());
                    stringBuffer.append(this.TEXT_59);
                    stringBuffer.append(hasDefaultMapping);
                    stringBuffer.append(");");
                    if (!hasDefaultMapping.booleanValue()) {
                        stringBuffer.append(this.TEXT_61);
                    } else {
                        stringBuffer.append(this.TEXT_62);
                    }
                    for (Param parameter : params) {
                        boolean hasCombineableValueSet = parameter.hasValueSet() && parameter.getValueSet().isCombinable();
                        String paramName = parameter.getName();
                        String translatedParamName = nameLoader.translateFromCompSystem(paramName);
                        stringBuffer.append(this.TEXT_63);
                        stringBuffer.append(translatedParamName);
                        stringBuffer.append(", \"Argument '");
                        stringBuffer.append(translatedParamName);
                        stringBuffer.append("' must not be null\"); //$NON-NLS-1$");
                        String paramEnumType = (String)paramMap.get(paramName);
                        String fqParamType = (String)paramTypeMap.get(paramName);
                        if (nameLoader.isInEnumMap(paramEnumType)) {
                            if (!hasCombineableValueSet) {
                                stringBuffer.append(this.TEXT_66);
                                stringBuffer.append(translatedParamName);
                                stringBuffer.append(".rcValue(), \"");
                                stringBuffer.append(fqParamType);
                                stringBuffer.append("\")); //$NON-NLS-1$");
                                continue;
                            }
                            stringBuffer.append(this.TEXT_69);
                            stringBuffer.append(translatedParamName);
                            stringBuffer.append(", \"Elements of argument '");
                            stringBuffer.append(translatedParamName);
                            stringBuffer.append(this.TEXT_71);
                            stringBuffer.append(translatedParamName);
                            stringBuffer.append(", TestDataConstants.COMBI_VALUE_SEPARATOR), \"");
                            stringBuffer.append(fqParamType);
                            stringBuffer.append("\")); //$NON-NLS-1$");
                            continue;
                        }
                        stringBuffer.append(this.TEXT_74);
                        stringBuffer.append(translatedParamName);
                        stringBuffer.append("), \"");
                        stringBuffer.append(fqParamType);
                        stringBuffer.append("\")); //$NON-NLS-1$");
                    }
                    stringBuffer.append(this.TEXT_77);
                }
                stringBuffer.append(this.TEXT_78);
            }
            stringBuffer.append(this.TEXT_79);
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }
}

