/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen.internal.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;

public class NameLoader {
    private static final String RESOURCES_NAMEMAPPINGS_PROPERTIES = "resources/nameMappings.properties";
    private static final String RESOURCES_ENUMMAPPINGS_PROPERTIES = "resources/enumMappings.properties";
    private static final String PACKAGE_BASE_PATH = "org.eclipse.jubula.toolkit.";
    private static final String INTERNAL = ".internal";
    private static final String PACKAGE_SPECIFIC_INTERFACE = ".components";
    private static final String PACKAGE_SPECIFIC_IMPLCLASS = ".internal.impl";
    private static final String FACTORY_NAME_EXTENSION = "Components";
    private static final String TOOLKITINFO_NAME_EXTENSION = "ToolkitInfo";
    private static Pattern javaLang = Pattern.compile("java\\.lang\\.([A-Z][a-zA-Z]*)");
    private static Pattern jubulaEnum = Pattern.compile("org\\.eclipse\\.jubula\\.toolkit\\.enums\\.ValueSets\\.([A-Z][a-zA-Z]*)");
    private static NameLoader instance = null;
    private Properties m_mappingProperties;
    private Properties m_enumMappingProperties;

    private NameLoader() {
        try {
            URL nameResourceURL = NameLoader.class.getClassLoader().getResource(RESOURCES_NAMEMAPPINGS_PROPERTIES);
            this.m_mappingProperties = new Properties();
            this.m_mappingProperties.load(nameResourceURL.openStream());
            URL enumResourceURL = NameLoader.class.getClassLoader().getResource(RESOURCES_ENUMMAPPINGS_PROPERTIES);
            this.m_enumMappingProperties = new Properties();
            this.m_enumMappingProperties.load(enumResourceURL.openStream());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static NameLoader getInstance() {
        if (instance == null) {
            instance = new NameLoader();
        }
        return instance;
    }

    public String translateFromCompSystem(String name) {
        String desiredName = CompSystemI18n.getString((String)name);
        desiredName = desiredName.replace("-", " ").replace("(", " ").replace(")", " ").replace("/", " ");
        desiredName = WordUtils.capitalize((String)desiredName);
        desiredName = StringUtils.deleteWhitespace((String)desiredName);
        desiredName = WordUtils.uncapitalize((String)desiredName);
        return desiredName;
    }

    public String findTypeForParameter(String type, String name) {
        String mapEntry = this.m_enumMappingProperties.getProperty(name);
        if (mapEntry != null) {
            return mapEntry;
        }
        return this.getRealTypeForParameter(type, name);
    }

    public String getRealTypeForParameter(String type, String name) {
        String mapEntry = this.m_mappingProperties.getProperty(type);
        if (mapEntry != null) {
            return mapEntry;
        }
        return type;
    }

    public String getClassPackageName(String toolkitName) {
        return String.valueOf(this.getToolkitPackageName(toolkitName, false)) + PACKAGE_SPECIFIC_IMPLCLASS;
    }

    public String getInterfacePackageName(String toolkitName) {
        return String.valueOf(this.getToolkitPackageName(toolkitName, false)) + PACKAGE_SPECIFIC_INTERFACE;
    }

    public String getToolkitPackageName(String toolkitName, boolean internal) {
        String basePackageName = PACKAGE_BASE_PATH + toolkitName;
        if (internal) {
            basePackageName = String.valueOf(basePackageName) + INTERNAL;
        }
        return basePackageName;
    }

    public String getClassName(String name) {
        String desiredName = CompSystemI18n.getString((String)name);
        if ((desiredName = desiredName.replace("/", " ")).startsWith("(")) {
            desiredName = StringUtils.substringAfter((String)desiredName, (String)")");
        }
        desiredName = desiredName.replace("(", " ").replace(")", " ");
        desiredName = WordUtils.capitalize((String)desiredName);
        desiredName = StringUtils.deleteWhitespace((String)desiredName);
        return desiredName;
    }

    public String getToolkitName(ToolkitDescriptor toolkitDesriptor) {
        return toolkitDesriptor.getName().toLowerCase();
    }

    public String executeExceptions(String string) {
        return string.replace("abstract", "base");
    }

    public String getFactoryName(String toolkitName) {
        String tkName = WordUtils.capitalize((String)toolkitName);
        return String.valueOf(tkName) + FACTORY_NAME_EXTENSION;
    }

    public String getToolkitComponentClassName(String toolkitName) {
        String tkName = WordUtils.capitalize((String)toolkitName);
        return String.valueOf(tkName) + TOOLKITINFO_NAME_EXTENSION;
    }

    public boolean isInEnumMap(String name) {
        return this.m_enumMappingProperties.containsValue(name);
    }

    public String getEnumForParam(String paramType) {
        return this.m_enumMappingProperties.getProperty(paramType);
    }

    public static String beautifyParamType(String paramType) {
        if (javaLang.matcher(paramType).matches()) {
            return paramType.replaceAll(javaLang.pattern(), "$1");
        }
        if (jubulaEnum.matcher(paramType).matches()) {
            return paramType.replaceAll(jubulaEnum.pattern(), "$1");
        }
        return paramType;
    }
}

