/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ConnectAutAgentBP;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.dialogs.nag.RCPAUTStartDelayNagTask;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractStartTestHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.AutAgentManager;
import org.eclipse.jubula.client.ui.rcp.utils.JBThread;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendCompSystemI18nMessage;
import org.eclipse.jubula.communication.internal.message.StopAUTServerMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutionGUIController {
    static final Logger LOG = LoggerFactory.getLogger(TestExecutionGUIController.class);
    private static final int NAGGER_TIMEOUT = 120000;

    private TestExecutionGUIController() {
    }

    public static void startAUT(final IAUTMainPO aut, final IAUTConfigPO conf) {
        new JBThread(){
            private TimerTask m_infoRCPTask = null;

            public void run() {
                if (aut.getToolkit().equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                    AutIdentifier autId = new AutIdentifier((String)conf.getConfigMap().get("AUT_ID"));
                    this.m_infoRCPTask = new RCPAUTStartDelayNagTask(autId);
                    Timer timer = new Timer();
                    try {
                        timer.schedule(this.m_infoRCPTask, 120000L);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                TestExecutionContributor.getInstance().startAUTaction(aut, conf);
            }

            public void interrupt() {
                TestExecutionGUIController.disconnectFromServer();
                if (this.m_infoRCPTask != null) {
                    this.m_infoRCPTask.cancel();
                }
                super.interrupt();
            }

            @Override
            protected void errorOccured() {
                if (this.m_infoRCPTask != null) {
                    this.m_infoRCPTask.cancel();
                }
            }
        }.start();
    }

    public static void stopAUT(AutIdentifier autId) {
        TestExecutionContributor.getInstance().stopAUT(autId);
    }

    public static void startTestSuite(final ITestSuitePO ts, final AutIdentifier autId, final boolean autoScreenshot) {
        TestExecutionContributor.setClientMinimized(true);
        JBThread t = new JBThread("Initialize Test Execution"){

            public void run() {
                if (!AbstractStartTestHandler.prepareTestExecution()) {
                    TestExecutionGUIController.stopTestSuite();
                }
                TestExecutionContributor.getInstance().startTestSuiteAction(ts, autId, autoScreenshot);
            }

            @Override
            protected void errorOccured() {
            }
        };
        t.start();
        ts.setStarted(true);
    }

    public static void stopTestSuite() {
        JBThread t = new JBThread(){

            public void run() {
                TestExecutionContributor.getInstance().stopTestSuiteAction();
                List testSuites = TestSuiteBP.getListOfTestSuites();
                for (ITestSuitePO ts : testSuites) {
                    ts.setStarted(false);
                }
            }

            @Override
            protected void errorOccured() {
            }
        };
        t.start();
    }

    public static void connectToAutAgent(final AutAgentManager.AutAgent autAgent) {
        DataEventDispatcher.getInstance().fireAutAgentConnectionChanged(DataEventDispatcher.ServerState.Connecting);
        final String jobName = NLS.bind((String)Messages.UIJobConnectToAUTAgent, (Object[])new Object[]{autAgent.getName(), String.valueOf(autAgent.getPort())});
        Job connectToAUTAgent = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                TestExecutionGUIController.connectToAutAgentImpl(autAgent);
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family == AutAgentConnection.CONNECT_TO_AGENT_JOB_FAMILY_ID) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        JobUtils.executeJob((Job)connectToAUTAgent, null);
        ConnectAutAgentBP.getInstance().setCurrentAutAgent(autAgent);
    }

    public static void disconnectFromServer() {
        JBThread t = new JBThread(){

            public void run() {
                try {
                    if (AUTConnection.getInstance().isConnected()) {
                        AutAgentConnection.getInstance().request((Message)new StopAUTServerMessage(), new ICommand(){

                            public Message execute() {
                                return null;
                            }

                            public Message getMessage() {
                                return null;
                            }

                            public void setMessage(Message message) {
                            }

                            public void timeout() {
                            }
                        }, 2000);
                    }
                }
                catch (BaseConnection.NotConnectedException notConnectedException) {
                }
                catch (ConnectionException connectionException) {
                }
                catch (CommunicationException communicationException) {}
                TestExecutionContributor.getInstance().disconnectFromAutAgent();
            }

            @Override
            protected void errorOccured() {
            }
        };
        t.start();
    }

    private static void connectToAutAgentImpl(AutAgentManager.AutAgent autAgent) {
        TestExecutionContributor.getInstance().connectToAutAgent(autAgent.getName(), autAgent.getPort().toString());
        try {
            AutAgentConnection connection = AutAgentConnection.getInstance();
            if (connection.isConnected()) {
                SendCompSystemI18nMessage message = new SendCompSystemI18nMessage();
                message.setResourceBundles(CompSystemI18n.bundlesToString());
                try {
                    connection.send((Message)message);
                }
                catch (BaseConnection.NotConnectedException e) {
                    LOG.error("Could not send CompSystemI18nResourceBundle to AutAgent", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Could not send CompSystemI18nResourceBundle to AutAgent", (Throwable)e);
                }
                catch (CommunicationException e) {
                    LOG.error("Could not send CompSystemI18nResourceBundle to AutAgent", (Throwable)e);
                }
            }
        }
        catch (ConnectionException connectionException) {
            DataEventDispatcher.getInstance().fireAutAgentConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
        }
        if (Plugin.getActiveView() != null) {
            Plugin.showStatusLine((IWorkbenchPart)Plugin.getActiveView());
        }
    }
}

