/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.I18nStringCombo;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TestResultPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 4;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private static final String[] REPORT_STYLES = new String[]{"StyleComplete", "StyleErrorsOnly"};
    private static final String REPORT_STYLE_BASIC_KEY = "TestResultViewPreferencePage";
    private Text m_path = null;
    private Button m_openResultView = null;
    private Button m_trackResults = null;
    private Button m_autoScreenshots = null;
    private Button m_generateReport = null;
    private Combo m_reportStyle = null;
    private Button m_browser = null;
    private Text m_numberOfDays = null;
    private boolean m_testExecRememberValue;

    public TestResultPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.setMessage(Messages.TestResultViewPreferencePageTitle, 0);
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        final Composite composite = new Composite((Composite)scrollComposite, 0);
        this.compositeGridData(composite);
        this.createOpenResultView(composite);
        this.createGenerateReport(composite);
        this.createMaxNumberOfResults(composite);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageTestResultContextId");
        this.initPreferences();
        scrollComposite.setContent((Control)composite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrollComposite.setMinSize(composite.computeSize(-1, -1));
            }
        });
        return scrollComposite;
    }

    private void createMaxNumberOfResults(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(LayoutUtil.BOLD_TAHOMA);
        label.setText(Messages.TestResultViewPreferencePageMaxNumberOfDaysText);
        GridData gridData = new GridData(768);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_numberOfDays = this.newTextField(composite);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_numberOfDays);
        this.m_numberOfDays.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_numberOfDays.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TestResultPreferencePage.this.checkCompleteness();
            }
        });
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 4;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)compositeData);
    }

    protected void checkCompleteness() {
        String path = this.m_path.getText().trim();
        boolean writeResult = this.m_generateReport.getSelection();
        if (writeResult && path.equals("")) {
            this.setErrorMessage(Messages.TestResultViewPreferencePagePathEmpty);
            this.setValid(false);
            return;
        }
        File dir = new File(path);
        boolean valid = true;
        if (writeResult) {
            if (dir.isDirectory() && dir.exists()) {
                File file = new File(String.valueOf(dir.getAbsolutePath()) + "/tmp.xml");
                try {
                    boolean created = false;
                    if (!file.exists()) {
                        file.createNewFile();
                        created = true;
                    }
                    if (!file.canWrite()) {
                        valid = false;
                    }
                    if (created) {
                        file.delete();
                    }
                }
                catch (IOException iOException) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        if (!valid) {
            this.setErrorMessage(Messages.TestResultViewPreferencePagePathInvalid);
            this.setValid(false);
            return;
        }
        String numberOfResults = this.m_numberOfDays.getText().trim();
        try {
            int noOfResults = Integer.parseInt(numberOfResults);
            if (noOfResults < 1) {
                this.setErrorMessage(Messages.TestResultViewPreferencePageInvalidNegMaxNumberOfDays);
                this.setValid(false);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.TestResultViewPreferencePageInvalidMaxNumberOfDays);
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.TestResultViewPreferencePageTitle, 0);
        this.setValid(true);
    }

    private Text newTextField(Composite parent) {
        Text textField = new Text(parent, 2048);
        GridData textGrid = new GridData(4, 2, true, false, 3, 1);
        textGrid.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)textField), (int)30);
        textField.setLayoutData((Object)textGrid);
        return textField;
    }

    private void createOpenResultView(Composite parent) {
        this.m_openResultView = new Button(parent, 32);
        this.m_openResultView.setText(Messages.TestResultViewPreferencePageOpenResultView);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = false;
        this.m_openResultView.setLayoutData((Object)gridData);
        this.m_trackResults = new Button(parent, 32);
        this.m_trackResults.setText(Messages.TestResultViewPreferencePageTrackResults);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = false;
        this.m_trackResults.setLayoutData((Object)gridData);
        this.m_autoScreenshots = new Button(parent, 32);
        this.m_autoScreenshots.setText(Messages.TestResultViewPreferencePageAutoScreenshots);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = false;
        this.m_autoScreenshots.setLayoutData((Object)gridData);
    }

    private void createGenerateReport(Composite parent) {
        this.m_generateReport = new Button(parent, 32);
        this.m_generateReport.setText(Messages.TestResultViewPreferencePageGenerateReport);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_generateReport.setLayoutData((Object)gridData);
        this.m_generateReport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestResultPreferencePage.this.enableReportStyleCombo();
                TestResultPreferencePage.this.enableLogFileBrowser();
                TestResultPreferencePage.this.checkCompleteness();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createReportStyleCombo(parent);
        Label label = new Label(parent, 0);
        label.setFont(LayoutUtil.BOLD_TAHOMA);
        label.setText(Messages.TestResultViewPreferencePagePathText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_path = this.newTextField(parent);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_path);
        this.m_path.setLayoutData((Object)gridData);
        this.m_browser = new Button(parent, 0);
        gridData = new GridData(128);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_browser.setLayoutData((Object)gridData);
        this.m_browser.setText(Messages.TestResultViewPreferencePageBrowse);
        this.m_path.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TestResultPreferencePage.this.checkCompleteness();
            }
        });
        this.m_browser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(TestResultPreferencePage.this.getShell(), 65536);
                directoryDialog.setMessage(Messages.TestResultViewPreferencePageDirSelector);
                directoryDialog.setFilterPath(TestResultPreferencePage.this.getPath());
                String directory = directoryDialog.open();
                if (directory != null) {
                    TestResultPreferencePage.this.setPath(directory);
                }
                TestResultPreferencePage.this.checkCompleteness();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createReportStyleCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setFont(LayoutUtil.BOLD_TAHOMA);
        label.setText(Messages.TestResultViewPreferencePageStyleText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_reportStyle = new I18nStringCombo(parent, 0, REPORT_STYLE_BASIC_KEY, Arrays.asList(REPORT_STYLES), false, false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_reportStyle);
        this.m_reportStyle.setLayoutData((Object)gridData);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.TestResultViewPreferencePageDescription);
    }

    protected void performDefaults() {
        this.m_openResultView.setSelection(this.getDefaultPrefsBool("OPENRESULTVIEW_PREF_KEY"));
        this.m_generateReport.setSelection(this.getDefaultPrefsBool("GENERATEREPORT_KEY"));
        this.m_trackResults.setSelection(this.getDefaultPrefsBool("TRACKRESULTS_PREF_KEY"));
        this.m_autoScreenshots.setSelection(this.getDefaultPrefsBool("AUTO_SCREENSHOT_PREF_KEY"));
        this.m_testExecRememberValue = this.getPreferenceStore().getDefaultBoolean("TEST_EXECUTION_RELEVANT_REMEMBER_KEY");
        this.m_reportStyle.setText(this.getDefaultPrefsString("REPORTGENERATORSTYLE_KEY"));
        this.m_reportStyle.setEnabled(this.m_generateReport.getSelection());
        this.m_path.setText(this.getDefaultPrefsString("RESULTPATH_PREF_KEY"));
        this.m_path.setEnabled(this.m_generateReport.getSelection());
        this.m_numberOfDays.setText(this.getDefaultPrefsString("MAX_NUMBER_OF_DAYS_KEY"));
        this.setErrorMessage(null);
        this.setMessage(Messages.TestResultViewPreferencePageTitle, 0);
        this.setValid(true);
    }

    private boolean getDefaultPrefsBool(String key) {
        return this.getPreferenceStore().getDefaultBoolean(key);
    }

    protected void initPreferences() {
        this.m_openResultView.setSelection(this.getPreferenceStore().getBoolean("OPENRESULTVIEW_PREF_KEY"));
        this.m_generateReport.setSelection(this.getPreferenceStore().getBoolean("GENERATEREPORT_KEY"));
        this.m_trackResults.setSelection(this.getPreferenceStore().getBoolean("TRACKRESULTS_PREF_KEY"));
        this.m_autoScreenshots.setSelection(this.getPreferenceStore().getBoolean("AUTO_SCREENSHOT_PREF_KEY"));
        this.m_reportStyle.setText(this.getPreferenceStore().getString("REPORTGENERATORSTYLE_KEY"));
        this.m_path.setText(this.getPreferenceStore().getString("RESULTPATH_PREF_KEY"));
        this.m_numberOfDays.setText(this.getPreferenceStore().getString("MAX_NUMBER_OF_DAYS_KEY"));
        this.enableReportStyleCombo();
        this.enableLogFileBrowser();
    }

    private String getDefaultPrefsString(String key) {
        return this.getPreferenceStore().getDefaultString(key);
    }

    public boolean performOk() {
        boolean openResult = this.m_openResultView.getSelection();
        boolean generateReport = this.m_generateReport.getSelection();
        boolean trackResults = this.m_trackResults.getSelection();
        boolean autoScreenshots = this.m_autoScreenshots.getSelection();
        this.getPreferenceStore().setValue("OPENRESULTVIEW_PREF_KEY", openResult);
        this.getPreferenceStore().setValue("GENERATEREPORT_KEY", generateReport);
        this.getPreferenceStore().setValue("TRACKRESULTS_PREF_KEY", trackResults);
        this.getPreferenceStore().setValue("AUTO_SCREENSHOT_PREF_KEY", autoScreenshots);
        this.getPreferenceStore().setValue("REPORTGENERATORSTYLE_KEY", this.m_reportStyle.getText());
        this.getPreferenceStore().setValue("RESULTPATH_PREF_KEY", this.m_path.getText());
        this.getPreferenceStore().setValue("MAX_NUMBER_OF_DAYS_KEY", this.m_numberOfDays.getText());
        this.getPreferenceStore().setValue("TEST_EXECUTION_RELEVANT_REMEMBER_KEY", this.m_testExecRememberValue);
        return super.performOk();
    }

    protected void performApply() {
        this.performOk();
    }

    protected void enableLogFileBrowser() {
        this.m_path.setEnabled(this.m_generateReport.getSelection());
        this.m_browser.setEnabled(this.m_generateReport.getSelection());
    }

    protected void enableReportStyleCombo() {
        this.m_reportStyle.setEnabled(this.m_generateReport.getSelection());
    }

    protected String getPath() {
        return this.m_path.getText();
    }

    protected void setPath(String path) {
        this.m_path.setText(path);
    }
}

