/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the {@link org.eclipse.draw2d.FigureCanvas} component from the gef toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@TesterClass(testerClass="org.eclipse.jubula.rc.rcp.e3.gef.tester.FigureCanvasTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2016-01-26T10:17:11.360Z")
public class FigureCanvas extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.gef.components.FigureCanvas {
            public FigureCanvas(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkFigureExistence(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckFigureExists"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkToolExistence(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckToolExists"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcClickFigure"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickInFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcClickInFigure"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectTool(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelectTool"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickConnection(
            @NonNull String sourceTextPath,
            @NonNull String sourceOperator,
            @NonNull String targetTextPath,
            @NonNull String targetOperator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcClickConnection"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(sourceTextPath, "Argument 'sourceTextPath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(sourceTextPath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(sourceOperator, "Argument 'sourceOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(sourceOperator), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(targetTextPath, "Argument 'targetTextPath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(targetTextPath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(targetOperator, "Argument 'targetOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(targetOperator), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDragFigure"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDropOnFigure"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayBeforeDropMilliseconds), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkFigureProperty(
            @NonNull String textpath,
            @NonNull Operator textOperator,
            @NonNull String propertyName,
            @NonNull String propertyValue,
            @NonNull Operator valueOperator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyFigureProperty"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(textOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(propertyName), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(propertyValue), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
} 