/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the Locator component from the html toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2016-01-26T10:17:11.436Z")
public interface Locator {
    
    
        /**
         * 
         * @param xPath 
         *        the XPath to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkXPathCount(
            @NonNull String xPath,
            @NonNull String comparisonMethod,
            @NonNull Integer count
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param cSSPath 
         *        the CSS path to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkCSSPathCount(
            @NonNull String cSSPath,
            @NonNull String comparisonMethod,
            @NonNull Integer count
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @param operator 
         *        the operator used for comparison
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkText(
            @NonNull String locator,
            @NonNull Operator operator,
            @NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP click(
            @NonNull String locator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @param locator 
         *        the locator to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForComponent(
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility,
            @NonNull String locator
        ) throws IllegalArgumentException;
        
} 