/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the Picker component from the ios toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2016-01-26T10:17:11.482Z")
public interface Picker extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent {
    
    
        /**
         * 
         * @param direction 
         *        the direction
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP swipe(
            @NonNull Direction direction
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByValueInColumn(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull Boolean exists,
            @NonNull Integer column
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByIndexInColumn(
            @NonNull String index,
            @NonNull Boolean selected,
            @NonNull Integer column
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectEntryByIndexInColumn(
            @NonNull String index,
            @NonNull Integer column
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectEntryByValueInColumn(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull SearchType searchType,
            @NonNull Integer column
        ) throws IllegalArgumentException;
        
} 