/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.bp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.model.ALMChange;
import org.eclipse.jubula.client.alm.mylyn.core.model.CommentEntry;
import org.eclipse.jubula.client.alm.mylyn.core.model.FieldUpdate;
import org.eclipse.jubula.client.alm.mylyn.core.utils.ALMAccess;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.businessprocess.TestresultSummaryBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IALMReportingProperties;
import org.eclipse.jubula.client.core.model.IALMReportingRulePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.ReportRuleType;
import org.eclipse.jubula.client.core.utils.TestResultNodeTraverser;
import org.eclipse.osgi.util.NLS;

public class CommentReporter
implements DataEventDispatcher.ITestresultSummaryEventListener {
    private static CommentReporter instance;
    private IProgressConsole m_console;
    private IALMReportingProperties m_reportProps = null;

    private CommentReporter() {
        DataEventDispatcher.getInstance().addTestresultSummaryEventListener((DataEventDispatcher.ITestresultSummaryEventListener)this);
    }

    public static CommentReporter getInstance() {
        if (instance == null) {
            instance = new CommentReporter();
        }
        return instance;
    }

    private IStatus processResultTree(IProgressMonitor monitor, boolean reportSuccess, boolean reportFailure, List<IALMReportingRulePO> reportingRules, ITestResultSummaryPO summary, TestResultNode rootResultNode) {
        HashMap<String, List<ALMChange>> taskIdToALMChange = new HashMap<String, List<ALMChange>>();
        ALMChangeCreationOperation operation = new ALMChangeCreationOperation(taskIdToALMChange, reportFailure, reportSuccess, reportingRules, this.m_reportProps.getDashboardURL(), summary);
        TestResultNodeTraverser traverser = new TestResultNodeTraverser(rootResultNode, (ITreeNodeOperation)operation);
        traverser.traverse();
        IStatus reportStatus = this.reportToALM(monitor, taskIdToALMChange);
        if (reportStatus.isOK()) {
            TestresultSummaryBP.getInstance().setALMReportStatus(summary, ITestResultSummaryPO.AlmReportStatus.REPORTED);
        }
        return reportStatus;
    }

    private IStatus reportToALM(IProgressMonitor monitor, Map<String, List<ALMChange>> taskIdToALMChange) {
        String repoLabel = this.m_reportProps.getALMRepositoryName();
        boolean failed = false;
        Set<String> taskIds = taskIdToALMChange.keySet();
        int taskAmount = taskIds.size();
        IProgressConsole c = this.getConsole();
        int successCount = 0;
        if (taskAmount > 0) {
            String out = NLS.bind((String)Messages.ReportToALMJob, (Object)taskAmount, (Object)repoLabel);
            monitor.beginTask(out, taskAmount);
            c.writeLine(out);
            int overallCommentCount = 0;
            int overallFieldUpdateCount = 0;
            for (String taskId : taskIds) {
                int fieldUpdateAmount;
                List<ALMChange> changes = taskIdToALMChange.get(taskId);
                LinkedList<CommentEntry> comments = new LinkedList<CommentEntry>();
                LinkedList<FieldUpdate> fieldUpdates = new LinkedList<FieldUpdate>();
                this.split(changes, comments, fieldUpdates);
                boolean commentingSucceeded = true;
                IStatus fieldUpdateStatus = Status.OK_STATUS;
                int commentAmount = comments.size();
                if (commentAmount > 0) {
                    this.writeStatus(c, taskId, commentAmount, Messages.ReportingComment, Messages.ReportingComments);
                    commentingSucceeded = ALMAccess.createComment(repoLabel, taskId, comments, monitor);
                    if (!commentingSucceeded) {
                        failed = true;
                        c.writeErrorLine(NLS.bind((String)Messages.ReportingTaskFailed, (Object)taskId));
                    } else {
                        overallCommentCount += commentAmount;
                    }
                }
                if ((fieldUpdateAmount = fieldUpdates.size()) > 0) {
                    this.writeStatus(c, taskId, fieldUpdateAmount, Messages.ReportingFieldUpdate, Messages.ReportingFieldUpdates);
                    fieldUpdateStatus = ALMAccess.updateFields(repoLabel, taskId, fieldUpdates, monitor);
                    if (!fieldUpdateStatus.isOK()) {
                        failed = true;
                        c.writeErrorLine(fieldUpdateStatus.getMessage());
                        c.writeErrorLine(NLS.bind((String)Messages.ReportingTaskFailed, (Object)taskId));
                        if (fieldUpdateStatus.getSeverity() == 8) {
                            break;
                        }
                    } else {
                        overallFieldUpdateCount += fieldUpdateAmount;
                    }
                }
                if (fieldUpdateStatus.isOK() && commentingSucceeded) {
                    ++successCount;
                }
                monitor.worked(1);
            }
            c.writeLine(NLS.bind((String)Messages.ReportToALMJobDone, (Object[])new Integer[]{overallCommentCount, overallFieldUpdateCount, successCount, taskAmount}));
            monitor.done();
        } else {
            c.writeLine(Messages.NothingToReport);
        }
        if (!failed || successCount > 0) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", "Reporting comments performed with errors...");
    }

    private void writeStatus(IProgressConsole c, String taskId, int changeAmount, String one, String mult) {
        if (changeAmount > 1) {
            c.writeWarningLine(NLS.bind((String)mult, (Object)changeAmount, (Object)taskId));
        } else {
            c.writeLine(NLS.bind((String)one, (Object)taskId));
        }
    }

    private void split(List<ALMChange> changes, List<CommentEntry> comments, List<FieldUpdate> fieldUpdates) {
        for (ALMChange change : changes) {
            if (change instanceof CommentEntry) {
                comments.add((CommentEntry)change);
                continue;
            }
            if (!(change instanceof FieldUpdate)) continue;
            fieldUpdates.add((FieldUpdate)change);
        }
    }

    public IProgressConsole getConsole() {
        return this.m_console;
    }

    public void setConsole(IProgressConsole console) {
        this.m_console = console;
    }

    public void handleTestresultSummaryChanged(ITestResultSummaryPO summary, DataEventDispatcher.DataState state) {
        if (state != DataEventDispatcher.DataState.Added) {
            return;
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        TestResult resultTestModel = TestResultBP.getInstance().getResultTestModel();
        TestResultNode rootResultNode = resultTestModel.getRootResultNode();
        Job job = this.gatherInformationAndCreateReportToALMJob(summary, (IALMReportingProperties)project.getProjectProperties(), rootResultNode);
        if (job != null) {
            job.schedule();
        }
    }

    public Job gatherInformationAndCreateReportToALMJob(final ITestResultSummaryPO summary, IALMReportingProperties properties, final TestResultNode rootResultNode) {
        this.m_reportProps = properties;
        final boolean reportSuccess = properties.getIsReportOnSuccess();
        final boolean reportFailure = properties.getIsReportOnFailure();
        final List reportingRules = properties.getALMReportingRules();
        final String almRepositoryName = properties.getALMRepositoryName();
        if (!StringUtils.isBlank((String)almRepositoryName) && (reportSuccess || reportFailure || !reportingRules.isEmpty()) && summary.isTestsuiteRelevant()) {
            Job reportToALMOperation = new Job(NLS.bind((String)Messages.ReportToALMJobName, (Object)almRepositoryName)){

                protected IStatus run(IProgressMonitor monitor) {
                    CommentReporter.this.getConsole().writeLine(NLS.bind((String)Messages.TaskRepositoryConnectionTest, (Object)almRepositoryName));
                    IStatus connectionStatus = ALMAccess.testConnection(almRepositoryName);
                    if (connectionStatus.isOK()) {
                        CommentReporter.this.getConsole().writeLine(NLS.bind((String)Messages.TaskRepositoryConnectionTestSucceeded, (Object)almRepositoryName));
                        return CommentReporter.this.processResultTree(monitor, reportSuccess, reportFailure, reportingRules, summary, rootResultNode);
                    }
                    CommentReporter.this.getConsole().writeErrorLine(NLS.bind((String)Messages.TaskRepositoryConnectionTestFailed, (Object)connectionStatus.getMessage()));
                    return connectionStatus;
                }
            };
            return reportToALMOperation;
        }
        return null;
    }

    private static class ALMChangeCreationOperation
    implements ITreeNodeOperation<TestResultNode> {
        private Map<String, List<ALMChange>> m_taskIdToALMChange;
        private final boolean m_reportFailure;
        private final boolean m_reportSuccess;
        private final List<IALMReportingRulePO> m_reportingRules;
        private String m_dashboardURL;
        private ITestResultSummaryPO m_summary;
        private long m_nodeCount = 0L;

        public ALMChangeCreationOperation(Map<String, List<ALMChange>> taskIdToALMChange, boolean reportFailure, boolean reportSuccess, List<IALMReportingRulePO> reportingRules, String dashboardURL, ITestResultSummaryPO summary) {
            this.m_taskIdToALMChange = taskIdToALMChange;
            this.m_reportFailure = reportFailure;
            this.m_reportSuccess = reportSuccess;
            this.m_reportingRules = reportingRules;
            this.m_dashboardURL = dashboardURL;
            this.m_summary = summary;
        }

        public boolean operate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode resultNode, boolean alreadyVisited) {
            boolean writeFieldUpdateForNode;
            ++this.m_nodeCount;
            boolean didNodePass = CommentEntry.hasPassed(resultNode.getStatus());
            String taskIdforNode = resultNode.getTaskId();
            boolean hasTaskId = taskIdforNode != null;
            boolean writeCommentForNode = hasTaskId && (this.m_reportSuccess && didNodePass || this.m_reportFailure && !didNodePass);
            boolean bl = writeFieldUpdateForNode = hasTaskId && !this.getApplicableRules(didNodePass).isEmpty();
            if (writeCommentForNode) {
                CommentEntry c = new CommentEntry(resultNode, this.m_dashboardURL, this.m_summary, this.m_nodeCount);
                this.addALMChangeToNode(taskIdforNode, c);
            }
            if (writeFieldUpdateForNode) {
                FieldUpdate f = new FieldUpdate(resultNode, this.m_dashboardURL, this.m_summary, this.m_nodeCount, this.getApplicableRules(didNodePass));
                this.addALMChangeToNode(taskIdforNode, f);
            }
            return true;
        }

        private void addALMChangeToNode(String taskIdforNode, ALMChange change) {
            List<ALMChange> changes = this.m_taskIdToALMChange.get(taskIdforNode);
            if (changes != null) {
                changes.add(change);
            } else {
                LinkedList<ALMChange> cs = new LinkedList<ALMChange>();
                cs.add(change);
                this.m_taskIdToALMChange.put(taskIdforNode, cs);
            }
        }

        private List<IALMReportingRulePO> getApplicableRules(boolean didNodePass) {
            ArrayList<IALMReportingRulePO> applicableRules = new ArrayList<IALMReportingRulePO>();
            ReportRuleType type = didNodePass ? ReportRuleType.ONSUCCESS : ReportRuleType.ONFAILURE;
            for (IALMReportingRulePO rule : this.m_reportingRules) {
                if (rule.getType() != type) continue;
                applicableRules.add(rule);
            }
            return applicableRules;
        }

        public void postOperate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
        }
    }
}

