/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.treeoperations;

import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.datastructure.CompNameUsageMap;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.tools.internal.exception.JBException;

public class CollectComponentNameUsersOp
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    private CompNameUsageMap m_usageMap = new CompNameUsageMap();
    private String m_projectGuid;
    private Long m_projectId;
    private JBException m_exception = null;

    public CollectComponentNameUsersOp(String projectGuid, Long projectId) {
        this.m_projectGuid = projectGuid;
        this.m_projectId = projectId;
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        try {
            if (node instanceof ICapPO) {
                ICapPO cap = (ICapPO)node;
                String guid = cap.getComponentName();
                IComponentNamePO compNamePo = ComponentNamesBP.getInstance().getCompNamePo(guid, this.m_projectGuid);
                this.m_usageMap.addSecondNameUser(compNamePo, cap);
            } else if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                    String guid = pair.getFirstName();
                    IComponentNamePO compNamePo = ComponentNamesBP.getInstance().getCompNamePo(guid, this.m_projectGuid);
                    if (compNamePo != null && compNamePo.getParentProjectId().equals(this.m_projectId)) {
                        this.m_usageMap.addFirstNameUser(compNamePo, execTc);
                    }
                    guid = pair.getSecondName();
                    compNamePo = ComponentNamesBP.getInstance().getCompNamePo(guid, this.m_projectGuid);
                    if (compNamePo == null || !compNamePo.getParentProjectId().equals(this.m_projectId)) continue;
                    this.m_usageMap.addSecondNameUser(compNamePo, execTc);
                }
            }
        }
        catch (JBException e) {
            this.m_exception = e;
            ctx.setContinued(false);
        }
        return true;
    }

    public CompNameUsageMap getUsageMap() throws JBException {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        return this.m_usageMap;
    }
}

