/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBRuntimeException;
import org.eclipse.jubula.tools.internal.messagehandling.Message;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandlingUtil.class);
    private static Dialog dlg = null;

    private ErrorHandlingUtil() {
    }

    public static Dialog createMessageDialog(JBException ex) {
        return ErrorHandlingUtil.createMessageDialog(ex, null, null);
    }

    public static Dialog createMessageDialog(JBException ex, Object[] params, String[] details) {
        Integer messageID = ex.getErrorId();
        Message m = MessageIDs.getMessageObject((Integer)messageID);
        if (m != null && m.getSeverity() == 4) {
            LOG.error(String.valueOf(Messages.AnErrorHasOccurred) + ".", (Throwable)ex);
        }
        return ErrorHandlingUtil.createMessageDialog(messageID, params, details);
    }

    public static Dialog createMessageDialog(final Integer messageID, final Object[] params, final String[] details) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!PlatformUI.getWorkbench().isClosing()) {
                    dlg = ErrorHandlingUtil.createMessageDialog(messageID, params, details, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                }
            }
        });
        return dlg;
    }

    public static Dialog createMessageDialog(Integer messageID) {
        return ErrorHandlingUtil.createMessageDialog(messageID, null, null);
    }

    public static Dialog createMessageDialog(Integer messageID, Object[] params, String[] details, Shell parent) {
        String title = "";
        String message = "";
        String[] labels = new String[]{JFaceResources.getString((String)"ok")};
        int imageID = 2;
        Message msg = MessageIDs.getMessageObject((Integer)messageID);
        String[] detail = ErrorHandlingUtil.lineFeed(msg.getDetails());
        if (details != null) {
            detail = ErrorHandlingUtil.lineFeed(details);
        }
        switch (msg.getSeverity()) {
            case 4: {
                title = Messages.UtilsError;
                message = Messages.UtilsErrorOccurred;
                break;
            }
            case 1: {
                title = Messages.UtilsInfo1;
                message = Messages.UtilsInfo2;
                break;
            }
            case 2: {
                title = Messages.UtilsWarning1;
                message = Messages.UtilsWarning2;
                break;
            }
            case 0: {
                title = Messages.UtilsRequest1;
                message = Messages.UtilsRequest2;
                labels = new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")};
                imageID = 3;
                break;
            }
        }
        Status[] status = new Status[detail.length];
        int i = 0;
        while (i < detail.length) {
            status[i] = new Status(msg.getSeverity(), "org.eclipse.jubula.client.ui", 0, detail[i], null);
            ++i;
        }
        if (msg.getSeverity() == 1 || msg.getSeverity() == 0) {
            StringBuilder messageBuilder = new StringBuilder(message);
            messageBuilder.append(msg.getMessage(params));
            messageBuilder.append("\n");
            Status[] statusArray = status;
            int n = status.length;
            int n2 = 0;
            while (n2 < n) {
                Status s = statusArray[n2];
                if (s.getMessage() != Message.NO_DETAILS) {
                    messageBuilder.append("\n");
                    messageBuilder.append(s.getMessage());
                }
                ++n2;
            }
            dlg = new MessageDialog(parent, title, null, messageBuilder.toString(), imageID, labels, 0);
        } else {
            dlg = new ErrorDialog(new Shell(16384), title, message, (IStatus)new MultiStatus("org.eclipse.jubula.client.ui", 0, (IStatus[])status, msg.getMessage(params), null), 7);
        }
        dlg.create();
        DialogUtils.setWidgetNameForModalDialog(dlg);
        dlg.open();
        return dlg;
    }

    public static Dialog createMessageDialog(JBRuntimeException ex) {
        Integer messageID = ex.getErrorId();
        Message m = MessageIDs.getMessageObject((Integer)messageID);
        if (m != null && m.getSeverity() == 4) {
            LOG.error(String.valueOf(Messages.AnErrorHasOccurred) + ".", (Throwable)ex);
        }
        return ErrorHandlingUtil.createMessageDialog(messageID, null, ErrorHandlingUtil.getStackTrace(ex.getCausedBy()));
    }

    public static String[] getStackTrace(Throwable throwable) {
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            return ((Object)writer).toString().split("\n");
        }
        return null;
    }

    private static String[] lineFeed(String[] strArray) {
        ArrayList<String> strList = new ArrayList<String>();
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            StringTokenizer tok = new StringTokenizer(str, "\n");
            while (tok.hasMoreElements()) {
                strList.add(tok.nextToken());
            }
            ++n2;
        }
        return strList.toArray(new String[strList.size()]);
    }
}

