/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IListComponent;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.swing.tester.adapter.JComponentAdapter;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class JListAdapter
extends JComponentAdapter
implements IListComponent {
    private JList m_list;

    public JListAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_list = (JList)objectToAdapt;
    }

    public String getText() {
        Object[] selected = this.getSelectedValues();
        SelectionUtil.validateSelection((Object[])selected);
        return selected[0];
    }

    public int[] getSelectedIndices() {
        return (int[])this.getEventThreadQueuer().invokeAndWait("getSelectedIndices", (IRunnable)new IRunnable<int[]>(){

            public int[] run() {
                return JListAdapter.this.m_list.getSelectedIndices();
            }
        });
    }

    public void clickOnIndex(Integer i, ClickOptions co, double maxWidth) {
        final int index = i;
        final ListModel model = this.m_list.getModel();
        if (model == null || index >= model.getSize() || index < 0) {
            throw new StepExecutionException("List index '" + i + "' is out of range", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
        final Rectangle r = (Rectangle)this.getRobotFactory().getEventThreadQueuer().invokeAndWait("getCellBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                return JListAdapter.this.m_list.getCellBounds(index, index);
            }
        });
        if (r == null) {
            throw new StepExecutionException("List index '" + i + "' is not visible", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
        }
        this.getRobotFactory().getEventThreadQueuer().invokeAndWait("setItemSize", (IRunnable)new IRunnable<Void>(){

            public Void run() throws StepExecutionException {
                ListCellRenderer lcr = JListAdapter.this.m_list.getCellRenderer();
                if (lcr != null) {
                    Component listItem = lcr.getListCellRendererComponent(JListAdapter.this.m_list, model.getElementAt(index), index, false, false);
                    Dimension preferredSize = listItem.getPreferredSize();
                    r.setSize(preferredSize);
                }
                return null;
            }
        });
        if (maxWidth != -1.0 && r.getWidth() > maxWidth) {
            Dimension d = new Dimension();
            d.setSize(maxWidth, r.getHeight());
            r.setSize(d);
        }
        this.getRobot().click((Object)this.m_list, (Object)r, co.setClickType(ClickOptions.ClickType.RELEASED));
    }

    public String[] getSelectedValues() {
        final int[] indices = this.getSelectedIndices();
        return (String[])this.getEventThreadQueuer().invokeAndWait("getSelectedValues", (IRunnable)new IRunnable<String[]>(){

            public String[] run() {
                Object[] values = JListAdapter.this.m_list.getSelectedValues();
                String[] selected = new String[values.length];
                ListCellRenderer<Object> renderer = JListAdapter.this.m_list.getCellRenderer();
                int i = 0;
                while (i < values.length) {
                    Object value = values[i];
                    Component c = renderer.getListCellRendererComponent(JListAdapter.this.m_list, value, indices[i], true, false);
                    selected[i] = TesterUtil.getRenderedText(c);
                    ++i;
                }
                return selected;
            }
        });
    }

    public void clickOnIndex(Integer i, ClickOptions co) {
        this.clickOnIndex(i, co, -1.0);
    }

    public String[] getValues() {
        return (String[])this.getEventThreadQueuer().invokeAndWait("getValues", (IRunnable)new IRunnable<String[]>(){

            public String[] run() {
                ListCellRenderer renderer = JListAdapter.this.m_list.getCellRenderer();
                ListModel model = JListAdapter.this.m_list.getModel();
                String[] values = new String[model.getSize()];
                int i = 0;
                while (i < model.getSize()) {
                    String str;
                    Object obj = model.getElementAt(i);
                    JListAdapter.this.m_list.ensureIndexIsVisible(i);
                    Component comp = renderer.getListCellRendererComponent(JListAdapter.this.m_list, obj, i, false, false);
                    values[i] = str = TesterUtil.getRenderedText(comp);
                    ++i;
                }
                return values;
            }
        });
    }
}

