/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen.internal.genmodel;

import java.util.Map;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;

public class ComponentGenInfo {
    private Component m_component;
    private String m_className;
    private String m_interfaceDirectoryPath;
    private String m_interfacePackageName;
    private Boolean m_genInterface;
    private Boolean m_hasDefaultMapping = false;
    private String m_mostSpecificVisibleSuperTypeName;
    private Map<String, String> m_compNameMap;

    public ComponentGenInfo(Component component, boolean generateInterface, String toolkitName, String className, Map<String, String> compNameMap) {
        this.m_component = component;
        this.m_genInterface = generateInterface;
        NameLoader nameLoader = NameLoader.getInstance();
        this.m_interfacePackageName = nameLoader.getInterfacePackageName(toolkitName);
        this.m_className = className;
        this.m_interfaceDirectoryPath = this.m_interfacePackageName.replace(".", "/");
        this.m_interfacePackageName = nameLoader.executeExceptions(this.m_interfacePackageName);
        this.m_interfaceDirectoryPath = nameLoader.executeExceptions(this.m_interfaceDirectoryPath);
        this.m_mostSpecificVisibleSuperTypeName = this.findMostSpecificVisibleSuperTypeName(component);
        if (component instanceof ConcreteComponent) {
            this.m_hasDefaultMapping = ((ConcreteComponent)component).hasDefaultMapping();
        }
        this.m_compNameMap = compNameMap;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public String getInterfacePackageName() {
        return this.m_interfacePackageName;
    }

    public String getInterfaceDirectoryPath() {
        return this.m_interfaceDirectoryPath;
    }

    public Boolean generatesInterface() {
        return this.m_genInterface;
    }

    public String getFqInterfaceName() {
        return String.valueOf(this.getInterfacePackageName()) + "." + this.getClassName();
    }

    private String getClassName() {
        return this.m_className;
    }

    public boolean hasDefaultMapping() {
        return this.m_hasDefaultMapping;
    }

    public String getMostSpecificVisibleSuperTypeName() {
        return this.m_mostSpecificVisibleSuperTypeName;
    }

    private String findMostSpecificVisibleSuperTypeName(Component component) {
        if (component.isVisible()) {
            return this.getFqInterfaceName();
        }
        Component tmp = component;
        while (tmp != null && !tmp.isVisible()) {
            tmp = (Component)tmp.getRealized().get(0);
        }
        CommonGenInfo visibleSuperType = new CommonGenInfo(tmp);
        ComponentGenInfo specificInformation = new ComponentGenInfo(tmp, true, visibleSuperType.getToolkitName(), visibleSuperType.getClassName(), null);
        return specificInformation.getFqInterfaceName();
    }

    public Map<String, String> getCompNameMap() {
        return this.m_compNameMap;
    }
}

