/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.utils.Traverser;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;

public class ResultTreeBuilder
implements IExecStackModificationListener {
    private TestResultNode m_endNode;
    private TestResultNode m_rootNode;
    private TestResultNode m_lastCap;

    public ResultTreeBuilder(Traverser trav) {
        Validate.notNull((Object)trav, (String)Messages.NoTraverserInstance);
        this.m_endNode = this.m_rootNode = new TestResultNode(trav.getRoot(), null);
    }

    @Override
    public void stackIncremented(INodePO node) {
        this.m_endNode = new TestResultNode(node, this.m_endNode);
    }

    @Override
    public void stackDecremented() {
        this.m_endNode = this.m_endNode.getParent();
    }

    @Override
    public void nextDataSetIteration() {
        this.m_endNode = new TestResultNode(this.m_endNode.getNode(), this.m_endNode.getParent());
    }

    @Override
    public void nextCap(ICapPO cap) {
        this.m_lastCap = new TestResultNode(cap, this.m_endNode);
        this.m_lastCap.setActionName(CompSystemI18n.getString((String)cap.getActionName()));
        this.m_lastCap.setComponentType(CompSystemI18n.getString((String)cap.getComponentType()));
    }

    public TestResultNode getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public void retryCap(ICapPO cap) {
        this.nextCap(cap);
    }
}

