/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.databinding.InverseBooleanConverter;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.internal.objects.StandardProfiles;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;
import org.eclipse.jubula.tools.internal.xml.businessprocess.ProfileBuilder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class ObjectMappingConfigComponent {
    private static final int NUM_COLUMNS = 1;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int HUNDRED_PERCENT = 200;
    private static final int STEP = 1;
    private static final int MAX_NUM_DIGITS = 5;
    private ModelToEnablementConverter m_modelToEnablementConverter = new ModelToEnablementConverter();
    private InverseBooleanConverter m_inverseBooleanConverter = new InverseBooleanConverter();
    private SliderToModelConverter m_sliderToModelConverter = new SliderToModelConverter();
    private ModelToSliderConverter m_modelToSliderConverter = new ModelToSliderConverter();
    private Scale m_threshold = null;
    private Label m_thresholdText = null;
    private Combo m_profileCombo = null;
    private Composite m_sliderComposite;
    private ModelToLabelConverter m_modelToLabelConverter = new ModelToLabelConverter();
    private LabelToModelConverter m_labelToModelConverter = new LabelToModelConverter();
    private IObjectMappingPO m_input;
    private IJBEditor m_editor;
    private DataBindingContext m_bindingContext;
    private IObservableValue m_profileObservable;
    private Map<Scale, String> m_factorSliders;
    private Map<Scale, Label> m_factorLabels = new HashMap<Scale, Label>();

    public ObjectMappingConfigComponent(Composite parent, IObjectMappingPO input, IJBEditor editor) {
        this.m_input = input;
        this.m_editor = editor;
        this.createAndInitControl(parent, input, editor);
    }

    private void createAndInitControl(Composite parent, IObjectMappingPO input, IJBEditor editor) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        scrollComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        final Composite composite = new Composite((Composite)scrollComposite, 0);
        this.m_bindingContext = new DataBindingContext();
        this.compositeGridData(composite);
        this.createProfileCombo(composite);
        this.m_sliderComposite = this.createSliderComposite(composite);
        this.m_factorSliders = new HashMap<Scale, String>();
        this.m_profileObservable = PojoObservables.observeValue((Object)input, (String)"profile");
        this.m_factorSliders.put(this.createFactorSlider(this.m_sliderComposite, Messages.ObjectMappingPreferencePagePathFactor, "pathFactor", this.m_bindingContext, this.m_profileObservable, editor), "pathFactor");
        this.m_factorSliders.put(this.createFactorSlider(this.m_sliderComposite, Messages.ObjectMappingPreferencePageNameFactor, "nameFactor", this.m_bindingContext, this.m_profileObservable, editor), "nameFactor");
        this.m_factorSliders.put(this.createFactorSlider(this.m_sliderComposite, Messages.ObjectMappingPreferencePageContextFactor, "contextFactor", this.m_bindingContext, this.m_profileObservable, editor), "contextFactor");
        this.linkFactorSliders(this.m_bindingContext, this.m_factorSliders.keySet(), editor);
        this.createThresholdSlider(this.m_sliderComposite, this.m_bindingContext, this.m_profileObservable);
        this.m_bindingContext.updateTargets();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageObjectMapContextId");
        this.m_profileCombo.setSize(this.m_factorSliders.keySet().iterator().next().getSize().x, this.m_profileCombo.getSize().y);
        scrollComposite.setContent((Control)composite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setMinSize(composite.computeSize(-1, -1));
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrollComposite.setMinSize(composite.computeSize(-1, -1));
            }
        });
    }

    private Composite createSliderComposite(Composite composite) {
        Composite sliderComposite = new Composite(composite, 2048);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 4;
        compositeLayout.horizontalSpacing = 5;
        compositeLayout.verticalSpacing = 5;
        sliderComposite.setLayout((Layout)compositeLayout);
        sliderComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label label = new Label(sliderComposite, 0x1000000);
        label = new Label(sliderComposite, 0x1000000);
        label = new Label(sliderComposite, 0x1000000);
        label.setText(" %");
        label = new Label(sliderComposite, 0);
        label.setText(Messages.ObjectMappingPreferencePageLock);
        return sliderComposite;
    }

    private void linkFactorSliders(final DataBindingContext bindingContext, final Set<Scale> factorSliders, final IJBEditor editor) {
        for (final Scale slider : factorSliders) {
            slider.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                        ObjectMappingConfigComponent.this.checkSum(slider, factorSliders);
                        bindingContext.updateModels();
                        if (!editor.isDirty()) {
                            editor.getEditorHelper().setDirty(true);
                        }
                    }
                }
            });
        }
    }

    private Scale createFactorSlider(Composite parent, String labelText, String boundProperty, DataBindingContext bindingContext, IObservableValue masterObservable, IJBEditor editor) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Scale factorScale = new Scale(parent, 0);
        factorScale.setMinimum(0);
        factorScale.setMaximum(200);
        factorScale.setIncrement(1);
        factorScale.setPageIncrement(1);
        factorScale.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label factorText = new Label(parent, 0);
        this.setLabelWidth(factorText);
        Button lockCheckbox = new Button(parent, 32);
        this.bindFactor(boundProperty, bindingContext, factorScale, factorText, lockCheckbox, masterObservable, editor);
        new Label(parent, 0);
        new Label(parent, 0);
        new Label(parent, 0);
        new Label(parent, 0);
        this.m_factorLabels.put(factorScale, factorText);
        return factorScale;
    }

    private void bindFactor(String boundProperty, DataBindingContext bindingContext, Scale factorScale, Label factorText, Button lockCheckbox, IObservableValue masterObservable, IJBEditor editor) {
        ISWTObservableValue uiElement = SWTObservables.observeSelection((Control)factorScale);
        IObservableValue modelElement = BeansObservables.observeDetailValue((IObservableValue)masterObservable, (String)boundProperty, Double.TYPE);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new JBEditorUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)this.m_sliderToModelConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToSliderConverter));
        uiElement = SWTObservables.observeText((Control)factorText);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new UpdateValueStrategy().setConverter((IConverter)this.m_labelToModelConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToLabelConverter));
        ISWTObservableValue checkboxSelection = SWTObservables.observeSelection((Control)lockCheckbox);
        uiElement = SWTObservables.observeEnabled((Control)factorScale);
        bindingContext.bindValue((IObservableValue)uiElement, masterObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToEnablementConverter));
        bindingContext.bindValue((IObservableValue)uiElement, (IObservableValue)checkboxSelection, new UpdateValueStrategy().setConverter((IConverter)this.m_inverseBooleanConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_inverseBooleanConverter));
        uiElement = SWTObservables.observeEnabled((Control)factorText);
        bindingContext.bindValue((IObservableValue)uiElement, masterObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToEnablementConverter));
        bindingContext.bindValue((IObservableValue)uiElement, (IObservableValue)checkboxSelection, new UpdateValueStrategy().setConverter((IConverter)this.m_inverseBooleanConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_inverseBooleanConverter));
        uiElement = SWTObservables.observeEnabled((Control)lockCheckbox);
        bindingContext.bindValue((IObservableValue)uiElement, masterObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToEnablementConverter));
    }

    private void updateBindFactor(String boundProperty, DataBindingContext bindingContext, Scale factorScale, IObservableValue masterObservable) {
        ISWTObservableValue uiElement = SWTObservables.observeSelection((Control)factorScale);
        IObservableValue modelElement = BeansObservables.observeDetailValue((IObservableValue)masterObservable, (String)boundProperty, Double.TYPE);
        this.removeBinding((IObservableValue)uiElement, modelElement);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new JBEditorUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)this.m_sliderToModelConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToSliderConverter));
        Label factorText = this.m_factorLabels.get(factorScale);
        uiElement = SWTObservables.observeText((Control)factorText);
        this.removeBinding((IObservableValue)uiElement, modelElement);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new UpdateValueStrategy().setConverter((IConverter)this.m_labelToModelConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToLabelConverter));
        uiElement = SWTObservables.observeEnabled((Control)factorScale);
        this.removeBinding((IObservableValue)uiElement, masterObservable);
        bindingContext.bindValue((IObservableValue)uiElement, masterObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToEnablementConverter));
    }

    private void updateThresholdBind(DataBindingContext bindingContext, IObservableValue masterObservable) {
        String boundProperty = "threshold";
        ISWTObservableValue uiElement = SWTObservables.observeSelection((Control)this.m_threshold);
        IObservableValue modelElement = BeansObservables.observeDetailValue((IObservableValue)masterObservable, (String)boundProperty, Double.TYPE);
        this.removeBinding((IObservableValue)uiElement, masterObservable);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new UpdateValueStrategy().setConverter((IConverter)this.m_sliderToModelConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToSliderConverter));
        uiElement = SWTObservables.observeText((Control)this.m_thresholdText);
        this.removeBinding((IObservableValue)uiElement, masterObservable);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToLabelConverter));
    }

    private void removeBinding(IObservableValue uiElement, IObservableValue modelElement) {
        ArrayList binds = new ArrayList(this.m_bindingContext.getBindings());
        for (Binding object : binds) {
            if (!object.getTarget().equals(uiElement) && !object.getModel().equals(modelElement)) continue;
            this.m_bindingContext.removeBinding(object);
        }
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
    }

    private void createProfileCombo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 2;
        composite.setLayout((Layout)compositeLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.ObjectMappingPreferencePageProfile);
        this.m_profileCombo = new Combo(composite, 40);
        this.m_profileCombo.setTextLimit(20);
        List names = StandardProfiles.getProfileNames();
        this.m_profileCombo.setItems(names.toArray(new String[names.size()]));
        this.m_profileCombo.add("Custom");
        this.setComboValue();
        this.m_profileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ObjectMappingConfigComponent.this.m_editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                    Profile p;
                    String name;
                    if (!ObjectMappingConfigComponent.this.m_editor.isDirty()) {
                        ObjectMappingConfigComponent.this.m_editor.getEditorHelper().setDirty(true);
                    }
                    if ((name = ObjectMappingConfigComponent.this.m_profileCombo.getText()) != null && (p = ProfileBuilder.getProfile((String)name)) != null) {
                        ObjectMappingConfigComponent.this.m_input.getProfile().useTemplate(p);
                        ObjectMappingConfigComponent.this.m_bindingContext.updateTargets();
                        ObjectMappingConfigComponent.this.m_bindingContext.updateModels();
                        ObjectMappingConfigComponent.this.setComboValue();
                    }
                }
            }
        });
    }

    private void setComboValue() {
        List profiles = ProfileBuilder.getProfiles();
        for (Profile profile : profiles) {
            int index;
            if (!this.m_input.getProfile().matchesTemplate(profile) || (index = this.m_profileCombo.indexOf(profile.getName())) == -1) continue;
            if (index != this.m_profileCombo.getSelectionIndex()) {
                this.m_profileCombo.select(index);
            }
            return;
        }
        int index = this.m_profileCombo.indexOf("Custom");
        if (index != -1) {
            if (index != this.m_profileCombo.getSelectionIndex()) {
                this.m_profileCombo.select(index);
            }
            return;
        }
    }

    private void createThresholdSlider(Composite parent, DataBindingContext bindingContext, IObservableValue masterObservable) {
        String boundProperty = "threshold";
        Label label = new Label(parent, 0);
        label.setText(Messages.ObjectMappingPreferencePageThreshold);
        this.m_threshold = new Scale(parent, 0);
        this.m_threshold.setMinimum(0);
        this.m_threshold.setMaximum(200);
        this.m_threshold.setIncrement(1);
        this.m_threshold.setPageIncrement(1);
        this.m_threshold.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.m_thresholdText = new Label(parent, 0);
        this.setLabelWidth(this.m_thresholdText);
        new Label(parent, 0);
        ISWTObservableValue uiElement = SWTObservables.observeSelection((Control)this.m_threshold);
        IObservableValue modelElement = BeansObservables.observeDetailValue((IObservableValue)masterObservable, (String)boundProperty, Double.TYPE);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new UpdateValueStrategy().setConverter((IConverter)this.m_sliderToModelConverter), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToSliderConverter));
        uiElement = SWTObservables.observeText((Control)this.m_thresholdText);
        bindingContext.bindValue((IObservableValue)uiElement, modelElement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToLabelConverter));
        uiElement = SWTObservables.observeEnabled((Control)this.m_threshold);
        bindingContext.bindValue((IObservableValue)uiElement, masterObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToEnablementConverter));
        uiElement = SWTObservables.observeEnabled((Control)this.m_thresholdText);
        bindingContext.bindValue((IObservableValue)uiElement, masterObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)this.m_modelToEnablementConverter));
    }

    private void setLabelWidth(Label label) {
        GC gc = new GC((Drawable)label);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 5;
        label.setLayoutData((Object)gd);
        gc.dispose();
    }

    void checkSum(Scale s, Set<Scale> factorSliders) {
        while (this.getSum(factorSliders) > 200.0) {
            boolean didDecrement = false;
            for (Scale toDecrement : factorSliders) {
                if (!(this.getSum(factorSliders) > 200.0) || !toDecrement.isEnabled() || toDecrement.equals(s) || toDecrement.getSelection() <= 0) continue;
                toDecrement.setSelection(toDecrement.getSelection() - 1);
                didDecrement = true;
            }
            if (didDecrement) continue;
            s.setSelection(s.getSelection() - 1);
        }
        while (this.getSum(factorSliders) < 200.0) {
            boolean didIncrement = false;
            for (Scale toIncrement : factorSliders) {
                if (!(this.getSum(factorSliders) < 200.0) || s.equals(toIncrement) || !toIncrement.isEnabled() || toIncrement.getSelection() >= 200) continue;
                toIncrement.setSelection(toIncrement.getSelection() + 1);
                didIncrement = true;
            }
            if (didIncrement) continue;
            s.setSelection(s.getSelection() + 1);
        }
    }

    public double getSum(Set<Scale> factorSliders) {
        double sum = 0.0;
        for (Scale slider : factorSliders) {
            if (slider == null || slider.isDisposed()) continue;
            sum += (double)slider.getSelection();
        }
        return sum;
    }

    public void setValue(Scale s, double d) {
        s.setSelection((int)(200.0 * d));
    }

    public void setInput(IObjectMappingPO input) {
        this.m_input = input;
        this.m_profileObservable.setValue((Object)input.getProfile());
        for (Scale scale : this.m_factorSliders.keySet()) {
            this.updateBindFactor(this.m_factorSliders.get(scale), this.m_bindingContext, scale, this.m_profileObservable);
        }
        this.updateThresholdBind(this.m_bindingContext, this.m_profileObservable);
        this.m_bindingContext.updateTargets();
        this.setComboValue();
    }

    private class JBEditorUpdateValueStrategy
    extends UpdateValueStrategy {
        public JBEditorUpdateValueStrategy(int updatePolicy) {
            super(updatePolicy);
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            if (ObjectMappingConfigComponent.this.m_editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                IStatus status = super.doSet(observableValue, value);
                if (!ObjectMappingConfigComponent.this.m_editor.isDirty()) {
                    ObjectMappingConfigComponent.this.m_editor.getEditorHelper().setDirty(true);
                }
                ObjectMappingConfigComponent.this.setComboValue();
                return status;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private static class LabelToModelConverter
    extends Converter {
        public LabelToModelConverter() {
            super(String.class, Double.TYPE);
        }

        public Object convert(Object fromObject) {
            String doubleString = (String)fromObject;
            return Double.parseDouble(doubleString.replaceAll("%", "")) / 100.0;
        }
    }

    private static class ModelToEnablementConverter
    extends Converter {
        public ModelToEnablementConverter() {
            super(IObjectMappingProfilePO.class, Boolean.TYPE);
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof IObjectMappingProfilePO) {
                if (((IObjectMappingProfilePO)fromObject).getName() == null) {
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    private static class ModelToLabelConverter
    extends Converter {
        private static final String FORMAT_STRING = "%3.1f";
        private static final int CONVERSION_FACTOR = 100;

        public ModelToLabelConverter() {
            super(Double.TYPE, String.class);
        }

        public Object convert(Object fromObject) {
            Double fromDouble = (Double)fromObject;
            return String.format(FORMAT_STRING, fromDouble * 100.0);
        }
    }

    private static class ModelToSliderConverter
    extends Converter {
        public ModelToSliderConverter() {
            super(Double.TYPE, Integer.TYPE);
        }

        public Object convert(Object fromObject) {
            Integer retVal = null;
            if (fromObject instanceof Double) {
                retVal = (int)((Double)fromObject * 200.0);
            }
            return retVal;
        }
    }

    private static class SliderToModelConverter
    extends Converter {
        public SliderToModelConverter() {
            super((Object)0, (Object)0.0);
        }

        public Object convert(Object fromObject) {
            Object retVal = fromObject;
            if (retVal instanceof Integer) {
                retVal = ((Integer)fromObject).doubleValue() / 200.0;
            }
            return retVal;
        }
    }
}

