/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import java.util.HashSet;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.core.constants.InputCodeHelper;
import org.eclipse.jubula.client.ui.preferences.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.preferences.utils.InputComboUtil;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.widgets.ModifiableTriggerList;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ObservationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 4;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private Combo m_startStopCheckMods = null;
    private DirectCombo<InputCodeHelper.UserInput> m_startStopCheckKey = null;
    private Combo m_checkCompMods = null;
    private DirectCombo<InputCodeHelper.UserInput> m_checkCompKey = null;
    private Button m_showDialog = null;
    private ModifiableTriggerList m_singleLineTrigger;
    private ModifiableTriggerList m_multiLineTrigger;

    public ObservationPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite);
        this.createObservModeArea(composite);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageObserveJavaContextId");
        this.initPreferences();
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.ObservationPreferencePageDescription);
    }

    private void createObservModeArea(Composite parent) {
        InputCodeHelper keys = InputCodeHelper.getInstance();
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite);
        Label keycombLabel = new Label(composite, 0);
        keycombLabel.setText(Messages.ObservationPreferencePageKeycombos);
        keycombLabel.setFont(LayoutUtil.BOLD_TAHOMA);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        keycombLabel.setLayoutData((Object)data);
        Label checkmodeLabel = new Label(composite, 0);
        checkmodeLabel.setText(Messages.ObservationPreferencePageCheckMode);
        this.m_startStopCheckMods = new Combo(composite, 12);
        this.m_startStopCheckMods.setItems(keys.getModifierString());
        Label pluslabel = new Label(composite, 0);
        pluslabel.setText(" + ");
        this.m_startStopCheckKey = InputComboUtil.createKeyCombo(composite, 12);
        Label checkCompLabel = new Label(composite, 0);
        checkCompLabel.setText(Messages.ObservationPreferencePageCheckComp);
        this.m_checkCompMods = new Combo(composite, 12);
        this.m_checkCompMods.setItems(keys.getModifierString());
        Label pluslabel2 = new Label(composite, 0);
        pluslabel2.setText(" + ");
        this.m_checkCompKey = InputComboUtil.createKeyCombo(composite, 12);
        SelectionListener selListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ObservationPreferencePage.this.checkValidKeys();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.m_startStopCheckMods.addSelectionListener(selListener);
        this.m_startStopCheckKey.addSelectionListener(selListener);
        this.m_checkCompMods.addSelectionListener(selListener);
        this.m_checkCompKey.addSelectionListener(selListener);
        Label dialogLabel = new Label(composite, 0);
        dialogLabel.setText(Messages.ObservationPreferencePageRecActDialog);
        dialogLabel.setFont(LayoutUtil.BOLD_TAHOMA);
        GridData data2 = new GridData();
        data2.horizontalSpan = 4;
        dialogLabel.setLayoutData((Object)data2);
        ControlDecorator.decorateInfo((Control)dialogLabel, "ControlDecorator.ObervationConsole", false);
        this.m_showDialog = new Button(composite, 32);
        this.m_showDialog.setText(Messages.ObservationPreferencePageShowDialog);
        this.createTriggerArea(composite);
    }

    private void createTriggerArea(Composite composite) {
        Label triggerLabel = new Label(composite, 0);
        triggerLabel.setText(Messages.ObservationPreferencePageTrigger);
        triggerLabel.setFont(LayoutUtil.BOLD_TAHOMA);
        GridData data3 = new GridData();
        data3.horizontalSpan = 4;
        triggerLabel.setLayoutData((Object)data3);
        ControlDecorator.decorateInfo((Control)triggerLabel, "ControlDecorator.ObservationTriggerReplaceText", false);
        HashSet<String> values = new HashSet<String>();
        this.m_singleLineTrigger = new ModifiableTriggerList(composite, 0, Messages.ObservationPreferencePageSingleLine, values, true);
        GridData gridData2 = new GridData(1040);
        gridData2.horizontalSpan = 2;
        gridData2.widthHint = 200;
        gridData2.heightHint = 300;
        this.m_singleLineTrigger.setLayoutData(gridData2);
        HashSet<String> values2 = new HashSet<String>();
        this.m_multiLineTrigger = new ModifiableTriggerList(composite, 0, Messages.ObservationPreferencePageMultiLine, values2, true);
        GridData gridData3 = new GridData(1040);
        gridData3.horizontalSpan = 2;
        gridData3.widthHint = 200;
        gridData3.heightHint = 300;
        this.m_multiLineTrigger.setLayoutData(gridData3);
        Label keycombLabel = new Label(composite, 0);
        keycombLabel.setText(Messages.ObservationPreferencePageHhint);
        keycombLabel.setFont(LayoutUtil.BOLD_TAHOMA);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        keycombLabel.setLayoutData((Object)data);
    }

    protected void checkValidKeys() {
        String checkCompShortcut;
        String checkModeShortcut = String.valueOf(this.m_startStopCheckMods.getText()) + this.m_startStopCheckKey.getText();
        if (checkModeShortcut.equals(checkCompShortcut = String.valueOf(this.m_checkCompMods.getText()) + this.m_checkCompKey.getText())) {
            this.setErrorMessage(Messages.ObservationPreferencePageRecordInvalidKey);
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 4;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)compositeData);
    }

    protected void initPreferences() {
        this.m_startStopCheckMods.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getPreferenceStore().getInt("CHECKMODE_MODS_PREF_KEY")));
        InputComboUtil.setSelectedKey(this.m_startStopCheckKey, this.getPreferenceStore().getInt("CHECKMODE_KEY_PREF_KEY"));
        this.m_checkCompMods.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getPreferenceStore().getInt("CHECKCOMP_MODS_PREF_KEY")));
        InputComboUtil.setSelectedKey(this.m_checkCompKey, this.getPreferenceStore().getInt("CHECKCOMP_KEY_PREF_KEY"));
        this.m_showDialog.setSelection(this.getPreferenceStore().getBoolean("SHOWRECORDDIALOG_PREF_KEY"));
        try {
            this.m_singleLineTrigger.setValues(Utils.decodeStringToSet((String)this.getPreferenceStore().getString("SINGLELINETRIGGER_PREF_KEY"), (String)";"));
            this.m_multiLineTrigger.setValues(Utils.decodeStringToSet((String)this.getPreferenceStore().getString("MULTILINETRIGGER_PREF_KEY"), (String)";"));
        }
        catch (JBException e) {
            e.printStackTrace();
        }
    }

    protected void performDefaults() {
        this.m_startStopCheckMods.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getDefaultPrefsInt("CHECKMODE_MODS_PREF_KEY")));
        InputComboUtil.setSelectedKey(this.m_startStopCheckKey, this.getDefaultPrefsInt("CHECKMODE_KEY_PREF_KEY"));
        this.m_checkCompMods.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getDefaultPrefsInt("CHECKCOMP_MODS_PREF_KEY")));
        InputComboUtil.setSelectedKey(this.m_checkCompKey, this.getDefaultPrefsInt("CHECKCOMP_KEY_PREF_KEY"));
        this.m_showDialog.setSelection(this.getDefaultPrefsBool("SHOWRECORDDIALOG_PREF_KEY"));
        try {
            this.m_singleLineTrigger.setValues(Utils.decodeStringToSet((String)this.getDefaultPrefsString("SINGLELINETRIGGER_PREF_KEY"), (String)";"));
            this.m_multiLineTrigger.setValues(Utils.decodeStringToSet((String)this.getDefaultPrefsString("MULTILINETRIGGER_PREF_KEY"), (String)";"));
        }
        catch (JBException e) {
            e.printStackTrace();
        }
        this.checkValidKeys();
    }

    private boolean getDefaultPrefsBool(String key) {
        return this.getPreferenceStore().getDefaultBoolean(key);
    }

    private int getDefaultPrefsInt(String key) {
        return this.getPreferenceStore().getDefaultInt(key);
    }

    private String getDefaultPrefsString(String key) {
        return this.getPreferenceStore().getDefaultString(key);
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("CHECKMODE_MODS_PREF_KEY", InputCodeHelper.getInstance().getModifier()[this.m_startStopCheckMods.getSelectionIndex()]);
        InputComboUtil.setPrefCode(this.m_startStopCheckKey, this.getPreferenceStore(), "CHECKMODE_KEY_PREF_KEY");
        this.getPreferenceStore().setValue("CHECKCOMP_MODS_PREF_KEY", InputCodeHelper.getInstance().getModifier()[this.m_checkCompMods.getSelectionIndex()]);
        InputComboUtil.setPrefCode(this.m_checkCompKey, this.getPreferenceStore(), "CHECKCOMP_KEY_PREF_KEY");
        this.getPreferenceStore().setValue("SHOWRECORDDIALOG_PREF_KEY", this.m_showDialog.getSelection());
        this.storeTriggerList();
        return super.performOk();
    }

    public void storeTriggerList() {
        String singleStorage = "";
        String[] singleTriggers = this.m_singleLineTrigger.getValues();
        singleStorage = Utils.encodeStringArray((String[])singleTriggers, (String)";");
        Plugin.getDefault().getPreferenceStore().setValue("SINGLELINETRIGGER_PREF_KEY", singleStorage);
        String multiStorage = "";
        String[] multiTriggers = this.m_multiLineTrigger.getValues();
        multiStorage = Utils.encodeStringArray((String[])multiTriggers, (String)";");
        Plugin.getDefault().getPreferenceStore().setValue("MULTILINETRIGGER_PREF_KEY", multiStorage);
    }
}

