/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.TrackingUnit;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.CompletenessBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.factory.ControlFactory;
import org.eclipse.jubula.client.ui.rcp.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.search.query.DeprecatedModulesQuery;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedIntText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedProjectNameText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedSignatureText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedText;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectGeneralPropertyPage
extends AbstractProjectPropertyPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int NUM_COLUMNS_3 = 3;
    private static Logger log = LoggerFactory.getLogger(ProjectGeneralPropertyPage.class);
    private CheckedText m_projectNameTextField;
    private Button m_isReusableCheckbox;
    private Button m_isProtectedCheckbox;
    private final WidgetModifyListener m_modifyListener = new WidgetModifyListener();
    private final ToolkitComboSelectionListener m_toolkitComboListener = new ToolkitComboSelectionListener();
    private DirectCombo<String> m_projectToolkitCombo;
    private final MarkupComboSelectionListener m_markupComboListener = new MarkupComboSelectionListener();
    private DirectCombo<String> m_projectMarkupCombo;
    private String m_newProjectName;
    private Button m_cleanTestresults = null;
    private CheckedIntText m_cleanResultDays = null;
    private Button m_isTrackingActivatedButton = null;
    private Group m_trackChangesTimespanSelection = null;
    private CheckedIntText m_trackChangesSpan = null;
    private Composite m_trackChangesUnitSelection = null;
    private Group m_trackChangesSignatureSelection = null;
    private CheckedSignatureText m_trackChangesSignature = null;
    private Button m_deleteChanges = null;
    private Set<IOkListener> m_okListenerList = new HashSet<IOkListener>();
    private Text m_projectDescriptionTextField;
    private IProjectPropertiesPO m_origProjectProps;
    private String m_oldProjectName = this.getProject().getName();

    public ProjectGeneralPropertyPage(EditSupport es) {
        super(es);
        this.m_origProjectProps = (IProjectPropertiesPO)es.getOriginal();
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1, 4, false);
        Composite projectNameComposite = this.createComposite(composite, 2, 4, false);
        this.noDefaultAndApplyButton();
        this.createEmptyLabel(projectNameComposite);
        this.createEmptyLabel(projectNameComposite);
        this.createProjectNameField(projectNameComposite);
        this.createProjectDescrField(projectNameComposite);
        this.createProjectVersionInfo(projectNameComposite);
        this.createProjectGuidInfo(projectNameComposite);
        this.createEmptyLabel(projectNameComposite);
        this.separator(projectNameComposite, 2);
        this.createEmptyLabel(projectNameComposite);
        this.createAutToolKit(projectNameComposite);
        this.createMarkupLanguage(projectNameComposite);
        this.separator(projectNameComposite, 2);
        this.createEmptyLabel(projectNameComposite);
        this.createIsReusable(projectNameComposite);
        this.createIsProtected(projectNameComposite);
        this.separator(projectNameComposite, 2);
        this.createEmptyLabel(projectNameComposite);
        this.createCleanTestResults(projectNameComposite);
        this.separator(projectNameComposite, 2);
        this.createTrackChangesEnablement(projectNameComposite);
        Composite trackChangesProperties = this.createComposite(composite, 3, 4, false);
        this.createTrackChangesTimespanSelection(trackChangesProperties);
        this.createTrackChangesSignatureSelection(trackChangesProperties);
        this.createTrackChangesDeleteDataButton(trackChangesProperties);
        Composite innerComposite = new Composite(composite, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        innerComposite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalSpan = 2;
        compositeData.horizontalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        innerComposite.setLayoutData((Object)compositeData);
        this.addListener();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectSettingsPageContextId");
        return composite;
    }

    private void createProjectVersionInfo(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 3, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageProjectVersion);
        Label versionLabel = new Label(rightComposite, 64);
        GridData labelGrid = new GridData(4, 2, true, false, 1, 1);
        labelGrid.widthHint = 124;
        versionLabel.setLayoutData((Object)labelGrid);
        versionLabel.setText(this.getProject().getVersionString());
    }

    private void createProjectGuidInfo(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 3, 4, true);
        ControlDecorator.decorateInfo((Control)this.createLabel(leftComposite, Messages.ProjectPropertyPageProjectGuid), "ControlDecorator.ProjectPropertiesGUID", false);
        Label projectGuid = new Label(rightComposite, 0);
        projectGuid.setText(this.getProject().getGuid());
        Label l = this.createLabel(rightComposite, "");
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        l.setLayoutData((Object)layoutData);
    }

    private void createIsReusable(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 2, 4, true);
        ControlDecorator.decorateInfo((Control)this.createLabel(leftComposite, Messages.ProjectPropertyPageIsReusable), "ControlDecorator.NewProjectIsReusable", false);
        this.m_isReusableCheckbox = new Button(rightComposite, 32);
        this.m_isReusableCheckbox.setSelection(this.m_origProjectProps.getIsReusable());
        this.m_isReusableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isReusable = ProjectGeneralPropertyPage.this.m_isReusableCheckbox.getSelection();
                if (isReusable) {
                    ProjectGeneralPropertyPage.this.m_isProtectedCheckbox.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createIsProtected(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 2, 4, true);
        ControlDecorator.decorateInfo((Control)this.createLabel(leftComposite, Messages.ProjectPropertyPageIsProtected), "ControlDecorator.NewProjectIsProtected", false);
        this.m_isProtectedCheckbox = new Button(rightComposite, 32);
        this.m_isProtectedCheckbox.setSelection(this.m_origProjectProps.getIsProtected());
    }

    private void createProjectNameField(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageProjectName);
        this.m_projectNameTextField = new CheckedProjectNameText(rightComposite, 2048);
        this.m_projectNameTextField.setText(this.getProject().getName());
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        LayoutUtil.addToolTipAndMaxWidth((GridData)textGridData, (Control)this.m_projectNameTextField);
        this.m_projectNameTextField.setLayoutData(textGridData);
        LayoutUtil.setMaxChar((Text)this.m_projectNameTextField);
    }

    private void createProjectDescrField(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageProjectDescr);
        this.m_projectDescriptionTextField = new Text(rightComposite, 2048);
        this.m_projectDescriptionTextField.setText(StringUtils.defaultString((String)this.getProject().getComment()));
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        LayoutUtil.addToolTipAndMaxWidth((GridData)textGridData, (Control)this.m_projectDescriptionTextField);
        this.m_projectDescriptionTextField.setLayoutData((Object)textGridData);
        LayoutUtil.setMaxChar((Text)this.m_projectDescriptionTextField, (int)4000);
    }

    private void createMarkupLanguage(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 2, 4, true);
        Label label = this.createLabel(leftComposite, Messages.ProjectPropertyPageMarkupLanguageLabel);
        ControlDecorator.createInfo((Control)label, Messages.ProjectPropertyPageMarkupLanguageInfo, false);
        this.m_projectMarkupCombo = ControlFactory.createProjectMarkupLanguageCombo(rightComposite);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        this.m_projectToolkitCombo.setLayoutData((Object)textGridData);
    }

    private void createAutToolKit(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 2, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageAutToolKitLabel);
        this.m_projectToolkitCombo = ControlFactory.createProjectToolkitCombo(rightComposite);
        this.m_projectToolkitCombo.setSelectedObject((Object)this.getProject().getToolkit());
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        this.m_projectToolkitCombo.setLayoutData((Object)textGridData);
    }

    protected void enableCleanResultDaysTextfield() {
        this.enableSelectionAndEnablementDependent(this.m_cleanTestresults, (Control)this.m_cleanResultDays);
    }

    private void createCleanTestResults(Composite parent) {
        this.m_cleanTestresults = new Button(parent, 32);
        this.m_cleanTestresults.setText(Messages.TestResultViewPreferencePageCleanResults);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_cleanTestresults.setLayoutData((Object)gridData);
        int testResultCleanupInterval = this.getProject().getTestResultCleanupInterval();
        this.m_cleanTestresults.setSelection(testResultCleanupInterval != -1);
        this.m_cleanTestresults.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectGeneralPropertyPage.this.enableCleanResultDaysTextfield();
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_cleanResultDays = new CheckedIntText(parent, 2048, false, 1, Integer.MAX_VALUE);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 80;
        this.m_cleanResultDays.setLayoutData(gridData);
        if (testResultCleanupInterval > 0) {
            this.m_cleanResultDays.setText(String.valueOf(testResultCleanupInterval));
        }
        this.m_cleanResultDays.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }
        });
        this.enableCleanResultDaysTextfield();
        ControlDecorator.decorateInfo((Control)this.m_cleanResultDays, "TestResultViewPreferencePage.cleanResultsInfo", false);
    }

    private void createTrackChangesEnablement(Composite parent) {
        this.m_isTrackingActivatedButton = new Button(parent, 32);
        this.m_isTrackingActivatedButton.setText(Messages.PrefPageTrackChanges);
        this.m_isTrackingActivatedButton.setSelection(this.m_origProjectProps.getIsTrackingActivated());
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = false;
        this.m_isTrackingActivatedButton.setLayoutData((Object)gridData);
        ControlDecorator.decorateInfo((Control)this.m_isTrackingActivatedButton, "TestResultViewPreferencePage.TrackChangesInfo", false);
        this.m_isTrackingActivatedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectGeneralPropertyPage.this.m_isTrackingActivatedButton != null) {
                    UIComponentHelper.setEnabledRecursive((Control)ProjectGeneralPropertyPage.this.m_trackChangesTimespanSelection, (boolean)ProjectGeneralPropertyPage.this.m_isTrackingActivatedButton.getSelection());
                    UIComponentHelper.setEnabledRecursive((Control)ProjectGeneralPropertyPage.this.m_trackChangesSignatureSelection, (boolean)ProjectGeneralPropertyPage.this.m_isTrackingActivatedButton.getSelection());
                }
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTrackChangesTimespanSelection(Composite parent) {
        this.m_trackChangesTimespanSelection = new Group(parent, 0);
        GridData gridData = new GridData(1808);
        this.m_trackChangesTimespanSelection.setLayout((Layout)new GridLayout());
        this.m_trackChangesTimespanSelection.setLayoutData((Object)gridData);
        this.m_trackChangesTimespanSelection.setText(Messages.PrefPageTrackChangesTimespanSelectionText);
        this.m_trackChangesUnitSelection = new Composite((Composite)this.m_trackChangesTimespanSelection, 0);
        this.m_trackChangesUnitSelection.setLayout((Layout)new GridLayout());
        Button daysButton = new Button(this.m_trackChangesUnitSelection, 16);
        daysButton.setText("Days");
        Button changesButton = new Button(this.m_trackChangesUnitSelection, 16);
        changesButton.setText("Changes");
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }
        };
        daysButton.addSelectionListener(listener);
        changesButton.addSelectionListener(listener);
        TrackingUnit unit = this.m_origProjectProps.getTrackChangesUnit();
        if (unit != null) {
            switch (unit) {
                case CHANGES: {
                    changesButton.setSelection(true);
                    break;
                }
                case DAYS: {
                    daysButton.setSelection(true);
                    break;
                }
            }
        } else {
            daysButton.setSelection(true);
        }
        this.m_trackChangesSpan = new CheckedIntText((Composite)this.m_trackChangesTimespanSelection, 2048, false, 1, Integer.MAX_VALUE);
        gridData = new GridData(1, 0, true, true);
        gridData.widthHint = 80;
        this.m_trackChangesSpan.setLayoutData(gridData);
        ControlDecorator.decorateInfo((Control)this.m_trackChangesSpan, "TestResultViewPreferencePage.cleanResultsTimeunitInfo", false);
        Integer span = this.m_origProjectProps.getTrackChangesSpan();
        if (span != null) {
            this.m_trackChangesSpan.setText(String.valueOf(span));
        } else {
            this.m_trackChangesSpan.setText("10");
        }
        this.m_trackChangesSpan.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }
        });
        if (this.m_isTrackingActivatedButton != null) {
            UIComponentHelper.setEnabledRecursive((Control)this.m_trackChangesTimespanSelection, (boolean)this.m_isTrackingActivatedButton.getSelection());
        }
    }

    private void createTrackChangesSignatureSelection(Composite parent) {
        this.m_trackChangesSignatureSelection = new Group(parent, 0);
        this.m_trackChangesSignatureSelection.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.m_trackChangesSignatureSelection.setLayoutData((Object)gridData);
        this.m_trackChangesSignatureSelection.setText(Messages.PrefPageTrackChangesSignatureSelectionText);
        Label label = new Label((Composite)this.m_trackChangesSignatureSelection, 64);
        label.setText(Messages.PrefPageTrackChangesSignatureDescription);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        labelData.grabExcessHorizontalSpace = false;
        labelData.horizontalAlignment = 16384;
        labelData.widthHint = 400;
        label.setLayoutData((Object)labelData);
        this.m_trackChangesSignature = new CheckedSignatureText((Composite)this.m_trackChangesSignatureSelection, 2048);
        gridData = new GridData(32);
        gridData.widthHint = 200;
        this.m_trackChangesSignature.setLayoutData(gridData);
        this.m_trackChangesSignature.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ProjectGeneralPropertyPage.this.checkCompleteness();
            }
        });
        String signature = this.m_origProjectProps.getTrackChangesSignature();
        if (signature != null) {
            this.m_trackChangesSignature.setText(signature);
        }
        this.m_trackChangesSignatureSelection.pack();
        if (this.m_isTrackingActivatedButton != null) {
            UIComponentHelper.setEnabledRecursive((Control)this.m_trackChangesSignatureSelection, (boolean)this.m_isTrackingActivatedButton.getSelection());
        }
        parent.pack();
    }

    private void createTrackChangesDeleteDataButton(Composite parent) {
        this.m_deleteChanges = new Button(parent, 8);
        this.m_deleteChanges.setText(Messages.PrefPageTrackChangesDeleteData);
        GridData gridData = new GridData(0x1000008, 1, false, false);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_deleteChanges.setLayoutData((Object)gridData);
        this.m_deleteChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialog qDialog = new MessageDialog(ProjectGeneralPropertyPage.this.getShell(), Messages.UtilsConfirmation, null, Messages.PrefPageTrackChangesDeleteDataQuestion, 3, new String[]{Messages.UtilsYes, Messages.UtilsNo}, 0);
                qDialog.setBlockOnOpen(true);
                qDialog.open();
                if (qDialog.getReturnCode() == 0) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new DeleteTrackedChangesOperation());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    protected void checkCompleteness() {
        if (this.m_cleanResultDays.isEnabled() && this.m_cleanResultDays.getValue() <= 0) {
            this.setErrorMessage(Messages.TestResultViewPreferencePageCleanResultDaysEmpty);
            this.setValid(false);
            return;
        }
        if (this.m_trackChangesTimespanSelection.isEnabled()) {
            boolean unitSelected = false;
            Control[] controlArray = this.m_trackChangesUnitSelection.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Button bt;
                Control child = controlArray[n2];
                if (child instanceof Button && (bt = (Button)child).getSelection()) {
                    unitSelected = true;
                }
                ++n2;
            }
            if (!unitSelected) {
                this.setErrorMessage(Messages.PrefPageTrackChangesNoUnitSelected);
                this.setValid(false);
                return;
            }
        }
        if (this.m_trackChangesTimespanSelection.isEnabled() && this.m_trackChangesSpan.getValue() <= 0) {
            this.setErrorMessage(Messages.PrefPageTrackChangesTimespanEmpty);
            this.setValid(false);
            return;
        }
        String trackChangesSignature = this.m_trackChangesSignature.getText();
        if (this.m_trackChangesTimespanSelection.isEnabled() && !StringUtils.isEmpty((String)trackChangesSignature) && EnvironmentUtils.getProcessOrSystemProperty((String)trackChangesSignature) == null) {
            this.setErrorMessage(Messages.PrefPageTrackChangesSignatureInvalid);
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    public boolean performOk() {
        block9: {
            Plugin.startLongRunning(Messages.RefreshTSBrowserActionProgressMessage);
            if (this.m_oldProjectName.equals(this.m_newProjectName) || !ProjectPM.doesProjectNameExist((String)this.m_newProjectName)) break block9;
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_PROJECTNAME_ALREADY_EXISTS, (Object[])new Object[]{this.m_newProjectName}, null);
            return false;
        }
        try {
            IProjectPO project = this.getProject();
            this.storeProperties();
            this.storeAutoTestResultCleanup();
            if (!this.m_oldProjectName.equals(this.m_newProjectName)) {
                ProjectNameBP.getInstance().setName(this.getEditSupport().getSession(), project.getGuid(), this.m_newProjectName);
            }
            this.fireOkPressed();
            Set origReused = ((IProjectPropertiesPO)this.getEditSupport().getOriginal()).getUsedProjects();
            HashSet<IReusedProjectPO> newReused = new HashSet<IReusedProjectPO>(((IProjectPropertiesPO)this.getEditSupport().getWorkVersion()).getUsedProjects());
            newReused.removeAll(origReused);
            this.getEditSupport().saveWorkVersion();
            this.refreshAutMainList();
            boolean doSearchQuery = false;
            doSearchQuery = this.handleReusedChanged(newReused);
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            ded.fireProjectStateChanged(DataEventDispatcher.ProjectState.prop_modified);
            ArrayList<DataChangedEvent> events = new ArrayList<DataChangedEvent>();
            events.add(new DataChangedEvent((IPersistentObject)PoMaker.createReusedProjectPO((String)"1", (Integer)1, (Integer)1, null, null), DataEventDispatcher.DataState.ReuseChanged, DataEventDispatcher.UpdateState.notInEditor));
            events.add(new DataChangedEvent((IPersistentObject)GeneralStorage.getInstance().getProject(), DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.notInEditor));
            ded.fireDataChangedListener(events.toArray(new DataChangedEvent[0]));
            CompletenessBP.getInstance().completeProjectCheck();
            if (doSearchQuery) {
                NewSearchUI.runQueryInBackground((ISearchQuery)new DeprecatedModulesQuery());
            }
        }
        catch (PMException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        catch (IncompatibleTypeException ite) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
        }
        catch (InterruptedException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(Messages.UnexpectedError, (Throwable)e, MessageIDs.E_UNEXPECTED_EXCEPTION));
        }
        catch (InvocationTargetException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(Messages.UnexpectedError, (Throwable)e, MessageIDs.E_UNEXPECTED_EXCEPTION));
        }
        Plugin.stopLongRunning();
        return true;
    }

    private boolean handleReusedChanged(Set<IReusedProjectPO> newReused) throws InvocationTargetException, InterruptedException {
        boolean doSearchQuery = false;
        if (newReused.size() > 0) {
            doSearchQuery = this.openSearchForDeprecatedDialog();
            PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)new RefreshProjectHandler.RefreshProjectOperation());
        }
        for (IReusedProjectPO reused : newReused) {
            try {
                IProjectPO reusedProject = ProjectPM.loadReusedProject((IReusedProjectPO)reused);
                if (reusedProject == null) continue;
                ComponentNamesBP.getInstance().refreshNames(reusedProject.getId());
            }
            catch (JBException e) {
                log.error(Messages.ErrorWhileRetrievingReusedProjectInformation, (Throwable)e);
            }
        }
        return doSearchQuery;
    }

    private boolean openSearchForDeprecatedDialog() {
        MessageDialog mdiag = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.ProjectPropertyPageSearchForDeprProjModuleTitle, null, Messages.ProjectPropertyPageSearchForDeprProjModuleMsg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        mdiag.create();
        Plugin.getHelpSystem().setHelp((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "org.eclipse.jubula.client.ua.help.projectSearchForDeprecatedModulesPageContextId");
        return mdiag.open() == 0;
    }

    private void storeProperties() {
        IProjectPO project = this.getProject();
        if (this.m_isReusableCheckbox != null) {
            project.setIsReusable(this.m_isReusableCheckbox.getSelection());
        }
        if (this.m_isProtectedCheckbox != null) {
            project.setIsProtected(this.m_isProtectedCheckbox.getSelection());
        }
        if (this.m_projectDescriptionTextField != null) {
            project.setComment(this.m_projectDescriptionTextField.getText());
        }
        if (this.m_isTrackingActivatedButton != null) {
            project.setIsTrackingActivated(this.m_isTrackingActivatedButton.getSelection());
        }
        if (this.m_trackChangesSignature != null) {
            project.getProjectProperties().setTrackChangesSignature(this.m_trackChangesSignature.getText());
        }
        if (this.m_trackChangesSpan != null && this.m_trackChangesSpan.getText() != null && !this.m_trackChangesSpan.getText().equals("")) {
            project.getProjectProperties().setTrackChangesSpan(Integer.valueOf(this.m_trackChangesSpan.getText()));
        }
        if (this.m_trackChangesUnitSelection != null) {
            TrackingUnit unit = null;
            Control[] controlArray = this.m_trackChangesUnitSelection.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Button bt;
                Control child = controlArray[n2];
                if (child instanceof Button && (bt = (Button)child).getSelection()) {
                    String btText = bt.getText();
                    if (btText.equals("Days")) {
                        unit = TrackingUnit.DAYS;
                    } else if (btText.equals("Changes")) {
                        unit = TrackingUnit.CHANGES;
                    }
                }
                ++n2;
            }
            if (unit != null) {
                project.getProjectProperties().setTrackChangesUnit(unit);
            }
        }
    }

    private void storeAutoTestResultCleanup() {
        if (this.m_cleanResultDays != null && this.m_cleanTestresults != null) {
            boolean autoClean = this.m_cleanTestresults.getSelection();
            if (autoClean) {
                this.getProject().setTestResultCleanupInterval(Integer.valueOf(this.m_cleanResultDays.getText()).intValue());
            } else {
                this.getProject().setTestResultCleanupInterval(-1);
            }
        }
    }

    private void fireOkPressed() throws PMException {
        for (IOkListener listener : this.m_okListenerList) {
            listener.okPressed();
        }
    }

    private void refreshAutMainList() throws ProjectDeletedException {
        try {
            GeneralStorage.getInstance().getMasterSession().refresh((Object)GeneralStorage.getInstance().getProject().getAutCont());
        }
        catch (EntityNotFoundException entityNotFoundException) {
            GeneralStorage.getInstance().reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void addListener() {
        this.m_projectNameTextField.addModifyListener(this.m_modifyListener);
        this.m_projectToolkitCombo.addSelectionListener((SelectionListener)this.m_toolkitComboListener);
        this.m_projectMarkupCombo.addSelectionListener((SelectionListener)this.m_markupComboListener);
    }

    boolean modifyProjectNameFieldAction(boolean isProjectNameVerified) {
        boolean isCorrect = true;
        String projectName = this.m_projectNameTextField.getText();
        int projectNameLength = projectName.length();
        super.getShell().setText(String.valueOf(Messages.ProjectPropertyPageShellTitle) + projectName);
        if (projectNameLength == 0 || projectName.startsWith(" ") || projectName.charAt(projectNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            this.setErrorMessage(null);
            this.setMessage(Messages.PropertiesActionPage1, 0);
            this.setValid(true);
            if (isProjectNameVerified) {
                this.m_newProjectName = projectName;
            }
            if (ProjectPM.doesProjectNameExist((String)projectName) && !this.m_oldProjectName.equals(projectName)) {
                this.setErrorMessage(Messages.ProjectSettingWizardPageDoubleProjectName);
                isCorrect = false;
                this.setValid(false);
            }
        } else if (projectNameLength == 0) {
            this.setErrorMessage(Messages.ProjectWizardEmptyProject);
            this.setValid(false);
        } else {
            this.setErrorMessage(Messages.ProjectWizardNotValidProject);
            this.setValid(false);
        }
        return isCorrect;
    }

    public void addOkListener(IOkListener toAdd) {
        this.m_okListenerList.add(toAdd);
    }

    public void setVisible(boolean visible) {
        this.refreshAutToolkitCombo();
        super.setVisible(visible);
    }

    private void refreshAutToolkitCombo() {
        Composite parent = this.m_projectToolkitCombo.getParent();
        DirectCombo<String> tmpCombo = ControlFactory.createProjectToolkitCombo(parent);
        this.m_projectToolkitCombo.setItems(tmpCombo.getValues(), Arrays.asList(tmpCombo.getItems()));
        tmpCombo.dispose();
        this.m_projectToolkitCombo.setSelectedObject((Object)this.getProject().getToolkit());
    }

    private class DeleteTrackedChangesOperation
    implements IRunnableWithProgress {
        private DeleteTrackedChangesOperation() {
        }

        public void run(IProgressMonitor monitor) {
            IProjectPO project = GeneralStorage.getInstance().getProject();
            try {
                List listOfLockedNodes = NodePM.cleanupTrackedChanges((IProgressMonitor)monitor, (IProjectPO)project);
                if (!listOfLockedNodes.isEmpty()) {
                    Object[] details = listOfLockedNodes.toArray();
                    if (details.length <= 10) {
                        String[] namesOfLockedNodes = new String[details.length];
                        int i = 0;
                        while (i < namesOfLockedNodes.length) {
                            namesOfLockedNodes[i] = ((INodePO)details[i]).getName();
                            ++i;
                        }
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_COULD_NOT_DELETE_ALL_TRACKED_CHANGES, null, (String[])namesOfLockedNodes);
                    } else {
                        String[] namesOfLockedNodes = new String[10];
                        int i = 0;
                        while (i < namesOfLockedNodes.length) {
                            namesOfLockedNodes[i] = ((INodePO)details[i]).getName();
                            ++i;
                        }
                        Object[] params = new Object[]{10, details.length};
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_COULD_NOT_DELETE_ALL_TRACKED_CHANGES_MANY, (Object[])params, (String[])namesOfLockedNodes);
                    }
                }
            }
            catch (PMException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e));
            }
            catch (ProjectDeletedException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e));
            }
        }
    }

    public static interface IOkListener {
        public void okPressed() throws PMException;
    }

    private class MarkupComboSelectionListener
    implements SelectionListener {
        private MarkupComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectGeneralPropertyPage.this.m_projectMarkupCombo)) {
                this.handleMarkupSelection();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "."));
        }

        private void handleMarkupSelection() {
            String newMarkup = (String)ProjectGeneralPropertyPage.this.m_projectMarkupCombo.getSelectedObject();
            IProjectPO project = ProjectGeneralPropertyPage.this.getProject();
            project.setMarkupLanguage(newMarkup);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "."));
        }
    }

    private class ToolkitComboSelectionListener
    implements SelectionListener {
        private ToolkitComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectGeneralPropertyPage.this.m_projectToolkitCombo)) {
                this.handleAutToolkitSelection();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "."));
        }

        private void handleAutToolkitSelection() {
            String newToolkit = (String)ProjectGeneralPropertyPage.this.m_projectToolkitCombo.getSelectedObject();
            IProjectPO project = ProjectGeneralPropertyPage.this.getProject();
            project.setToolkit(newToolkit);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "."));
        }
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object o = e.getSource();
            if (o.equals((Object)ProjectGeneralPropertyPage.this.m_projectNameTextField)) {
                ProjectGeneralPropertyPage.this.modifyProjectNameFieldAction(true);
                return;
            }
        }
    }
}

