/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextComponent;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.util.Rounding;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TreeOperationContext
extends AbstractTreeOperationContext<TreeView<?>, TreeItem<?>> {
    private static AutServerLogger log = new AutServerLogger(TreeOperationContext.class);

    public TreeOperationContext(IEventThreadQueuer queuer, IRobot robot, TreeView<?> tree) {
        super(queuer, robot, tree);
        if (tree.getRoot() == null) {
            throw new StepExecutionException("Tree is empty.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
    }

    protected String convertValueToText(final TreeItem<?> node, int row) throws StepExecutionException {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("convertValueToText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object val;
                if (node != null && (val = node.getValue()) != null) {
                    return val.toString();
                }
                return null;
            }
        });
        return result;
    }

    public Collection<String> getNodeTextList(TreeItem<?> node) {
        String rendText;
        ArrayList<String> res = new ArrayList<String>();
        int rowNotUsed = 0;
        String valText = this.convertValueToText(node, rowNotUsed);
        if (valText != null) {
            res.add(valText);
        }
        if ((rendText = this.getRenderedText(node)) != null) {
            res.add(rendText);
        }
        return res;
    }

    public String getRenderedText(final TreeItem<?> node) throws StepExecutionException {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRenderedText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                IComponent adapter;
                TreeCell cell = TreeOperationContext.this.getCellForNode(node);
                if (cell != null && (adapter = (IComponent)AdapterFactoryRegistry.getInstance().getAdapter(IComponent.class, (Object)cell)) != null && adapter instanceof ITextComponent) {
                    return ((ITextComponent)adapter).getText();
                }
                return null;
            }
        });
        return result;
    }

    public TreeCell getCellForNode(TreeItem<?> node) {
        this.scrollNodeToVisible(node);
        TreeView tree = (TreeView)this.getTree();
        tree.layout();
        List<TreeCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)tree, TreeCell.class);
        for (TreeCell cell : tCells) {
            TreeItem item = cell.getTreeItem();
            if (!NodeTraverseHelper.isVisible((Node)cell) || item == null || !item.equals(node)) continue;
            return cell;
        }
        return null;
    }

    public boolean isVisible(final TreeItem<?> node) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem parent = node.getParent();
                if (parent != null) {
                    if (parent.isExpanded() && ((TreeView)TreeOperationContext.this.getTree()).isVisible()) {
                        return true;
                    }
                    return false;
                }
                return ((TreeView)TreeOperationContext.this.getTree()).isVisible();
            }
        });
    }

    public Rectangle getVisibleRowBounds(final Rectangle rowBounds) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getVisibleRowBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                tree.layout();
                Rectangle visibleTreeBounds = new Rectangle(0, 0, Rounding.round(tree.getWidth()), Rounding.round(tree.getHeight()));
                return rowBounds.intersection(visibleTreeBounds);
            }
        });
        return result;
    }

    public void scrollNodeToVisible(final TreeItem<?> node) {
        EventThreadQueuerJavaFXImpl.invokeAndWait("scrollNodeToVisible", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                int index = tree.getRow(node);
                tree.scrollTo(index);
                tree.layout();
                return null;
            }
        });
    }

    public void clickNode(TreeItem<?> node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        Rectangle rowBounds = this.getNodeBounds(node);
        Rectangle visibleRowBounds = this.getVisibleRowBounds(rowBounds);
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps);
    }

    public void expandNode(final TreeItem<?> node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("expandNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                tree.layout();
                List<TreeCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)tree, TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    if (!NodeTraverseHelper.isVisible((Node)cell) || item == null || !item.equals(node) || item.isExpanded()) continue;
                    return cell.getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("expandNodeCheckIfExpanded", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!((TreeView)TreeOperationContext.this.getTree()).isDisabled() && !node.isExpanded()) {
                    log.warn((Object)("Expand node fallback used for: " + node.getValue()));
                    node.setExpanded(true);
                }
                return null;
            }
        });
    }

    public void collapseNode(final TreeItem<?> node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                tree.layout();
                List<TreeCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)tree, TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    if (!NodeTraverseHelper.isVisible((Node)cell) || item == null || !item.equals(node) || !item.isExpanded()) continue;
                    return cell.getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNodeCheckIfCollapsed", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!((TreeView)TreeOperationContext.this.getTree()).isDisabled() && node.isExpanded()) {
                    log.warn((Object)("Collapse node fallback used for: " + node.getValue()));
                    node.setExpanded(false);
                }
                return null;
            }
        });
    }

    public TreeItem<?> getSelectedNode() {
        TreeItem result = (TreeItem)EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<TreeItem<?>>(){

            @Override
            public TreeItem<?> call() throws Exception {
                return (TreeItem)((TreeView)TreeOperationContext.this.getTree()).getSelectionModel().getSelectedItem();
            }
        });
        if (result != null) {
            SelectionUtil.validateSelection((Object[])new Object[]{result});
        } else {
            SelectionUtil.validateSelection((Object[])new Object[0]);
        }
        return result;
    }

    public TreeItem<?>[] getSelectedNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<TreeItem<?>[]>(){

            @Override
            public TreeItem<?>[] call() throws Exception {
                ObservableList selectedItems = ((TreeView)TreeOperationContext.this.getTree()).getSelectionModel().getSelectedItems();
                return (TreeItem[])selectedItems.toArray((Object[])new TreeItem[selectedItems.size()]);
            }
        });
        SelectionUtil.validateSelection((Object[])result);
        return result;
    }

    public TreeItem<?>[] getRootNodes() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getRootNodes", new Callable<TreeItem<?>[]>(){

            @Override
            public TreeItem<?>[] call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                if (tree.showRootProperty().getValue().booleanValue()) {
                    return new TreeItem[]{tree.getRoot()};
                }
                return TreeOperationContext.this.getChildren(tree.getRoot());
            }
        });
    }

    public TreeItem<?> getParent(final TreeItem<?> child) {
        return (TreeItem)EventThreadQueuerJavaFXImpl.invokeAndWait("getParent", new Callable<TreeItem<?>>(){

            @Override
            public TreeItem<?> call() throws Exception {
                return child.getParent();
            }
        });
    }

    public TreeItem<?> getChild(final TreeItem<?> parent, final int index) {
        return (TreeItem)EventThreadQueuerJavaFXImpl.invokeAndWait("getChild", new Callable<TreeItem<?>>(){

            @Override
            public TreeItem<?> call() throws Exception {
                return (TreeItem)parent.getChildren().get(index);
            }
        });
    }

    public int getNumberOfChildren(final TreeItem<?> parent) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getNumberOfChildren", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return parent.getChildren().size();
            }
        });
    }

    public boolean isLeaf(final TreeItem<?> node) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isLeaf", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return node.isLeaf();
            }
        });
    }

    public TreeItem<?>[] getChildren(final TreeItem<?> parent) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getChildren", new Callable<TreeItem<?>[]>(){

            @Override
            public TreeItem<?>[] call() throws Exception {
                ObservableList children = parent.getChildren();
                return (TreeItem[])children.toArray((Object[])new TreeItem[children.size()]);
            }
        });
    }

    public Rectangle getNodeBounds(final TreeItem<?> node) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                tree.layout();
                List<TreeCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)tree, TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    if (!NodeTraverseHelper.isVisible((Node)cell) || item == null || !item.equals(node)) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle treeB = NodeBounds.getAbsoluteBounds((Node)tree);
                    return new Rectangle(Math.abs(treeB.x - b.x), Math.abs(treeB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        if (result == null) {
            throw new StepExecutionException("Could not retrieve visible node bounds.", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
        }
        return result;
    }

    public int getIndexOfChild(final TreeItem<?> parent, final TreeItem<?> child) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getIndexOfChild", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (parent == null) {
                    TreeItem<?>[] rootNodes = TreeOperationContext.this.getRootNodes();
                    int i = 0;
                    while (i < rootNodes.length) {
                        if (ObjectUtils.equals(rootNodes[i], (Object)child)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }
                ObservableList children = parent.getChildren();
                if (children.contains(child)) {
                    return children.indexOf(child);
                }
                return -1;
            }
        });
    }
}

