/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;


/**
 * Factory for creating components from the base toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2016-08-29T08:53:15.407Z")
public class AbstractComponents {
    

    private AbstractComponents() {
        super();
    }
    

    /** create a new representative for a GraphicsComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createGraphicsComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent(componentIdentifier);
    }
    
    /** create a new representative for a GraphicsComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler createGraphicsComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextInputComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.TextInputComponentActionHandler createTextInputComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.handler.TextInputComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.TextComponent createTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.TextComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.TextComponentActionHandler createTextComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.handler.TextComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a ButtonComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.ButtonComponent(componentIdentifier);
    }
    
    /** create a new representative for a ButtonComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.ButtonComponentActionHandler createButtonComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.base.internal.impl.handler.ButtonComponentActionHandler(componentIdentifier);
    }
}