/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the ListComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-08-29T08:53:15.293Z")
@Beta
public interface ListComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.TextComponentActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * 
         */
        public void checkSelectionOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * 
         */
        public void checkExistenceOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param index 
         *        the index
         * @param selected 
         *        whether the component is expected to be selected or not
         * 
         */
        public void checkSelectionOfEntryByIndex(
            @Nullable String index,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param index 
         *        the index
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public void selectEntryByIndexIndices(
            @Nullable String index,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer numberOfClicks
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public void selectEntryByValueS(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer numberOfClicks
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * 
         */
        public void dragEntryByValue(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param index 
         *        the index
         * 
         */
        public void dragEntryByIndex(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer index
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void dropOnEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param index 
         *        the index
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void dropOnEntryByIndex(
            @Nullable Integer index,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.0
         */
        public void checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        ) ;
        
} 