/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the OperatingSystemComponent component from the concrete toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2016-08-29T08:53:15.331Z")
public class OperatingSystemComponent implements org.eclipse.jubula.toolkit.concrete.components.OperatingSystemComponent {
            public OperatingSystemComponent() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        /**
         * Run operating system specific executable
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param directory 
         *        the directory in which the command should be executed
         * @param executable 
         *        the command to execute without any command line arguments
         * @param arguments 
         *        a splitChar-delimited list of command-line arguments
         * @param argumentSplitCharacter 
         *        the character used to split the arguments string into individual arguments
         * @param expectedExitCode 
         *        the expected exit code
         * @param encoding 
         *        the encoding used to read output from the process
         * @param useNewEnvironment 
         *        Do not use old / current environment for new sub-process 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP runExecutable(@NonNull Integer timeoutInMs,@NonNull String directory,@NonNull String executable,@Nullable String arguments,@Nullable String argumentSplitCharacter,@NonNull Integer expectedExitCode,@NonNull String encoding,@NonNull Boolean useNewEnvironment
        ) throws IllegalArgumentException {
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            Validate.notNull(directory, "Argument 'directory' must not be null"); //$NON-NLS-1$
            Validate.notNull(executable, "Argument 'executable' must not be null"); //$NON-NLS-1$
            Validate.notNull(expectedExitCode, "Argument 'expectedExitCode' must not be null"); //$NON-NLS-1$
            Validate.notNull(encoding, "Argument 'encoding' must not be null"); //$NON-NLS-1$
            Validate.notNull(useNewEnvironment, "Argument 'useNewEnvironment' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcExec")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(timeoutInMs)
                        .addParameter(directory)
                        .addParameter(executable)
                        .addOptionalParameter(arguments)
                        .addOptionalParameter(argumentSplitCharacter)
                        .addParameter(expectedExitCode)
                        .addParameter(encoding)
                        .addParameter(useNewEnvironment)
                        .build();
        }
        
} 