/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the TextInputComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-08-29T08:53:15.319Z")
@Beta
public class TextInputComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.TextInputComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler {
            public TextInputComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param index 
         *        the index
         * 
         */
        public void insertTextAfterIndex(
            @Nullable String text,
            @Nullable Integer index
        )  {
            if (text == null) return;
            
            if (index == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInsertText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(index)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * @param insertAfterPattern 
         *        insert after pattern
         * 
         */
        public void insertTextBeforeAfterPattern(
            @Nullable String text,
            @Nullable String pattern,
            @Nullable Operator operator,
            @Nullable Boolean insertAfterPattern
        )  {
            if (text == null) return;
            
            if (pattern == null) return;
            
            if (operator == null) return;
            
            if (insertAfterPattern == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInsertText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(pattern)
                            .addParameter(operator.rcValue())
                            .addParameter(insertAfterPattern)
                            .build(), null);
        }
        
        public void selectAll(
        )  {
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelect")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
        /**
         * 
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void selectPattern(
            @Nullable String pattern,
            @Nullable Operator operator
        )  {
            if (pattern == null) return;
            
            if (operator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelect")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pattern)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
} 