/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.html.internal.HtmlToolkitInfo;

/**
 * Factory for creating components from the html toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2016-08-29T08:53:15.391Z")
public class HtmlComponents {
    
    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = HtmlToolkit.createToolkitInformation();

    private HtmlComponents() {
        super();
    }
    
    /** 
     *  @return the toolkit information, not recommended to be modified
     */
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return TOOLKIT_INFORMATION;
    }

    /** create a new representative for a {@link html.forms.Button} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Button(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.Button} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Button} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createInputButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.InputButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Button} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createInputButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.InputButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Submit} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createSubmit (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Submit(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Submit} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createSubmitActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.SubmitActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Reset} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createReset (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Reset(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Reset} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createResetActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ResetActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Checkbox} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createCheckBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.CheckBox(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Checkbox} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createCheckBoxActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.CheckBoxActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Radio} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createRadioButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.RadioButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Radio} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createRadioButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.RadioButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.button.Button} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.ButtonButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.button.Button} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createButtonButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ButtonButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.button.Submit} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createSubmitButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.SubmitButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.button.Submit} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createSubmitButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.SubmitButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.button.Reset} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createResetButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.ResetButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.button.Reset} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createResetButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ResetButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Text} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createText (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Text(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Text} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.TextActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Email} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createEmail (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Email(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Email} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createEmailActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.EmailActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Password} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createPasswordField (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.PasswordField(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Password} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createPasswordFieldActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.PasswordFieldActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.TextArea} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextArea (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.TextArea(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.TextArea} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextAreaActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.TextAreaActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Label} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createLabel (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Label(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Label} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createLabelActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.LabelActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Header1} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createHeader1 (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Header1(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Header1} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createHeader1ActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.Header1ActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Header2} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createHeader2 (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Header2(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Header2} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createHeader2ActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.Header2ActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Header3} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createHeader3 (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Header3(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Header3} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createHeader3ActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.Header3ActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Header4} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createHeader4 (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Header4(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Header4} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createHeader4ActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.Header4ActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Header5} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createHeader5 (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Header5(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Header5} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createHeader5ActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.Header5ActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Header6} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createHeader6 (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Header6(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Header6} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createHeader6ActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.Header6ActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Paragraph} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createParagraph (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Paragraph(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Paragraph} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createParagraphActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ParagraphActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.label.Pre} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createPre (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Pre(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.label.Pre} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createPreActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.PreActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.select.List} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.List(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.select.List} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createListActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ListActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.select.ComboBox} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.ComboBox(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.select.ComboBox} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ComboComponentActionHandler createComboBoxActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ComboBoxActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.Table} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTable (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Table(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.Table} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TableComponentActionHandler createTableActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.TableActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.Anchor} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.html.components.Anchor createAnchor (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.html.components.Anchor> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Anchor(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.Anchor} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.html.components.handler.AnchorActionHandler createAnchorActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.html.components.Anchor> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.AnchorActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.Image} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createImageComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.ImageComponent(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.Image} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler createImageComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ImageComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.forms.input.Image} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createImage (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Image(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.forms.input.Image} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createImageActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ImageActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link Application} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createApplication () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.Application();
    }
    
    /** create a new instance of ApplicationActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ApplicationActionHandler createApplicationActionHandler () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ApplicationActionHandler();
    }
    /** create a new representative for a {@link Browser} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.html.components.Browser createBrowser () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.Browser();
    }
    
    /** create a new instance of BrowserActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.html.components.handler.BrowserActionHandler createBrowserActionHandler () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.BrowserActionHandler();
    }
    /** create a new representative for a {@link html.Div} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.TextComponent createDiv (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.Div(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.Div} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.TextComponentActionHandler createDivActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.DivActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.text.Ol} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createOrderedList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.OrderedList(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.text.Ol} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createOrderedListActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.OrderedListActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link html.text.Ul} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createUnorderedList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.UnorderedList(componentIdentifier);
    }
    
    /** create a new representative for a {@link html.text.Ul} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createUnorderedListActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.UnorderedListActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link Locator} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.html.components.Locator createLocator () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.Locator();
    }
    
    /** create a new instance of LocatorActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.html.components.handler.LocatorActionHandler createLocatorActionHandler () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.LocatorActionHandler();
    }
    /** create a new representative for a {@link AlertPromptConfirmation} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.html.components.AlertPromptConfirmation createAlertPromptConfirmation () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.AlertPromptConfirmation();
    }
    
    /** create a new instance of AlertPromptConfirmationActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.html.components.handler.AlertPromptConfirmationActionHandler createAlertPromptConfirmationActionHandler () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.AlertPromptConfirmationActionHandler();
    }
    /** create a new representative for a {@link OperatingSystem} component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.OperatingSystemComponent createOperatingSystem () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.OperatingSystem();
    }
    
    /** create a new instance of OperatingSystemActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.OperatingSystemComponentActionHandler createOperatingSystemActionHandler () {
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.OperatingSystemActionHandler();
    }
    /** create a new representative for a ButtonComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.ButtonComponent(componentIdentifier);
    }
    
    /** create a new representative for a ButtonComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createButtonComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.ButtonComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.TextInputComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextInputComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextInputComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.TextInputComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.TextComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createTextComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.html.internal.impl.handler.TextComponentActionHandler(componentIdentifier);
    }
}