/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.jarutils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jubula.tools.internal.jarutils.JarResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainClassLocator {
    private MainClassLocator() {
    }

    public static List<String> getMainClass(File file) throws IOException {
        MainClassLocator t = new MainClassLocator();
        return t.getMainClassName(file);
    }

    private List<String> getMainClassName(File url) throws IOException {
        URL u = new URL("jar", "", url.toURL() + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        Attributes attr = uc.getMainAttributes();
        Vector<String> returnValue = new Vector<String>();
        try {
            if (attr != null && attr.getValue(Attributes.Name.MAIN_CLASS) != null) {
                returnValue.add(attr.getValue(Attributes.Name.MAIN_CLASS));
                Vector<String> vector = returnValue;
                return vector;
            }
            if (returnValue.isEmpty()) {
                List<String> list = this.getMainClassNameParse(url.toURL());
                return list;
            }
            Vector<String> vector = returnValue;
            return vector;
        }
        finally {
            uc.getJarFile().close();
        }
    }

    private List<String> getMainClassNameParse(URL url) throws IOException {
        MyClassLoader cl = new MyClassLoader(url);
        List<String> main = cl.getMainMethod();
        cl.close();
        return main;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyClassLoader
    extends ClassLoader {
        private JarResources m_res;
        private JarFile m_jar;

        MyClassLoader(URL fileName) throws IOException {
            this.m_res = new JarResources(fileName.getFile());
            this.m_jar = new JarFile(new File(fileName.getFile()));
        }

        public void close() {
            try {
                this.m_jar.close();
                this.m_res = null;
                this.m_jar = null;
            }
            catch (Throwable throwable) {}
        }

        public List<String> getMainMethod() {
            Vector<String> returnValue = new Vector<String>();
            Enumeration<JarEntry> entries = this.m_jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || this.checkClass(entry.getName()) == null) continue;
                returnValue.add(entry.getName().replace('/', '.').substring(0, entry.getName().replace('/', '.').lastIndexOf(".class")));
            }
            return returnValue;
        }

        private String checkClass(String cNRaw) throws ClassFormatError {
            String cN = cNRaw;
            cN = cN.replace('/', '.');
            byte[] classBytes = this.m_res.getResource(cNRaw);
            try {
                Class<?> c;
                try {
                    c = this.findClass(cN);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    c = this.defineClass(cN.substring(0, cN.lastIndexOf(".class")), classBytes, 0, classBytes.length);
                }
                int i = 0;
                while (i < c.getDeclaredMethods().length) {
                    if (c.getDeclaredMethods()[i].getName().equals("main")) {
                        return cN;
                    }
                    ++i;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            return null;
        }
    }
}

