/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTComponent;
import org.eclipse.jubula.rc.common.components.AUTHierarchy;
import org.eclipse.jubula.rc.common.components.HierarchyContainer;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.SwingAUTServer;
import org.eclipse.jubula.rc.swing.components.FindSwingComponentBP;
import org.eclipse.jubula.rc.swing.components.SwingComponent;
import org.eclipse.jubula.rc.swing.components.SwingHierarchyContainer;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.utils.WorkerRunnable;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUTSwingHierarchy
extends AUTHierarchy<Component>
implements ContainerListener,
ComponentListener {
    private static final String ENV_VAR_SYNC_REGISTER_LISTENERS = "JB_SYNC_REG_SWING_LISTENERS";
    private static AutServerLogger log = new AutServerLogger(AUTSwingHierarchy.class);
    private static FindSwingComponentBP findBP = new FindSwingComponentBP();
    private WorkerRunnable m_listenerRegistrationWorker = new WorkerRunnable();
    private boolean m_syncListenerRegistration = false;

    public AUTSwingHierarchy() {
        String syncListenersRegistrationValue = EnvironmentUtils.getProcessOrSystemProperty((String)ENV_VAR_SYNC_REGISTER_LISTENERS);
        this.m_syncListenerRegistration = Boolean.valueOf(syncListenersRegistrationValue);
        if (!this.m_syncListenerRegistration) {
            Thread registrationThread = new Thread((Runnable)this.m_listenerRegistrationWorker, "Jubula Listener Registration");
            registrationThread.setDaemon(true);
            registrationThread.start();
        }
    }

    public void add(Window window) {
        if (this.getRealMap().get(window) == null || this.getHierarchyContainer(window) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("adding window " + window));
            }
            SwingComponent componentID = new SwingComponent(window);
            SwingHierarchyContainer hierarchyWindow = new SwingHierarchyContainer(componentID);
            this.addToHierachyMap(hierarchyWindow);
            this.registerAsWindowListener(window);
            Container parent = window.getParent();
            if (parent != null) {
                SwingHierarchyContainer hierarchyParent = this.getHierarchyContainer(parent);
                if (hierarchyParent == null) {
                    hierarchyParent = new SwingHierarchyContainer(new SwingComponent(parent));
                }
                this.name(hierarchyParent);
                hierarchyParent.add(hierarchyWindow);
                hierarchyWindow.setPrnt(hierarchyParent);
                this.name(hierarchyWindow);
                this.addToHierachyMap(hierarchyParent);
                this.addToHierarchyUp(hierarchyParent, parent);
            }
        }
        this.addToHierarchyDown(this.getHierarchyContainer(window), window);
    }

    private void remove(Window window) {
        if (this.getRealMap().get(window) != null) {
            HierarchyContainer windowContainer = (HierarchyContainer)this.getHierarchyMap().get(this.getRealMap().get(window));
            if (windowContainer != null) {
                HierarchyContainer parentContainer = windowContainer.getPrnt();
                if (parentContainer != null) {
                    parentContainer.remove(windowContainer);
                }
                this.removeFromHierarchy((HierarchyContainer<Component>)windowContainer);
            } else {
                log.error((Object)("an unmanaged window was closed: " + window));
            }
        }
    }

    public IComponentIdentifier getComponentIdentifier(Component component) throws ComponentNotManagedException {
        this.checkDispatchThread();
        ComponentIdentifier result = new ComponentIdentifier();
        try {
            result.setComponentClassName(component.getClass().getName());
            result.setSupportedClassName(AUTServerConfiguration.getInstance().getTestableClass(component.getClass()).getName());
            List<String> hierarchy = this.getPathToRoot(component);
            result.setHierarchyNames(hierarchy);
            result.setNeighbours(this.getComponentContext(component));
            HierarchyContainer<Component> container = this.getHierarchyContainer(component);
            this.setAlternativeDisplayName(container, component, (IComponentIdentifier)result);
            if (component.equals(findBP.findComponent((IComponentIdentifier)result, ComponentHandler.getAutHierarchy()))) {
                result.setEqualOriginalFound(true);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)iae);
            throw new ComponentNotManagedException("getComponentIdentifier() called for an unmanaged component: " + component, MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
    }

    protected List<String> getComponentContext(Component comp) {
        HierarchyContainer<Component> parent;
        ArrayList<String> context = new ArrayList<String>();
        if (comp.getParent() != null && (parent = this.getHierarchyContainer(comp.getParent())) != null) {
            HierarchyContainer[] comps = parent.getComps();
            int i = 0;
            while (i < comps.length) {
                Component child = (Component)comps[i].getCompID().getComponent();
                if (!child.equals(comp)) {
                    String toAdd = String.valueOf(child.getClass().getName()) + "_" + 1;
                    while (context.contains(toAdd)) {
                        int lastCount = Integer.valueOf(toAdd.substring(toAdd.lastIndexOf("_") + 1));
                        toAdd = String.valueOf(child.getClass().getName()) + "_" + (lastCount + 1);
                    }
                    context.add(toAdd);
                }
                ++i;
            }
        }
        return context;
    }

    public IComponentIdentifier[] getAllComponentId() {
        this.checkDispatchThread();
        Vector<IComponentIdentifier> result = new Vector<IComponentIdentifier>();
        Set keys = this.getHierarchyMap().keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Component component = (Component)((AUTComponent)iter.next()).getComponent();
            try {
                if (!AUTServerConfiguration.getInstance().isSupported((Object)component)) continue;
                result.add(this.getComponentIdentifier(component));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"hierarchy map contains null values", (Throwable)iae);
            }
            catch (ComponentNotManagedException e) {
                log.error((Object)("component '" + component.getName() + "' not found!"), (Throwable)e);
            }
        }
        return result.toArray(new IComponentIdentifier[result.size()]);
    }

    public Component findComponent(IComponentIdentifier componentIdentifier) throws IllegalArgumentException, ComponentNotManagedException, InvalidDataException {
        Component comp = (Component)findBP.findComponent(componentIdentifier, ComponentHandler.getAutHierarchy());
        if (comp != null && comp.isShowing()) {
            Window window = SwingUtilities.getWindowAncestor(comp);
            if (window != null && window.isShowing() && !window.isActive()) {
                window.toFront();
            }
            return comp;
        }
        throw new ComponentNotManagedException("unmanaged component with identifier: '" + componentIdentifier.toString() + "'.", MessageIDs.E_COMPONENT_NOT_MANAGED);
    }

    public List<String> getPathToRoot(Component component) throws IllegalArgumentException, ComponentNotManagedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("pathToRoot called for " + component));
        }
        Validate.notNull((Object)component, (String)"The component must not be null");
        ArrayList<String> hierarchy = new ArrayList<String>();
        HierarchyContainer<Component> autContainer = this.getHierarchyContainer(component);
        if (autContainer != null) {
            hierarchy.add(autContainer.getName());
            String className = component.getClass().getName();
            if ("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication".equals(className) || "com.bredexsw.guidancer.autserver.swing.implclasses.JMenuBarDefaultMapping".equals(className) || "javax.swing.JMenuBar".equals(className)) {
                return hierarchy;
            }
            HierarchyContainer parent = this.getHierarchyContainer(component.getParent());
            autContainer.setPrnt(parent);
            while (parent != null) {
                hierarchy.add(0, parent.getName());
                Component compo = (Component)parent.getCompID().getComponent();
                parent = parent.getPrnt();
                if (parent != null || compo == null || compo.getParent() == null) continue;
                SwingComponent comp = new SwingComponent(compo.getParent());
                SwingHierarchyContainer container = new SwingHierarchyContainer(comp);
                this.name(container);
                parent = container;
                this.addToHierachyMap(container);
            }
        } else {
            log.error((Object)("component '" + component + "' is not managed by this hierarchy"));
            throw new ComponentNotManagedException("unmanaged component " + component.toString(), MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
        return hierarchy;
    }

    @Override
    public void componentAdded(ContainerEvent event) {
        this.checkDispatchThread();
        this.addComponent(event.getChild());
    }

    private void addComponent(Component toAdd) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (!toAdd.isShowing()) {
                return;
            }
            Container container = toAdd.getParent();
            if (log.isDebugEnabled()) {
                log.debug((Object)("component '" + toAdd + "' added to '" + container + "'"));
            }
            HierarchyContainer<Component> hierarchyContainer = null;
            hierarchyContainer = toAdd instanceof Window ? this.getHierarchyContainer(toAdd) : this.getHierarchyContainer(container);
            if (hierarchyContainer == null) {
                return;
            }
            if (this.getHierarchyContainer(toAdd) != null) {
                return;
            }
            SwingHierarchyContainer hierarchyChild = new SwingHierarchyContainer(new SwingComponent(toAdd));
            hierarchyContainer.add((HierarchyContainer)hierarchyChild);
            hierarchyChild.setPrnt(hierarchyContainer);
            this.name(hierarchyChild);
            this.addToHierachyMap(hierarchyChild);
            if (toAdd instanceof Container) {
                Container cont = (Container)toAdd;
                this.addToHierarchyDown(hierarchyChild, cont);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent event) {
        this.checkDispatchThread();
        this.removeComponent(event.getChild(), event.getContainer());
    }

    private void removeComponent(Component toRemove, Container parent) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            HierarchyContainer<Component> hierarchyChild;
            if (log.isDebugEnabled()) {
                log.debug((Object)("component '" + toRemove + "' removed from '" + parent + "'"));
            }
            if (toRemove instanceof Container) {
                this.deregisterAsContainerListener((Container)toRemove);
            }
            if ((hierarchyChild = this.getHierarchyContainer(toRemove)) != null) {
                HierarchyContainer hierarchyParent = hierarchyChild.getPrnt();
                if (hierarchyParent != null) {
                    hierarchyParent.remove(hierarchyChild);
                } else {
                    log.error((Object)("hierarchy structure corrupted, child has no parent: " + hierarchyChild));
                }
                this.removeFromHierarchy(hierarchyChild);
            } else {
                log.debug((Object)("an unmanaged component was removed: " + toRemove));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private void registerAsContainerListener(final Container container) {
        Runnable registrationRunnable = new Runnable(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)("registering as listener to container " + container));
                }
                ContainerListener[] listener = container.getContainerListeners();
                int i = 0;
                while (i < listener.length) {
                    if (listener[i] instanceof AUTSwingHierarchy) {
                        return;
                    }
                    ++i;
                }
                container.addContainerListener(AUTSwingHierarchy.this);
            }
        };
        this.registerListener(registrationRunnable);
    }

    private void registerListener(Runnable registrationRunnable) {
        if (this.m_syncListenerRegistration) {
            registrationRunnable.run();
        } else {
            this.m_listenerRegistrationWorker.addWork(registrationRunnable);
        }
    }

    private void deregisterAsContainerListener(final Container container) {
        Runnable deregistrationRunnable = new Runnable(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)("deregistering as listener from container " + container));
                }
                container.removeContainerListener(AUTSwingHierarchy.this);
            }
        };
        this.registerListener(deregistrationRunnable);
    }

    private void registerAsWindowListener(final Window window) {
        Runnable registrationRunnable = new Runnable(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)("registering window listener to window " + window));
                }
                WindowListener[] listener = window.getWindowListeners();
                int i = 0;
                while (i < listener.length) {
                    if (listener[i] instanceof WindowClosingListener) {
                        return;
                    }
                    ++i;
                }
                window.addWindowListener(new WindowClosingListener());
            }
        };
        this.registerListener(registrationRunnable);
    }

    private void addToHierarchyUp(HierarchyContainer<Component> hierarchyContainer, Container container) {
        SwingHierarchyContainer hierarchyParent;
        this.checkDispatchThread();
        if (log.isInfoEnabled()) {
            log.info((Object)("addToHierarchyUp: " + hierarchyContainer + "," + container));
        }
        this.registerAsContainerListener(container);
        Container parent = container.getParent();
        if (parent != null && (hierarchyParent = this.getHierarchyContainer(container)) == null) {
            hierarchyParent = new SwingHierarchyContainer(new SwingComponent(parent));
            hierarchyParent.add(hierarchyContainer);
            hierarchyContainer.setPrnt((HierarchyContainer)hierarchyParent);
            this.name(hierarchyParent);
            this.addToHierachyMap(hierarchyParent);
            this.addToHierarchyUp(hierarchyParent, parent);
        }
    }

    private void addToHierarchyDown(HierarchyContainer<Component> hierarchyContainer, Container container) {
        this.checkDispatchThread();
        if (log.isInfoEnabled()) {
            log.info((Object)("addToHierarchyDown: " + hierarchyContainer + "," + container));
        }
        this.registerAsContainerListener(container);
        Collection<Component> collection = this.getComponents(container);
        for (Component component : collection) {
            if (this.getHierarchyContainer(component) != null || !component.isShowing()) continue;
            if (component instanceof Window) {
                this.add((Window)component);
                continue;
            }
            SwingHierarchyContainer newHierarchyContainer = new SwingHierarchyContainer(new SwingComponent(component));
            this.name(newHierarchyContainer);
            newHierarchyContainer.setPrnt(hierarchyContainer);
            hierarchyContainer.add((HierarchyContainer)newHierarchyContainer);
            this.addToHierachyMap(newHierarchyContainer);
            if (!(component instanceof Container)) continue;
            this.addToHierarchyDown(newHierarchyContainer, (Container)component);
        }
        this.name(hierarchyContainer);
    }

    private void removeFromHierarchy(HierarchyContainer<Component> container) {
        if (container == null) {
            return;
        }
        AUTComponent autCompID = container.getCompID();
        Component autComp = (Component)autCompID.getComponent();
        if (autComp == null) {
            log.error((Object)("invalid component for removal:" + autCompID.toString()));
        }
        this.removeFromHierachyMap(container);
        if (autComp instanceof Container) {
            this.deregisterAsContainerListener((Container)autComp);
        }
        Collection<Component> childs = this.getComponents(autComp);
        Iterator<Component> iter = childs.iterator();
        while (iter.hasNext()) {
            this.removeFromHierarchy(this.getHierarchyContainer(iter.next()));
        }
    }

    public HierarchyContainer<Component> getHierarchyContainer(Component component) throws IllegalArgumentException {
        Validate.notNull((Object)component, (String)"The component must not be null");
        HierarchyContainer result = null;
        try {
            AUTComponent compID = (AUTComponent)this.getRealMap().get(component);
            if (compID != null) {
                result = (HierarchyContainer)this.getHierarchyMap().get(compID);
            }
        }
        catch (ClassCastException cce) {
            log.error((Object)cce);
        }
        catch (NullPointerException npe) {
            log.error((Object)npe);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void name(HierarchyContainer<Component> hierarchyContainer) {
        block8: {
            block9: {
                this.checkDispatchThread();
                if (hierarchyContainer == null) break block8;
                component = (Component)hierarchyContainer.getCompID().getComponent();
                compName = component.getName();
                if (component instanceof Dialog && compName != null && compName.startsWith("dialog")) {
                    compName = null;
                } else if (component instanceof JToolBar && compName != null && compName.startsWith("Tool Bar ")) {
                    compName = null;
                }
                hierarchyParent = null;
                parent = component.getParent();
                if (parent != null) {
                    hierarchyParent = this.getHierarchyContainer(parent);
                }
                if (hierarchyContainer.getName() != null && hierarchyContainer.getName().length() != 0) {
                    return;
                }
                count = 1;
                originalName = null;
                newName = null;
                v0 = newNameGenerated = compName == null;
                if (compName != null) {
                    originalName = compName;
                    newName = compName;
                }
                if (newName != null) ** GOTO lbl30
                while (!this.isUniqueName(hierarchyParent, newName, component)) {
                    newName = this.createName(component, count);
                    ++count;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    newName = this.createName(originalName, ++count);
lbl30:
                    // 2 sources

                    ** while (!this.isUniqueName(hierarchyParent, (String)newName, (Component)component))
                }
            }
            hierarchyContainer.setName(newName, newNameGenerated);
        }
    }

    private boolean isUniqueName(HierarchyContainer<Component> parent, String name, Component swingComponent) {
        if (name == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        HierarchyContainer[] compIDs = parent.getComps();
        int length = compIDs.length;
        int index = 0;
        while (index < length) {
            Component childComponent = (Component)compIDs[index].getCompID().getComponent();
            String childName = childComponent.getName();
            if (name.equals(childName) && childComponent != swingComponent) {
                return false;
            }
            ++index;
        }
        index = 0;
        while (index < length) {
            if (name.equals(compIDs[index].getName())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private Collection<Component> getComponents(Component c) {
        if (c instanceof Container) {
            Container cont = (Container)c;
            ArrayList<Component> list = new ArrayList<Component>();
            list.addAll(Arrays.asList(cont.getComponents()));
            if (c instanceof JMenu) {
                list.add(((JMenu)c).getPopupMenu());
            } else if (c instanceof Window) {
                list.addAll(Arrays.asList(((Window)c).getOwnedWindows()));
            } else if (c instanceof JDesktopPane) {
                int count = cont.getComponentCount();
                int i = 0;
                while (i < count) {
                    JInternalFrame frame;
                    Component child = cont.getComponent(i);
                    if (child instanceof JInternalFrame.JDesktopIcon && (frame = ((JInternalFrame.JDesktopIcon)child).getInternalFrame()) != null) {
                        list.add(frame);
                    }
                    ++i;
                }
            }
            return list;
        }
        return new ArrayList<Component>();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.checkDispatchThread();
        Component component = e.getComponent();
        if (component instanceof Window) {
            this.remove((Window)component);
        } else {
            this.removeComponent(component, component.getParent());
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.checkDispatchThread();
        Component component = e.getComponent();
        if (component instanceof Window) {
            this.add((Window)component);
        } else {
            this.addComponent(component);
        }
    }

    private void checkDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                log.error((Object)"Method called outside of the dispatch thread. This may indicate a potential error in the AUT.", (Throwable)e);
            }
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        public void windowOpened(WindowEvent e) {
            this.windowActivated(e);
        }

        public void windowClosed(final WindowEvent event) {
            Runnable deregistrationRunnable = new Runnable(){

                public void run() {
                    ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(((Object)((Object)((SwingAUTServer)AUTServer.getInstance()))).getClass().getClassLoader());
                    try {
                        Window window = event.getWindow();
                        AUTSwingHierarchy.this.remove(window);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("deregistering window listener from window " + window));
                        }
                        window.removeWindowListener(WindowClosingListener.this);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalCL);
                    }
                }
            };
            AUTSwingHierarchy.this.registerListener(deregistrationRunnable);
        }

        public void windowDeactivated(WindowEvent e) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)((SwingAUTServer)AUTServer.getInstance()))).getClass().getClassLoader());
            try {
                Window window = e.getWindow();
                if (!window.isVisible()) {
                    AUTSwingHierarchy.this.remove(window);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }

        public void windowActivated(WindowEvent e) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)((SwingAUTServer)AUTServer.getInstance()))).getClass().getClassLoader());
            try {
                Window window = e.getWindow();
                if (window.isVisible() && AUTSwingHierarchy.this.getHierarchyContainer(window) == null) {
                    AUTSwingHierarchy.this.add(window);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
    }
}

