/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TreeComponent component from the concrete toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-09-29T12:49:28.388Z")
public class TreeComponent extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.concrete.components.TreeComponent {
            public TreeComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP collapseNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCollapse")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP collapseNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCollapseByIndices")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(indexpath)
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP expandNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcExpand")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP expandNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcExpandByIndices")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(indexpath)
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param extendSelection 
         *        whether to extend the selection or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelect")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(extendSelection.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param extendSelection 
         *        whether to extend the selection or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectByIndices")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(indexpath)
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(extendSelection.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param direction 
         *        the direction to navigate
         * @param numberOfNodes 
         *        the amount of nodes
         * @param numberOfClicks 
         *        the amount of interactions
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP move(
            @NonNull TreeDirection direction,
            @NonNull Integer numberOfNodes,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException {
            Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfNodes, "Argument 'numberOfNodes' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcMove")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(direction.rcValue())
                        .addParameter(numberOfNodes)
                        .addParameter(numberOfClicks)
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkExistenceOfNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkExistenceOfNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyPathByIndices")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(indexpath)
                        .addParameter(exists)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkTextOfSelectedNodeS(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkTextMousePosition(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyTextAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeTextpath 
         *        the tree textpath
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragNodeByTextpath(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeTextpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(treeTextpath, "Argument 'treeTextpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDragByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(treeTextpath)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeTextpath 
         *        the tree textpath
         * @param operator 
         *        the operator used for comparison
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeTextpath,
            @NonNull Operator operator,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(treeTextpath, "Argument 'treeTextpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDropByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(treeTextpath)
                        .addParameter(operator.rcValue())
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeIndexpath 
         *        the 1-based tree indexpath
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragNodeByIndexpath(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeIndexpath
        ) throws IllegalArgumentException {
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(treeIndexpath, "Argument 'treeIndexpath' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDragByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(treeIndexpath)
                        .build();
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeIndexpath 
         *        the 1-based tree indexpath
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeIndexpath,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            Validate.notNull(treeIndexpath, "Argument 'treeIndexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDropByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pathType.rcValue())
                        .addParameter(preAscend)
                        .addParameter(treeIndexpath)
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.0
         */
        @NonNull public CAP checkPropertyAtMousePosition(
            @NonNull String propertyName,
            @NonNull String propertyValue,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckPropertyAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
} 