/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter.utils;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.ui.rcp.views.dataset.AbstractDataSetPage;

public class ParamUtils {
    private static Pattern simpleParameter = Pattern.compile("^=\\{?([a-zA-Z0-9_]+)\\}?");
    private static Pattern oneParameter = Pattern.compile("^(.*)=\\{?([a-zA-Z0-9_]+)\\}?(.*)");
    private static Pattern variable = Pattern.compile("(.*)\\$\\{?([a-zA-Z0-9_]+)\\}?(.*)");
    private static Pattern function = Pattern.compile(".*\\?[a-zA-Z_]+\\(.*?");
    private static Pattern bulkMask = Pattern.compile("^(.*?)'(.*?)'(.*?)");

    private ParamUtils() {
    }

    public static String getValueForParam(IParameterInterfacePO node, IParamDescriptionPO param, int row, Locale locale) {
        String paramType = param.getType();
        String value = AbstractDataSetPage.getGuiStringForParamValue((IParameterInterfacePO)node, (IParamDescriptionPO)param, (int)row, (Locale)locale);
        if (value == null) {
            value = "null // TODO: <code>null</code> found as test data - check and fix in ITE";
        } else {
            if (function.matcher(value = ParamUtils.executeEscapes(value)).matches()) {
                return "null // TODO: Function usage - call a corresponding method instead of this ITE function: \"" + value + "\" ";
            }
            if (simpleParameter.matcher(value).matches()) {
                value = value.replaceAll(simpleParameter.pattern(), "$1");
            } else if (variable.matcher(value).matches() || oneParameter.matcher(value).matches()) {
                while (variable.matcher(value).matches()) {
                    value = value.replaceAll(variable.pattern(), "$1\" + VariableStore.getInstance().getValue(\"$2\") + \"$3");
                }
                while (oneParameter.matcher(value).matches()) {
                    value = value.replaceAll(oneParameter.pattern(), "$1\" + $2 + \"$3");
                }
                value = "\"" + value + "\"";
            } else if (paramType.equals("java.lang.String") || paramType.equals("guidancer.datatype.Variable")) {
                value = "\"" + value + "\"";
            } else if (StringUtils.isEmpty((String)value)) {
                value = "null // TODO: no test data found - check and fix in ITE";
            }
        }
        return value;
    }

    private static String executeEscapes(String value) {
        String adjustedValue = value;
        adjustedValue = adjustedValue.replaceAll(bulkMask.pattern(), "$1$2$3");
        adjustedValue = adjustedValue.replace("\\", "\\\\");
        adjustedValue = adjustedValue.replace("\"", "\\\"");
        adjustedValue = adjustedValue.replace("'", "\\'");
        return adjustedValue;
    }
}

