/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.compcheck;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;

public final class CompletenessGuard {
    private CompletenessGuard() {
    }

    public static void checkAll(Locale loc, INodePO root, IProgressMonitor monitor) {
        TreeTraverser traverser = new TreeTraverser(root);
        traverser.setMonitor(monitor);
        traverser.addOperation(new CheckObjectMappingCompleteness());
        traverser.addOperation(new CheckTestDataCompleteness(loc));
        traverser.addOperation(new CheckMissingTestCaseReferences());
        traverser.addOperation(new InactiveNodesOperation());
        traverser.traverse(true);
    }

    public static void checkTestData(Locale loc, INodePO root) {
        new TreeTraverser(root, new CheckTestDataCompleteness(loc)).traverse(true);
    }

    private static void setCompletenessObjectMapping(INodePO node, IAUTMainPO aut, boolean omFlag) {
        CompletenessGuard.setNodeProblem(node, ProblemFactory.createIncompleteObjectMappingProblem(aut), omFlag);
    }

    private static void setNodeProblem(INodePO node, IProblem problem, boolean deleteOrAdd) {
        if (deleteOrAdd) {
            node.removeProblem(problem);
        } else {
            node.addProblem(problem);
        }
    }

    private static void setCompletenessMissingTestCase(INodePO node, boolean completeTCFlag) {
        CompletenessGuard.setNodeProblem(node, ProblemFactory.MISSING_NODE, completeTCFlag);
    }

    public static void setCompletenessTestData(INodePO node, Locale loc, boolean flag) {
        CompletenessGuard.setNodeProblem(node, ProblemFactory.createIncompleteTestDataProblem(loc, node), flag);
    }

    private static void resetTestDataCompleteness(INodePO node) {
        HashSet<IProblem> toRemove = new HashSet<IProblem>();
        for (IProblem problem : node.getProblems()) {
            if (!problem.getProblemType().equals((Object)ProblemType.REASON_TD_INCOMPLETE)) continue;
            toRemove.add(problem);
        }
        for (IProblem problem : toRemove) {
            node.removeProblem(problem);
        }
    }

    public static void checkLocalTestData(INodePO node, Locale locale) {
        IExecTestCasePO execTc;
        INodePO possibleDataSourceNode = node;
        if (node instanceof IExecTestCasePO && (execTc = (IExecTestCasePO)node).getHasReferencedTD()) {
            possibleDataSourceNode = execTc.getSpecTestCase();
        }
        if (possibleDataSourceNode instanceof IParamNodePO) {
            IParamNodePO dataSourceNode = (IParamNodePO)possibleDataSourceNode;
            INodePO nodeToModify = null;
            if (!(node instanceof ISpecTestCasePO)) {
                nodeToModify = node;
            }
            if (nodeToModify != null) {
                CompletenessGuard.resetTestDataCompleteness(nodeToModify);
                CompletenessGuard.setCompletenessTestData(nodeToModify, locale, dataSourceNode.isTestDataComplete(locale));
            }
        }
    }

    private static class CheckMissingTestCaseReferences
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private CheckMissingTestCaseReferences() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                boolean isMissingSpecTc = execTc.getSpecTestCase() == null;
                CompletenessGuard.setCompletenessMissingTestCase(execTc, !isMissingSpecTc);
            }
            return !alreadyVisited;
        }
    }

    private static class CheckObjectMappingCompleteness
    implements ITreeNodeOperation<INodePO> {
        private final CompNamesBP m_compNamesBP = new CompNamesBP();
        private IAUTMainPO m_aut;

        private CheckObjectMappingCompleteness() {
        }

        private boolean handleCap(ITreeTraverserContext<INodePO> ctx, ICapPO cap) {
            Component metaComponentType;
            IObjectMappingPO objMap = this.m_aut.getObjMap();
            String compName = cap.getComponentName();
            IComponentNamePO compNamePo = ComponentNamesBP.getInstance().getCompNamePo(compName);
            if (compNamePo != null) {
                compName = compNamePo.getGuid();
            }
            if ((metaComponentType = cap.getMetaComponentType()) instanceof ConcreteComponent && ((ConcreteComponent)metaComponentType).hasDefaultMapping()) {
                CompletenessGuard.setCompletenessObjectMapping(cap, this.m_aut, true);
                return true;
            }
            if (compName != null && objMap != null) {
                IComponentIdentifier id = null;
                List<INodePO> currentTreePath = ctx.getCurrentTreePath();
                CompNameResult result = this.m_compNamesBP.findCompName(currentTreePath, cap, cap.getComponentName(), ComponentNamesBP.getInstance());
                try {
                    id = objMap.getTechnicalName(result.getCompName());
                }
                catch (LogicComponentNotManagedException logicComponentNotManagedException) {}
                if (id == null) {
                    int responsibleNodeIdx;
                    INodePO rNode = result.getResponsibleNode();
                    if (rNode instanceof ICapPO && (responsibleNodeIdx = currentTreePath.lastIndexOf(rNode) - 1) > -1) {
                        rNode = currentTreePath.get(responsibleNodeIdx);
                    }
                    CompletenessGuard.setCompletenessObjectMapping(rNode, this.m_aut, false);
                } else {
                    CompletenessGuard.setCompletenessObjectMapping(cap, this.m_aut, true);
                }
            }
            boolean hasCompleteOM = !cap.getProblems().contains(ProblemFactory.createIncompleteObjectMappingProblem(this.m_aut));
            return hasCompleteOM;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof ITestSuitePO) {
                ITestSuitePO ts = (ITestSuitePO)node;
                this.m_aut = ts.getAut();
            }
            if (this.m_aut != null) {
                CompletenessGuard.setCompletenessObjectMapping(node, this.m_aut, true);
            }
            return true;
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (this.m_aut != null && node instanceof ICapPO) {
                this.handleCap(ctx, (ICapPO)node);
            }
        }
    }

    private static class CheckTestDataCompleteness
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private Locale m_locale;

        public CheckTestDataCompleteness(Locale loc) {
            this.m_locale = loc;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            CompletenessGuard.checkLocalTestData(node, this.m_locale);
            return !alreadyVisited;
        }
    }

    private static class InactiveNodesOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private InactiveNodesOperation() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (!node.isActive()) {
                HashSet<IProblem> problemsToRemove = new HashSet<IProblem>(node.getProblems());
                for (IProblem problem : problemsToRemove) {
                    node.removeProblem(problem);
                }
            }
            return !alreadyVisited;
        }
    }
}

