/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.ios.internal.IosToolkitInfo;

/**
 * Factory for creating components from the ios toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2015-11-11T09:16:37.098Z")
public final class IosComponents {
    
    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = IosToolkit.createToolkitInformation();

    private IosComponents() {
        super();
    }
    
    /** 
     *  @return the toolkit information, not recommended to be modified
     */
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return TOOLKIT_INFORMATION;
    }

    /** create a new representative for a ButtonComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.ButtonComponent(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UIButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.ButtonComponent createUIButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIButton(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UISwitch} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.ButtonComponent createUISwitch (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UISwitch(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.TextInputComponent(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITextField} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextInputComponent createUITextField (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITextField(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITextView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextInputComponent createUITextView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITextView(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.TextComponent(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UILabel} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUILabel (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UILabel(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITableViewCell} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUITableViewCell (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITableViewCell(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UINavigationItemView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUINavigationItemView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UINavigationItemView(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITabBarButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUITabBarButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITabBarButton(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UIImageView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUIImageView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIImageView(componentIdentifier);
    }
    /** create a new representative for a List UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.List createList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.List> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.List(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITableView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.List createUITableView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.List> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITableView(componentIdentifier);
    }
    /** create a new representative for a TabComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TabComponent createTabComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.TabComponent(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UISegmentedControl} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TabComponent createUISegmentedControl (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UISegmentedControl(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITabBar} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.UITabBar createUITabBar (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.UITabBar> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITabBar(componentIdentifier);
    }
    /** create a new representative for a Picker UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.Picker createPicker (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.Picker> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.Picker(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UIPickerView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.Picker createUIPickerView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.Picker> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIPickerView(componentIdentifier);
    }
    /** create a new representative for a {@link UIApplication} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.UIApplication createUIApplication () {
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIApplication();
    }
}