/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the {@link ios.UITabBar} component from the ios toolkit.
 * 
 */
@RealizedType(realizedType="abstract.ios.TabComponent")
@TesterClass(testerClass="com.bredexsw.jubula.rc.mobile.ios.impl.UITabComponentTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-11-11T09:16:37.095Z")
public class UITabBar extends org.eclipse.jubula.toolkit.ios.internal.impl.TabComponent implements org.eclipse.jubula.toolkit.ios.components.UITabBar {
            public UITabBar(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param tabIndex 
         *        the 1-based tab index
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkBadgeValue(
            @NonNull String text,
            @NonNull Integer tabIndex,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(tabIndex, "Argument 'tabIndex' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckBadgeValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(tabIndex)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
} 