/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class CentralTestDataSetValueFunctionEvaluator
extends AbstractFunctionEvaluator {
    private static final Map<String, ITestDataCubePO> DATA_CUBES = new HashMap<String, ITestDataCubePO>();
    private static final Map<ITestDataCubePO, Map<String, IParamDescriptionPO>> PARAM_DESCRIPTIONS = new HashMap<ITestDataCubePO, Map<String, IParamDescriptionPO>>();
    private static final Map<IParamDescriptionPO, Map<String, Integer>> UNIQUE_KEYS = new HashMap<IParamDescriptionPO, Map<String, Integer>>();

    static {
        ClientTest.instance().addTestExecutionEventListener(new ITestExecutionEventListener(){

            public void stateChanged(TestExecutionEvent event) {
                if (event.getState() == TestExecutionEvent.State.TEST_EXEC_RESULT_TREE_READY) {
                    CentralTestDataSetValueFunctionEvaluator.registerDataCubes();
                    PARAM_DESCRIPTIONS.clear();
                    UNIQUE_KEYS.clear();
                }
            }

            public void endTestExecution() {
                PARAM_DESCRIPTIONS.clear();
                UNIQUE_KEYS.clear();
            }
        });
    }

    private static void registerDataCubes() {
        ITestDataCubePO[] allTestDataCubesFor;
        DATA_CUBES.clear();
        ITestDataCubePO[] iTestDataCubePOArray = allTestDataCubesFor = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)GeneralStorage.getInstance().getProject());
        int n = allTestDataCubesFor.length;
        int n2 = 0;
        while (n2 < n) {
            ITestDataCubePO testDataCubePO = iTestDataCubePOArray[n2];
            DATA_CUBES.put(testDataCubePO.getName(), testDataCubePO);
            ++n2;
        }
    }

    private static Map<String, IParamDescriptionPO> registerParamDescription(ITestDataCubePO dataSet) {
        HashMap<String, IParamDescriptionPO> paramDescriptionsForOneDataSet = new HashMap<String, IParamDescriptionPO>();
        for (IParamDescriptionPO description : dataSet.getParameterList()) {
            paramDescriptionsForOneDataSet.put(description.getName(), description);
        }
        PARAM_DESCRIPTIONS.put(dataSet, paramDescriptionsForOneDataSet);
        return paramDescriptionsForOneDataSet;
    }

    private static Map<String, Integer> registerUniqueKeyMap(ITestDataCubePO dataSet, IParamDescriptionPO keyColumn) throws InvalidDataException {
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        ITDManager dataManager = dataSet.getDataManager();
        int i = 0;
        while (i < dataManager.getDataSetCount()) {
            String cellValue = dataManager.getCell(i, keyColumn);
            if (keyMap.get(cellValue) != null) {
                throw new InvalidDataException("The key '" + cellValue + "' for column '" + keyColumn.getName() + "' is not unique in central test data set '" + dataSet.getName() + "'!", MessageIDs.E_FUNCTION_EVAL_ERROR);
            }
            keyMap.put(cellValue, i);
            ++i;
        }
        UNIQUE_KEYS.put(keyColumn, keyMap);
        return keyMap;
    }

    public String evaluate(String[] arguments) throws InvalidDataException {
        this.validateParamCount(arguments, 4);
        ITestDataCubePO dataSet = CentralTestDataSetValueFunctionEvaluator.validateDataSetName(arguments[0]);
        IParamDescriptionPO keyColumn = CentralTestDataSetValueFunctionEvaluator.validateColumnName(dataSet, arguments[1]);
        int entryKey = CentralTestDataSetValueFunctionEvaluator.validateEntryKey(dataSet, keyColumn, arguments[2]);
        IParamDescriptionPO column = CentralTestDataSetValueFunctionEvaluator.validateColumnName(dataSet, arguments[3]);
        return CentralTestDataSetValueFunctionEvaluator.getDataSetValue(dataSet, entryKey, column);
    }

    private static String getDataSetValue(ITestDataCubePO dataSet, int row, IParamDescriptionPO column) throws InvalidDataException {
        String dataSetValue = dataSet.getDataManager().getCell(row, column);
        return new GuiParamValueConverter(dataSetValue, (IParameterInterfacePO)dataSet, null, (IParamValueValidator)new NullValidator()).getExecutionString(new ArrayList());
    }

    private static IParamDescriptionPO validateColumnName(ITestDataCubePO dataSet, String columnName) throws InvalidDataException {
        IParamDescriptionPO column;
        Map<String, IParamDescriptionPO> map = PARAM_DESCRIPTIONS.get(dataSet);
        if (map == null) {
            map = CentralTestDataSetValueFunctionEvaluator.registerParamDescription(dataSet);
        }
        if ((column = map.get(columnName)) != null) {
            return column;
        }
        throw new InvalidDataException("Column '" + columnName + "' is not available in central test data set '" + dataSet.getName() + "'!", MessageIDs.E_FUNCTION_EVAL_ERROR);
    }

    private static int validateEntryKey(ITestDataCubePO dataSet, IParamDescriptionPO keyColumn, String key) throws InvalidDataException {
        Integer row;
        Map<String, Integer> keyMap = UNIQUE_KEYS.get(keyColumn);
        if (keyMap == null) {
            keyMap = CentralTestDataSetValueFunctionEvaluator.registerUniqueKeyMap(dataSet, keyColumn);
        }
        if ((row = keyMap.get(key)) != null) {
            return row;
        }
        throw new InvalidDataException("Key '" + key + "' is not available in column '" + keyColumn.getName() + "' in central test data set '" + dataSet.getName() + "'!", MessageIDs.E_FUNCTION_EVAL_ERROR);
    }

    private static ITestDataCubePO validateDataSetName(String dataSetName) throws InvalidDataException {
        ITestDataCubePO dataCube = DATA_CUBES.get(dataSetName);
        if (dataCube != null) {
            return dataCube;
        }
        throw new InvalidDataException("Central test data set '" + dataSetName + "' is not available!", MessageIDs.E_FUNCTION_EVAL_ERROR);
    }
}

