/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteBrowserTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class DeleteTreeItemHandlerTSBrowser
extends AbstractDeleteBrowserTreeItemHandler {
    @Override
    protected List<MultipleNodePM.AbstractCmdHandle> getDeleteCommands(List<INodePO> nodesToDelete) {
        ArrayList<MultipleNodePM.AbstractCmdHandle> cmds = new ArrayList<MultipleNodePM.AbstractCmdHandle>(nodesToDelete.size());
        for (INodePO node : nodesToDelete) {
            MultipleNodePM.DeleteExecHandle cmd = null;
            if (node instanceof ITestSuitePO) {
                ITestSuitePO testSuite = (ITestSuitePO)node;
                List refTs = NodePM.getInternalRefTestSuites((String)testSuite.getGuid(), (long)testSuite.getParentProjectId());
                if (refTs.size() > 0) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_TS);
                    return ListUtils.EMPTY_LIST;
                }
                this.closeOpenEditor((IPersistentObject)testSuite);
                cmd = new MultipleNodePM.DeleteExecHandle((IExecPersistable)testSuite);
            } else if (node instanceof ITestJobPO) {
                ITestJobPO testjob = (ITestJobPO)node;
                this.closeOpenEditor((IPersistentObject)testjob);
                cmd = new MultipleNodePM.DeleteExecHandle((IExecPersistable)testjob);
            } else if (node instanceof ICategoryPO) {
                ICategoryPO category = (ICategoryPO)node;
                cmd = new MultipleNodePM.DeleteCatHandle(category);
            }
            cmds.add((MultipleNodePM.AbstractCmdHandle)cmd);
        }
        return cmds;
    }
}

