/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.TextControlBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamTextContentAssisted;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public abstract class AbstractDataSetPage
extends Page
implements ISelectionListener,
IAdaptable,
DataEventDispatcher.IParamChangedListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener {
    protected static final int DATASET_NUMBER_COLUMNWIDTH = 20;
    protected static final int COLUMN_WIDTH = 70;
    private IParameterInterfacePO m_paramInterfaceObj;
    private boolean m_buttonEnabled;
    private Control m_control;
    private TableViewer m_tableViewer;
    private DSVTableCursor m_tableCursor;
    private Button m_addButton;
    private Button m_insertButton;
    private Button m_deleteButton;
    private Button m_upButton;
    private Button m_downButton;
    private ControlEnabler m_controlEnabler;
    private AbstractParamInterfaceBP m_paramBP;
    private IWorkbenchPart m_currentPart;
    private IStructuredSelection m_currentSelection;

    public AbstractDataSetPage(AbstractParamInterfaceBP bp) {
        this.setParamBP(bp);
    }

    private void setTableViewer(TableViewer tableViewer) {
        this.m_tableViewer = tableViewer;
    }

    private TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    private Table getTable() {
        return this.getTableViewer().getTable();
    }

    private void checkComboSelection(TestDataRowAction action, int row) {
        this.getTableViewer().refresh();
    }

    public void createControl(Composite parent) {
        Composite topLevelComposite = new Composite(parent, 0);
        topLevelComposite.setData("TEST_COMP_NAME", (Object)"DataSetViewPage");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        topLevelComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        topLevelComposite.setLayoutData((Object)layoutData);
        this.m_control = topLevelComposite;
        Composite buttonComp = new Composite(topLevelComposite, 2048);
        layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        buttonComp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        buttonComp.setLayoutData((Object)gridData);
        this.initTableViewer(buttonComp);
        this.createButtons(buttonComp);
        Plugin.getHelpSystem().setHelp((Control)this.getTable(), "org.eclipse.jubula.client.ua.help.guidancerDataSetViewContextId");
    }

    private void createButtons(Composite parent) {
        Composite bottomComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = 2;
        GridData gridDataBottom = new GridData(0, 0, true, false);
        gridDataBottom.horizontalAlignment = 4;
        gridDataBottom.horizontalSpan = 3;
        bottomComp.setLayoutData((Object)gridDataBottom);
        bottomComp.setLayout((Layout)layout);
        this.setAddButton(new Button(bottomComp, 0x1000008));
        this.getAddButton().setData("TEST_COMP_NAME", (Object)"DataSetView.AddButton");
        this.getAddButton().setText(Messages.JubulaDataSetViewAppend);
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getAddButton().setLayoutData((Object)gridData);
        this.getAddButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getAddButton());
        this.setInsertButton(new Button(bottomComp, 0x1000008));
        this.getInsertButton().setData("TEST_COMP_NAME", (Object)"DataSetView.InsertButton");
        this.getInsertButton().setText(Messages.DataSetViewInsert);
        gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getInsertButton().setLayoutData((Object)gridData);
        this.getInsertButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getInsertButton());
        this.setDeleteButton(new Button(bottomComp, 0x1000008));
        this.getDeleteButton().setData("TEST_COMP_NAME", (Object)"DataSetView.DeleteButton");
        this.getDeleteButton().setText(Messages.JubulaDataSetViewDelete);
        gridData = new GridData(32);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 80;
        this.getDeleteButton().setLayoutData((Object)gridData);
        this.getDeleteButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getDeleteButton());
        this.setDownButton(new Button(bottomComp, 0x1000008));
        this.getDownButton().setData("TEST_COMP_NAME", (Object)"DataSetView.DownButton");
        this.getDownButton().setImage(IconConstants.DOWN_ARROW_IMAGE);
        gridData = new GridData(128);
        this.getDownButton().setLayoutData((Object)gridData);
        this.getDownButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getDownButton());
        this.setUpButton(new Button(bottomComp, 0x1000008));
        this.getUpButton().setData("TEST_COMP_NAME", (Object)"DataSetView.UpButton");
        this.getUpButton().setImage(IconConstants.UP_ARROW_IMAGE);
        gridData = new GridData(128);
        this.getUpButton().setLayoutData((Object)gridData);
        this.getUpButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getUpButton());
        this.addListenerToButtons();
    }

    private void initTableViewer(Composite parent) {
        this.setTableViewer(new TableViewer(parent, 65540));
        Table table = this.getTable();
        table.setData("TEST_COMP_NAME", (Object)"DataSetView.DataTable");
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        this.getTableViewer().setUseHashlookup(true);
        this.getTableViewer().setContentProvider((IContentProvider)new GeneralContentProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new GeneralLabelProvider());
        this.setTableCursor(new DSVTableCursor(this.getTable(), 0));
    }

    private void addListenerToButtons() {
        this.getAddButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.addDataSet();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.ADDED, index);
                AbstractDataSetPage.this.getControlEnabler().selectionChanged(AbstractDataSetPage.this.m_currentPart, (ISelection)AbstractDataSetPage.this.m_currentSelection);
            }
        });
        this.getInsertButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.insertDataSetAtCurrentSelection();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.INSERTED, index);
            }
        });
        this.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.removeDataSet();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.DELETED, index);
            }
        });
        this.getUpButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.moveDataSetUp();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.MOVED_UP, index);
            }
        });
        this.getDownButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.moveDataSetDown();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.MOVED_DOWN, index);
            }
        });
    }

    private int getSelectedDataSet() {
        return this.getTableViewer().getTable().getSelectionIndex();
    }

    private void moveDataSetDown() {
        int row = this.getSelectedDataSet();
        this.moveDataSet(row, row + 1);
    }

    private void moveDataSetUp() {
        int row = this.getSelectedDataSet();
        this.moveDataSet(row, row - 1);
    }

    private void moveDataSet(int fromIndex, int toIndex) {
        ITDManager man;
        int rowCount = this.getParamInterfaceObj().getDataManager().getDataSetCount();
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        editor.getEditorHelper().requestEditableState();
        if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
            this.getTableViewer().setInput((Object)man);
        }
        ITDManager tdman = this.getParamInterfaceObj().getDataManager();
        if (fromIndex >= 0 && fromIndex < rowCount && toIndex >= 0 && toIndex < rowCount) {
            IDataSetPO selectedDataSet = tdman.getDataSet(fromIndex);
            if (fromIndex > toIndex) {
                tdman.insertDataSet(selectedDataSet, toIndex);
                tdman.removeDataSet(fromIndex + 1);
            } else {
                tdman.insertDataSet(selectedDataSet, toIndex + 1);
                tdman.removeDataSet(fromIndex);
            }
            this.getTableCursor().setSelection(toIndex, this.getTableCursor().getColumn());
            this.getTableViewer().refresh();
            DataEventDispatcher.getInstance().fireParamChangedListener();
            editor.getEditorHelper().setDirty(true);
        }
    }

    private void addDataSet() {
        int rowCount = this.getParamInterfaceObj().getDataManager().getDataSetCount();
        this.insertDataSet(rowCount);
    }

    private void insertDataSetAtCurrentSelection() {
        int row = this.getSelectedDataSet();
        this.insertDataSet(row);
    }

    private void insertDataSet(int row) {
        ITDManager man;
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        editor.getEditorHelper().requestEditableState();
        if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
            this.getTableViewer().setInput((Object)man);
        }
        if (row > -1) {
            this.getParamBP().addDataSet(this.getParamInterfaceObj(), row);
        } else {
            this.addDataSet();
        }
        editor.getEditorHelper().setDirty(true);
        this.getTableViewer().refresh();
        int rowToSelect = row;
        if (rowToSelect == -1) {
            rowToSelect = this.getTable().getItemCount();
        } else {
            this.getTableCursor().setSelection(rowToSelect, 1);
            this.setFocus();
        }
        this.getTable().setSelection(rowToSelect);
        DataEventDispatcher.getInstance().fireParamChangedListener();
    }

    public Control getControl() {
        return this.m_control;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setFocus() {
        this.getTable().setFocus();
    }

    private ControlEnabler getControlEnabler() {
        if (this.m_controlEnabler == null) {
            this.m_controlEnabler = new ControlEnabler();
        }
        return this.m_controlEnabler;
    }

    private void setAddButton(Button addButton) {
        this.m_addButton = addButton;
    }

    private Button getAddButton() {
        return this.m_addButton;
    }

    private void setInsertButton(Button insertButton) {
        this.m_insertButton = insertButton;
    }

    private Button getInsertButton() {
        return this.m_insertButton;
    }

    private void setDeleteButton(Button deleteButton) {
        this.m_deleteButton = deleteButton;
    }

    private Button getDeleteButton() {
        return this.m_deleteButton;
    }

    private void setUpButton(Button upButton) {
        this.m_upButton = upButton;
    }

    private Button getUpButton() {
        return this.m_upButton;
    }

    private void setDownButton(Button downButton) {
        this.m_downButton = downButton;
    }

    private Button getDownButton() {
        return this.m_downButton;
    }

    private void clearTableViewer() {
        this.getTable().removeAll();
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
    }

    private String initDataSetColumn() {
        this.clearTableViewer();
        Table table = this.getTable();
        TableColumn dataSetNumberCol = new TableColumn(table, 0);
        dataSetNumberCol.setText(Messages.DataSetViewControllerDataSetNumber);
        dataSetNumberCol.setWidth(20);
        return dataSetNumberCol.getText();
    }

    private void packTable() {
        Table table = this.getTable();
        TableColumn[] columns = table.getColumns();
        int columnCount = columns.length;
        int i = 1;
        while (i < columnCount) {
            TableColumn column = columns[i];
            column.pack();
            if (column.getWidth() < 70) {
                column.setWidth(70);
            }
            ++i;
        }
    }

    private void initTableViewerParameterColumns() {
        if (this.getParamInterfaceObj() == null) {
            return;
        }
        Table table = this.getTable();
        String[] columnProperties = new String[this.getParamInterfaceObj().getParameterList().size() + 1];
        columnProperties[0] = this.initDataSetColumn();
        int i = 1;
        for (IParamDescriptionPO descr : this.getParamInterfaceObj().getParameterList()) {
            TableColumn column = new TableColumn(table, 0);
            String columnName = descr.getName();
            column.setText(columnName);
            columnProperties[i++] = columnName;
            column.setWidth(70);
        }
        this.getTableViewer().setColumnProperties(columnProperties);
    }

    private void updateView() {
        this.clearTableViewer();
        IParameterInterfacePO paramObj = this.getParamInterfaceObj();
        if (paramObj != null && this.isNodeValid(paramObj)) {
            this.getTableViewer().setInput((Object)this.getInputForTable(paramObj));
            this.createTable();
        } else {
            this.getTableViewer().setInput(null);
        }
        this.getTableViewer().refresh();
    }

    protected abstract boolean isNodeValid(IParameterInterfacePO var1);

    private void createTable() {
        this.initTableViewerParameterColumns();
        this.packTable();
    }

    public static String getGuiStringForParamValue(IParameterInterfacePO paramObj, IParamDescriptionPO desc, int rowCount) {
        return AbstractParamInterfaceBP.getGuiStringForParamValue((IParameterInterfacePO)paramObj, (IParamDescriptionPO)desc, (int)rowCount);
    }

    public void handleParamChanged() {
        this.initTableViewerParameterColumns();
        this.updateView();
    }

    public void handleProjectLoaded() {
        this.setParamInterfaceObj(null);
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.getTableViewer().setInput(null);
            }
        });
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (dataState == DataEventDispatcher.DataState.Deleted && po.equals(this.getParamInterfaceObj())) {
            this.setParamInterfaceObj(null);
            this.updateView();
        }
        if (dataState == DataEventDispatcher.DataState.StructureModified && po instanceof ITestDataCategoryPO) {
            this.updateView();
        }
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.getControlEnabler().selectionChanged(AbstractDataSetPage.this.m_currentPart, (ISelection)AbstractDataSetPage.this.m_currentSelection);
            }
        });
    }

    private void removeDataSet() {
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        if (editor == null) {
            return;
        }
        if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            ITDManager man;
            if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
                this.getTableViewer().setInput((Object)man);
            }
            int row = this.getSelectedDataSet();
            try {
                if (row == -1 && this.getTableCursor().getRow() != null) {
                    row = this.getTable().indexOf(this.getTableCursor().getRow());
                }
                if (row > -1) {
                    editor.getEditorHelper().getEditSupport().lockWorkVersion();
                    this.getParamBP().removeDataSet(this.getParamInterfaceObj(), row, (IParamNameMapper)editor.getEditorHelper().getEditSupport().getParamMapper());
                    editor.getEditorHelper().setDirty(true);
                    this.getTableViewer().refresh();
                    this.setIsEntrySetComplete(this.getParamInterfaceObj());
                    if (this.getTable().getItemCount() != 0) {
                        if (this.getTable().getItemCount() <= row && this.getTable().getItemCount() > 0) {
                            this.getTable().setSelection(--row);
                        } else {
                            this.getTable().setSelection(row);
                        }
                        this.getTableCursor().setSelection(row, 1);
                    } else {
                        this.getDeleteButton().setEnabled(false);
                        this.getInsertButton().setEnabled(false);
                        this.getUpButton().setEnabled(false);
                        this.getDownButton().setEnabled(false);
                    }
                    this.setFocus();
                    DataEventDispatcher.getInstance().fireParamChangedListener();
                }
            }
            catch (PMException pme) {
                PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
            }
        }
    }

    private void reactOnChange(IWorkbenchPart part, IStructuredSelection selection) {
        this.m_currentPart = part;
        this.m_currentSelection = selection;
        this.getControlEnabler().selectionChanged(part, (ISelection)selection);
        IParameterInterfacePO paramInterfacePO = this.getSelectedParamInterfaceObj(selection);
        if (this.getParamInterfaceObj() != null && this.getParamInterfaceObj() == paramInterfacePO) {
            return;
        }
        this.setParamInterfaceObj(paramInterfacePO);
        this.updateView();
    }

    private IParameterInterfacePO getSelectedParamInterfaceObj(IStructuredSelection selection) {
        IParameterInterfacePO paramInterfacePO = null;
        Object firstSel = selection.getFirstElement();
        if (firstSel instanceof IParameterInterfacePO) {
            paramInterfacePO = (IParameterInterfacePO)firstSel;
        }
        return paramInterfacePO;
    }

    protected abstract void setIsEntrySetComplete(IParameterInterfacePO var1);

    protected abstract boolean isEditorOpen(IParameterInterfacePO var1);

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.reactOnChange(part, (IStructuredSelection)selection);
    }

    private void setParamBP(AbstractParamInterfaceBP paramBP) {
        this.m_paramBP = paramBP;
    }

    private AbstractParamInterfaceBP getParamBP() {
        return this.m_paramBP;
    }

    private void setParamInterfaceObj(IParameterInterfacePO paramInterfaceObj) {
        this.m_paramInterfaceObj = paramInterfaceObj;
    }

    private IParameterInterfacePO getParamInterfaceObj() {
        return this.m_paramInterfaceObj;
    }

    private GuiParamValueConverter getGuiParamValueConverter(String value, IParameterInterfacePO paramInterfaceObj, IParamDescriptionPO currentParamDescription, IParamValueValidator dataValidator) {
        return new GuiParamValueConverter(value, paramInterfaceObj, currentParamDescription, dataValidator);
    }

    protected ITDManager getInputForTable(IParameterInterfacePO paramInterface) {
        return paramInterface.getDataManager();
    }

    private void setTableCursor(DSVTableCursor tableCursor) {
        this.m_tableCursor = tableCursor;
    }

    public DSVTableCursor getTableCursor() {
        return this.m_tableCursor;
    }

    private static abstract class AbstractContentProvider
    implements IStructuredContentProvider {
        private AbstractContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private abstract class AbstractControlEnabler {
        private List<Control> m_controlList = new ArrayList<Control>();
        private boolean m_areControlsEnabled = true;

        private AbstractControlEnabler() {
        }

        public void addControl(Control control) {
            if (!this.getControlList().contains(control)) {
                this.getControlList().add(control);
            }
        }

        protected List<Control> getControlList() {
            return this.m_controlList;
        }

        public void setControlsEnabled(boolean enabled) {
            this.m_areControlsEnabled = enabled;
            for (Control control : this.getControlList()) {
                control.setEnabled(enabled);
            }
        }

        public boolean areControlsEnabled() {
            return this.m_areControlsEnabled;
        }
    }

    private abstract class AbstractLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private AbstractLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (!AbstractDataSetPage.this.getControlEnabler().areControlsEnabled()) {
                return LayoutUtil.GRAY_COLOR;
            }
            return null;
        }
    }

    protected class ControlEnabler
    extends AbstractControlEnabler
    implements ISelectionListener {
        protected ControlEnabler() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            IParameterInterfacePO paramNode = AbstractDataSetPage.this.getSelectedParamInterfaceObj(strucSelection);
            boolean correctPart = false;
            if (part != null) {
                boolean bl = correctPart = part == AbstractDataSetPage.this || part.getAdapter(AbstractJBEditor.class) != null;
            }
            if (!correctPart) {
                AbstractDataSetPage.this.getTable().setForeground(LayoutUtil.GRAY_COLOR);
            } else {
                AbstractDataSetPage.this.getTable().setForeground(LayoutUtil.DEFAULT_OS_COLOR);
            }
            boolean hasInput = !strucSelection.isEmpty();
            boolean isEditorOpen = AbstractDataSetPage.this.isEditorOpen(paramNode);
            boolean hasParameter = false;
            boolean hasExcelFile = false;
            boolean hasReferencedDataCube = false;
            if (paramNode != null) {
                hasParameter = !paramNode.getParameterList().isEmpty();
                String dataFile = paramNode.getDataFile();
                hasExcelFile = dataFile != null && dataFile.length() != 0;
                hasReferencedDataCube = paramNode.getReferencedDataCube() != null;
            }
            boolean isCAP = paramNode instanceof ICapPO;
            AbstractDataSetPage.this.m_buttonEnabled = correctPart && hasInput && isEditorOpen && !isCAP && !hasExcelFile && !hasReferencedDataCube && hasParameter;
            this.setControlsEnabled(AbstractDataSetPage.this.m_buttonEnabled);
        }
    }

    public class DSVTableCursor
    extends TableCursor {
        private ControlEditor m_editor;
        private AbstractJBEditor m_tcEditor;
        private KeyAdapter m_keyListener;
        private MouseAdapter m_mouseListener;
        private CursorListener m_cursorListener;
        private EditorFocusListener m_focusListener;
        private boolean m_wasActivatedWithEnterKey;
        private String m_oldValue;
        private Listener m_listener;

        public DSVTableCursor(Table parent, int style) {
            super(parent, style);
            this.m_keyListener = new EditorKeyListener();
            this.m_mouseListener = new EditorMouseListener();
            this.m_cursorListener = new CursorListener();
            this.m_focusListener = new EditorFocusListener();
            this.m_wasActivatedWithEnterKey = false;
            this.m_listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 13 && event.widget instanceof CCombo) {
                        DSVTableCursor.this.writeData();
                    }
                }
            };
            this.addSelectionListener((SelectionListener)this.m_cursorListener);
            this.addMouseListener((MouseListener)this.m_mouseListener);
            this.addKeyListener((KeyListener)this.m_keyListener);
            this.m_editor = new ControlEditor((Composite)this);
            this.m_editor.grabHorizontal = true;
            this.m_editor.grabVertical = true;
        }

        private int getColumnIndexOfProperty(String columnProperty) {
            Object[] props = AbstractDataSetPage.this.getTableViewer().getColumnProperties();
            int i = 0;
            while (i < props.length) {
                if (columnProperty.equals(props[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void writeData() {
            if (AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor) {
                this.m_tcEditor = (AbstractJBEditor)AbstractDataSetPage.this.m_currentPart;
            }
            if (this.m_tcEditor == null) {
                return;
            }
            int column = this.getColumn();
            Control editor = this.m_editor.getEditor();
            if (!TextControlBP.isTextValid(editor)) {
                TextControlBP.setText(this.m_oldValue, editor);
            }
            String property = AbstractDataSetPage.this.getTableViewer().getColumnProperties()[column].toString();
            String value = TextControlBP.getText(editor);
            if (this.m_oldValue != null && this.m_oldValue.equals(value)) {
                return;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            this.writeDataSetData(property, value, this.m_tcEditor);
        }

        private void writeDataSetData(String property, Object value, AbstractJBEditor edit) {
            int langIndex = this.getColumnIndexOfProperty(property);
            int dsNumber = AbstractDataSetPage.this.getSelectedDataSet();
            int paramIndex = AbstractDataSetPage.this.getTable().getSelectionIndex();
            this.setValueToModel(value, edit, paramIndex, dsNumber);
            AbstractDataSetPage.this.getTable().getItem(paramIndex).setText(langIndex, value == null ? "" : (String)value);
        }

        private void setValueToModel(Object value, AbstractJBEditor editor, int paramIndex, int dsNumber) {
            if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                ParamNameBPDecorator mapper = editor.getEditorHelper().getEditSupport().getParamMapper();
                GuiParamValueConverter conv = AbstractDataSetPage.this.getGuiParamValueConverter((String)value, AbstractDataSetPage.this.getParamInterfaceObj(), this.getCurrentParamDescription(), ((CheckedParamText)this.m_editor.getEditor()).getDataValidator());
                if (conv.getErrors().isEmpty()) {
                    AbstractDataSetPage.this.getParamBP().startParameterUpdate(conv, dsNumber, (IParamNameMapper)mapper);
                    AbstractDataSetPage.this.setIsEntrySetComplete(AbstractDataSetPage.this.getParamInterfaceObj());
                    editor.getEditorHelper().setDirty(true);
                    new IsAliveThread(){

                        public void run() {
                            Plugin.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DataEventDispatcher ded = DataEventDispatcher.getInstance();
                                    ded.firePropertyChanged(false);
                                    ded.fireParamChangedListener();
                                }
                            });
                        }
                    }.start();
                }
            }
        }

        public void dispose() {
            this.removeSelectionListener((SelectionListener)this.m_cursorListener);
            this.removeMouseListener((MouseListener)this.m_mouseListener);
            this.m_editor.getEditor().removeFocusListener((FocusListener)this.m_focusListener);
            super.dispose();
        }

        private boolean canModify() {
            boolean isEditor;
            if (!(AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor)) {
                return false;
            }
            AbstractJBEditor edit = (AbstractJBEditor)AbstractDataSetPage.this.m_currentPart;
            boolean isFirstColumn = this.getColumn() == 0;
            boolean bl = isEditor = edit != null;
            return !isFirstColumn && isEditor && AbstractDataSetPage.this.getControlEnabler().areControlsEnabled();
        }

        protected void checkSubclass() {
        }

        private Control createEditor() {
            Control control = TestDataControlFactory.createControl(AbstractDataSetPage.this.getParamInterfaceObj(), this.getParamName(), (Composite)this, 0);
            control.addKeyListener((KeyListener)this.m_keyListener);
            control.setFocus();
            control.addListener(13, this.m_listener);
            this.m_oldValue = this.getRow().getText(this.getColumn());
            TextControlBP.setText(this.m_oldValue, control);
            TextControlBP.selectAll(control);
            return control;
        }

        private String getParamName() {
            return AbstractDataSetPage.this.getTableViewer().getTable().getColumn(this.getColumn()).getText();
        }

        private IParamDescriptionPO getCurrentParamDescription() {
            String paramName = this.getParamName();
            return AbstractDataSetPage.this.getParamInterfaceObj().getParameterForName(paramName);
        }

        private void activateEditor() {
            if (this.canModify()) {
                this.m_editor.setEditor(this.createEditor());
                Control editorCtrl = this.m_editor.getEditor();
                if (editorCtrl != null && !editorCtrl.isDisposed()) {
                    editorCtrl.addFocusListener((FocusListener)this.m_focusListener);
                }
                TextControlBP.selectAll(this.m_editor.getEditor());
            }
        }

        private class CursorListener
        extends SelectionAdapter {
            private CursorListener() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DSVTableCursor.this.activateEditor();
                DSVTableCursor.this.m_wasActivatedWithEnterKey = true;
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractDataSetPage.this.getTable().setSelection(new TableItem[]{DSVTableCursor.this.getRow()});
            }
        }

        private class EditorFocusListener
        extends FocusAdapter {
            private EditorFocusListener() {
            }

            public void focusLost(FocusEvent e) {
                CheckedParamTextContentAssisted ed;
                if (DSVTableCursor.this.m_editor.getEditor() instanceof CheckedParamTextContentAssisted && (ed = (CheckedParamTextContentAssisted)DSVTableCursor.this.m_editor.getEditor()).isPopupOpen() && ed.isFocusControl()) {
                    super.focusLost(e);
                    return;
                }
                DSVTableCursor.this.writeData();
                DSVTableCursor.this.m_editor.getEditor().dispose();
                super.focusLost(e);
            }
        }

        private class EditorKeyListener
        extends KeyAdapter {
            private EditorKeyListener() {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                    return;
                }
                if (e.character != '\b' && e.character != '\u007f' && e.character != '\u001b' && e.character != '\r' && e.character != '\u1000050' && Character.isISOControl(e.character)) {
                    return;
                }
                if (e.getSource().equals(DSVTableCursor.this.m_editor.getEditor())) {
                    if (e.character == '\u001b') {
                        TextControlBP.setText(DSVTableCursor.this.m_oldValue, DSVTableCursor.this.m_editor.getEditor());
                        DSVTableCursor.this.writeData();
                        TableItem rowItem = DSVTableCursor.this.getRow();
                        int col = DSVTableCursor.this.getColumn();
                        rowItem.setText(col, DSVTableCursor.this.m_oldValue);
                        DSVTableCursor.this.m_editor.getEditor().dispose();
                        return;
                    }
                    if (e.character == '\r' || e.character == '\u1000050') {
                        if (DSVTableCursor.this.m_wasActivatedWithEnterKey) {
                            DSVTableCursor.this.m_wasActivatedWithEnterKey = false;
                            return;
                        }
                        this.handleCR();
                    }
                }
                if (e.getSource() instanceof DSVTableCursor) {
                    if (e.character == '\u001b') {
                        return;
                    }
                    DSVTableCursor.this.activateEditor();
                    if (DSVTableCursor.this.m_editor.getEditor() != null && !DSVTableCursor.this.m_editor.getEditor().isDisposed() && e.character != '\r' && e.character != '\u1000050' && !(DSVTableCursor.this.m_editor.getEditor() instanceof CCombo)) {
                        String sign = new Character(e.character).toString();
                        if (e.character == '\u007f' || e.character == '\b') {
                            sign = "";
                        }
                        TextControlBP.setText(sign, DSVTableCursor.this.m_editor.getEditor());
                        TextControlBP.setSelection(DSVTableCursor.this.m_editor.getEditor(), 1);
                    }
                }
            }

            private void handleCR() {
                Control editorControl = DSVTableCursor.this.m_editor.getEditor();
                if (!editorControl.isDisposed()) {
                    DSVTableCursor.this.writeData();
                }
                if (!editorControl.isDisposed()) {
                    TableItem rowItem = DSVTableCursor.this.getRow();
                    int col = DSVTableCursor.this.getColumn();
                    rowItem.setText(col, TextControlBP.getText(editorControl));
                    editorControl.dispose();
                    int row = AbstractDataSetPage.this.getTable().indexOf(DSVTableCursor.this.getRow());
                    if (AbstractDataSetPage.this.getTable().getColumnCount() > col + 1) {
                        DSVTableCursor.this.setSelection(row, col + 1);
                        AbstractDataSetPage.this.getTable().setSelection(row);
                        DSVTableCursor.this.setFocus();
                    } else if (AbstractDataSetPage.this.getTable().getItemCount() > row + 1) {
                        DSVTableCursor.this.setSelection(row + 1, 1);
                        AbstractDataSetPage.this.getTable().setSelection(row + 1);
                    } else {
                        AbstractDataSetPage.this.getAddButton().setFocus();
                    }
                }
            }
        }

        private class EditorMouseListener
        extends MouseAdapter {
            private EditorMouseListener() {
            }

            public void mouseUp(MouseEvent e) {
                DSVTableCursor.this.activateEditor();
                DSVTableCursor.this.m_wasActivatedWithEnterKey = false;
            }
        }
    }

    private static class GeneralContentProvider
    extends AbstractContentProvider {
        private GeneralContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            ITDManager tdMan = (ITDManager)inputElement;
            List rows = tdMan.getDataSets();
            return rows.toArray();
        }
    }

    private class GeneralLabelProvider
    extends AbstractLabelProvider {
        private GeneralLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof IDataSetPO)) {
                return "";
            }
            ITDManager tdMan = (ITDManager)AbstractDataSetPage.this.getTableViewer().getInput();
            IDataSetPO row = (IDataSetPO)element;
            int rowCount = tdMan.getDataSets().indexOf(row);
            if (columnIndex == 0) {
                AbstractDataSetPage.this.getTable().getItem(rowCount).setBackground(columnIndex, AbstractDataSetPage.this.getTable().getDisplay().getSystemColor(22));
                return "" + (rowCount + 1);
            }
            List paramList = AbstractDataSetPage.this.getParamInterfaceObj().getParameterList();
            String value = "";
            if (columnIndex - 1 < paramList.size()) {
                IParamDescriptionPO desc = (IParamDescriptionPO)paramList.get(columnIndex - 1);
                IParameterInterfacePO paramInterface = AbstractDataSetPage.this.getParamInterfaceObj();
                value = AbstractDataSetPage.getGuiStringForParamValue(paramInterface, desc, rowCount);
            }
            return value;
        }
    }

    private static enum TestDataRowAction {
        ADDED,
        INSERTED,
        DELETED,
        MOVED_UP,
        MOVED_DOWN;

    }
}

