/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.examples.extension.swing.test;

import java.util.Locale;
import org.eclipse.jubula.client.AUT;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.MakeR;
import org.eclipse.jubula.client.exceptions.CheckFailedException;
import org.eclipse.jubula.client.launch.AUTConfiguration;
import org.eclipse.jubula.examples.extension.swing.JSliderComponents;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.swing.SwingToolkit;
import org.eclipse.jubula.toolkit.swing.config.SwingAUTConfiguration;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JSliderTest {
    public static final String AGENT_HOST = "localhost";
    public static final int AGENT_PORT = 60000;
    private AUTAgent m_agent;
    private AUT m_aut;
    private JSliderComponents m_jsc;
    private static final ComponentIdentifier<?> jSliderIdentifier = MakeR.createCI((String)"rO0ABXNyAD1vcmcuZWNsaXBzZS5qdWJ1bGEudG9vbHMuaW50ZXJuYWwub2JqZWN0cy5Db21wb25lbnRJZGVudGlmaWVyAAAAAAAABAcCAAlaABRtX2VxdWFsT3JpZ2luYWxGb3VuZEQAEW1fbWF0Y2hQZXJjZW50YWdlSQAhbV9udW1iZXJPZk90aGVyTWF0Y2hpbmdDb21wb25lbnRzTAAYbV9hbHRlcm5hdGl2ZURpc3BsYXlOYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7TAAUbV9jb21wb25lbnRDbGFzc05hbWVxAH4AAUwAFW1fY29tcG9uZW50UHJvcGVydGllc3QAD0xqYXZhL3V0aWwvTWFwO0wAEG1faGllcmFyY2h5TmFtZXN0ABBMamF2YS91dGlsL0xpc3Q7TAAMbV9uZWlnaGJvdXJzcQB+AANMABRtX3N1cHBvcnRlZENsYXNzTmFtZXEAfgABeHAAv/AAAAAAAAD/////cHQAE2phdmF4LnN3aW5nLkpTbGlkZXJwc3IAE2phdmEudXRpbC5BcnJheUxpc3R4gdIdmcdhnQMAAUkABHNpemV4cAAAAAV3BAAAAAV0AAZmcmFtZTB0ABdqYXZheC5zd2luZy5KUm9vdFBhbmVfMXQAEG51bGwubGF5ZXJlZFBhbmV0ABBudWxsLmNvbnRlbnRQYW5ldAAVamF2YXguc3dpbmcuSlNsaWRlcl8xeHNxAH4ABgAAAAB3BAAAAAB4cQB+AAU=");

    @Before
    public void setUp() throws Exception {
        this.m_agent = MakeR.createAUTAgent((String)AGENT_HOST, (int)60000);
        this.m_agent.connect();
        SwingAUTConfiguration config = new SwingAUTConfiguration("api.aut.conf.swing.extension", "SwingExampleExtensionAUT", "..\\jre\\bin\\java.exe", "..\\examples\\", new String[]{"-jar", "development\\extension\\AUT\\JSlider.jar"}, Locale.getDefault());
        AUTIdentifier id = this.m_agent.startAUT((AUTConfiguration)config);
        if (id != null) {
            ToolkitInfo toolkitInformation = SwingToolkit.createToolkitInformation();
            this.m_jsc = new JSliderComponents(toolkitInformation);
            this.m_aut = this.m_agent.getAUT(id, this.m_jsc.getToolkitInfo());
            this.m_aut.connect();
        } else {
            Assert.fail((String)"AUT start has failed!");
        }
    }

    @Test
    public void testJSliderSpecificAction() throws Exception {
        this.m_aut.execute(this.m_jsc.verifyLabelExists(jSliderIdentifier, false), (Object)"Verify JSlider has no label");
    }

    @Test(expected=CheckFailedException.class)
    public void testExpectedCheckFailed() throws Exception {
        this.m_aut.execute(this.m_jsc.verifyLabelExists(jSliderIdentifier, true), (Object)"Expected failure for label existence verification");
    }

    @After
    public void tearDown() throws Exception {
        this.m_aut.disconnect();
        this.m_agent.stopAUT(this.m_aut.getIdentifier());
        this.m_agent.disconnect();
    }
}

