/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.listener;

import java.util.List;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.util.HighlightNode;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public abstract class AbstractFXAUTEventHandler
implements AUTEventListener,
ListChangeListener<Stage> {
    private Node m_currentNode;

    public void setCurrentNode(Node n) {
        this.m_currentNode = n;
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public void highlightCurrentNode() {
        if (this.m_currentNode != null) {
            EventThreadQueuerJavaFXImpl.invokeAndWait("cleanUp", new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    HighlightNode.drawHighlight(AbstractFXAUTEventHandler.this.m_currentNode);
                    return null;
                }
            });
        }
    }

    public void lowlightCurrentNode() {
        if (this.m_currentNode != null) {
            EventThreadQueuerJavaFXImpl.invokeAndWait("cleanUp", new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    HighlightNode.removeHighlight(AbstractFXAUTEventHandler.this.m_currentNode);
                    return null;
                }
            });
        }
    }

    public abstract void addHandler(Stage var1);

    public abstract void removeHandler(Stage var1);

    public void cleanUp() {
        this.lowlightCurrentNode();
    }

    public void update() {
    }

    public boolean highlightComponent(IComponentIdentifier comp) {
        Node n = ComponentHandler.findNodeByID(comp);
        if (n != null) {
            this.setCurrentNode(n);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractFXAUTEventHandler.this.highlightCurrentNode();
                }
            });
            return true;
        }
        return false;
    }

    public long[] getEventMask() {
        return null;
    }

    public void onChanged(ListChangeListener.Change<? extends Stage> change) {
        change.next();
        List changedStages = change.getAddedSubList();
        for (Stage stage : changedStages) {
            this.addHandler(stage);
        }
        changedStages = change.getRemoved();
        for (Stage stage : changedStages) {
            this.removeHandler(stage);
        }
    }
}

