/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.listener;

import java.util.Map;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.ObjectMappedMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.PropertyUtil;
import org.eclipse.jubula.rc.javafx.listener.AbstractFXAUTEventHandler;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.listener.KeyAcceptor;
import org.eclipse.jubula.rc.javafx.listener.MouseMoveDone;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class MappingListener
extends AbstractFXAUTEventHandler {
    private static AutServerLogger log = new AutServerLogger(MappingListener.class);
    private static final long THRESHOLD = 100L;
    private static final double DX = 0.0;
    private static final double DY = 0.0;
    private MouseMoveDone m_mHandler = new MouseMoveDone(100L, 0.0, 0.0);
    private HighlightHandler m_hHandler = new HighlightHandler();
    private InputMappingHandler m_iHandler = new InputMappingHandler();

    @Override
    public void addHandler(Stage s) {
        s.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)this.m_iHandler);
        s.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)this.m_mHandler);
        s.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this.m_iHandler);
        this.m_mHandler.addMoveDoneHandler(this.m_hHandler);
    }

    @Override
    public void removeHandler(Stage s) {
        s.removeEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)this.m_mHandler);
        s.removeEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)this.m_iHandler);
        s.removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this.m_iHandler);
        this.m_mHandler.removeMoveDoneHandler(this.m_hHandler);
    }

    private class HighlightHandler
    implements EventHandler<WorkerStateEvent> {
        private HighlightHandler() {
        }

        public void handle(WorkerStateEvent workerEvent) {
            Node newNode;
            MouseEvent event = (MouseEvent)workerEvent.getSource().getValue();
            Point2D pos = new Point2D(event.getScreenX(), event.getScreenY());
            Node currNode = MappingListener.this.getCurrentNode();
            if (currNode != (newNode = ComponentHandler.getComponentByPos(pos))) {
                if (currNode != null) {
                    MappingListener.this.lowlightCurrentNode();
                    MappingListener.this.setCurrentNode(null);
                }
                if (newNode != null) {
                    MappingListener.this.setCurrentNode(newNode);
                    MappingListener.this.highlightCurrentNode();
                }
            }
        }
    }

    private class InputMappingHandler
    implements EventHandler<InputEvent> {
        private InputMappingHandler() {
        }

        public void handle(InputEvent event) {
            boolean doMappingWithParents;
            Node currNode = MappingListener.this.getCurrentNode();
            int acceptCode = KeyAcceptor.accept(event);
            boolean doMapping = acceptCode == 1;
            boolean bl = doMappingWithParents = acceptCode == 4;
            if (currNode != null && (doMapping || doMappingWithParents)) {
                this.sendIdentifier(currNode);
                if (doMappingWithParents) {
                    Parent p = currNode.getParent();
                    while (p != null) {
                        if (ComponentHandler.isMappable((Node)p)) {
                            this.sendIdentifier((Node)p);
                        }
                        p = p.getParent();
                    }
                }
            }
        }

        private void sendIdentifier(Node node) {
            try {
                IComponentIdentifier id = ComponentHandler.getIdentifier(node);
                if (log.isInfoEnabled()) {
                    log.info((Object)("send a message with identifier for the component '" + id + "'"));
                }
                Map componentProperties = PropertyUtil.getMapOfComponentProperties((Object)node);
                id.setComponentPropertiesMap(componentProperties);
                ObjectMappedMessage message = new ObjectMappedMessage();
                message.setComponentIdentifier(id);
                AUTServer.getInstance().getCommunicator().send((Message)message);
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + node));
            }
            catch (CommunicationException ce) {
                log.error((Object)ce);
            }
        }
    }
}

