/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Picker component from the ios toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.concrete.ComboBox")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-12-16T10:14:38.085Z")
public class Picker extends org.eclipse.jubula.toolkit.concrete.internal.impl.ComboComponent implements org.eclipse.jubula.toolkit.ios.components.Picker {
            public Picker(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param direction 
         *        the direction
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP swipe(
            @NonNull Direction direction
        ) throws IllegalArgumentException {
            Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSwipe")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(direction.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkExistenceOfEntryByValueInColumn(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull Boolean exists,
            @NonNull Integer column
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyContainsValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(column)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkSelectionOfEntryByIndexInColumn(
            @NonNull String index,
            @NonNull Boolean selected,
            @NonNull Integer column
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(selected)
                        .addParameter(column)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByIndexInColumn(
            @NonNull String index,
            @NonNull Integer column
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(column)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByValueInColumn(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull SearchType searchType,
            @NonNull Integer column
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(column)
                        .build();
        }
        
} 