/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.gen.parser.parameter.lexer.LexerException;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.Parser;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.ParserException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.parser.parameter.JubulaParameterLexer;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.ParsedParameter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.core.utils.SemanticParsingException;
import org.eclipse.jubula.client.core.utils.TokenError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelParamValueConverter
extends ParamValueConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ModelParamValueConverter.class);

    public ModelParamValueConverter(String modelString, IParameterInterfacePO currentNode, IParamDescriptionPO desc) {
        super(currentNode, desc, new NullValidator());
        this.setModelString(modelString);
        this.createTokens();
    }

    @Override
    public String getGuiString() {
        if (super.getGuiString() == null) {
            StringBuilder builder = new StringBuilder();
            for (IParamValueToken token : this.getTokens()) {
                builder.append(token.getGuiString());
            }
            if (builder.length() > 0) {
                this.setGuiString(builder.toString());
            } else {
                return this.getModelString();
            }
        }
        return super.getGuiString();
    }

    @Override
    void createTokens() {
        Parser parser = new Parser(new JubulaParameterLexer(new PushbackReader(new StringReader(StringUtils.defaultString((String)this.getModelString())))));
        ParsedParameter parsedParam = new ParsedParameter(false, this.getCurrentNode(), this.getDesc());
        try {
            parser.parse().apply(parsedParam);
            this.setTokens(parsedParam.getTokens());
        }
        catch (LexerException e) {
            this.createErrors(e, this.getModelString());
        }
        catch (ParserException e) {
            this.createErrors(e, this.getModelString());
        }
        catch (IOException e) {
            LOG.error(Messages.ParameterParsingErrorOccurred, (Throwable)e);
            this.createErrors(e, this.getModelString());
        }
        catch (SemanticParsingException e) {
            this.createErrors(e, this.getModelString());
        }
    }

    @Override
    void validateSingleTokens() {
        for (IParamValueToken token : this.getTokens()) {
            ParamValueConverter.ConvValidationState state = token.validate();
            if (state != ParamValueConverter.ConvValidationState.invalid && state != ParamValueConverter.ConvValidationState.undecided) continue;
            TokenError tokenError = new TokenError(this.getModelString(), token.getErrorKey(), state);
            this.addError(tokenError);
        }
    }

    public boolean removeReference(String guid) {
        boolean isRefRemoved = false;
        ArrayList<IParamValueToken> tokensCopy = new ArrayList<IParamValueToken>(this.getAllTokens());
        for (IParamValueToken token : tokensCopy) {
            RefToken refToken;
            String refGuid;
            if (!(token instanceof RefToken) || !(refGuid = RefToken.extractCore((refToken = (RefToken)token).getModelString())).equals(guid)) continue;
            this.getTokens().remove(token);
            isRefRemoved = true;
        }
        if (isRefRemoved) {
            this.updateStrings();
        }
        return isRefRemoved;
    }

    public boolean replaceUuidsInReferences(Map<String, String> map) {
        boolean isModified = false;
        List<RefToken> refTokens = this.getRefTokens();
        for (RefToken refToken : refTokens) {
            String oldGuid = RefToken.extractCore(refToken.getModelString());
            if (!map.containsKey(oldGuid)) continue;
            String newGuid = map.get(oldGuid);
            refToken.setModelString(RefToken.replaceCore(newGuid, refToken.getModelString()));
            isModified = true;
        }
        if (isModified) {
            this.updateModelString();
        }
        return isModified;
    }

    private void updateModelString() {
        StringBuilder builder = new StringBuilder();
        String oldModelString = this.getModelString();
        for (IParamValueToken token : this.getTokens()) {
            builder.append(token.getModelString());
        }
        this.setModelString(builder.toString());
        for (IDataSetPO dataSet : this.getCurrentNode().getDataManager().getDataSets()) {
            int i = 0;
            while (i < dataSet.getColumnCount()) {
                String data = dataSet.getValueAt(i);
                if (data != null && data.equals(oldModelString)) {
                    dataSet.setValueAt(i, this.getModelString());
                    return;
                }
                ++i;
            }
        }
    }

    private void updateStrings() {
        this.updateModelString();
        this.setGuiString(null);
    }
}

