/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.swt.aut;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public abstract class RcpSwtComponentNamer
implements Listener {
    private static final String TOOLBAR_ID_SUFFIX = ".toolbar";
    private static final String TEST_RCP_DATA_KEY = "TEST_RCP_COMP_NAME";
    private static Map componentNAMES = new HashMap();
    private static boolean generateNames = false;

    static {
        generateNames = Boolean.valueOf(EnvironmentUtils.getProcessEnvironment().getProperty("TEST_GENERATE_NAMES_PROPERTY"));
        RcpSwtComponentNamer.addCompName(7, "abort");
        RcpSwtComponentNamer.addCompName(14, "back");
        RcpSwtComponentNamer.addCompName(1, "cancel");
        RcpSwtComponentNamer.addCompName(1024, "client");
        RcpSwtComponentNamer.addCompName(12, "close");
        RcpSwtComponentNamer.addCompName(19, "deselectAll");
        RcpSwtComponentNamer.addCompName(13, "details");
        RcpSwtComponentNamer.addCompName(16, "finish");
        RcpSwtComponentNamer.addCompName(17, "help");
        RcpSwtComponentNamer.addCompName(9, "ignore");
        RcpSwtComponentNamer.addCompName(256, "internal");
        RcpSwtComponentNamer.addCompName(15, "next");
        RcpSwtComponentNamer.addCompName(3, "no");
        RcpSwtComponentNamer.addCompName(21, "noToAll");
        RcpSwtComponentNamer.addCompName(0, "ok");
        RcpSwtComponentNamer.addCompName(11, "open");
        RcpSwtComponentNamer.addCompName(10, "proceed");
        RcpSwtComponentNamer.addCompName(8, "retry");
        RcpSwtComponentNamer.addCompName(18, "selectAll");
        RcpSwtComponentNamer.addCompName(20, "selectTypes");
        RcpSwtComponentNamer.addCompName(5, "skip");
        RcpSwtComponentNamer.addCompName(6, "stop");
        RcpSwtComponentNamer.addCompName(2, "yes");
        RcpSwtComponentNamer.addCompName(4, "yesToAll");
    }

    private static void addCompName(int compID, String compName) {
        String staticNamePreafix = "dialog.button.";
        componentNAMES.put(new Integer(compID), String.valueOf(staticNamePreafix) + compName);
    }

    public void handleEvent(Event event) {
        ToolItem[] items;
        this.addNameData(event.widget);
        if (event.widget instanceof ToolBar) {
            items = ((ToolBar)event.widget).getItems();
        } else if (event.widget instanceof CoolBar) {
            items = ((CoolBar)event.widget).getItems();
        } else {
            return;
        }
        int i = 0;
        while (i < items.length) {
            this.addNameData((Widget)items[i]);
            ++i;
        }
    }

    private void addNameData(Widget widget) {
        if (RcpSwtComponentNamer.hasWidgetToBeNamed(widget)) {
            Object data = RcpSwtComponentNamer.getWidgetData(widget);
            if (data instanceof IContributionItem) {
                String actionId = ((IContributionItem)data).getId();
                if (actionId != null && actionId.trim().length() > 0) {
                    RcpSwtComponentNamer.setComponentName(widget, actionId);
                    ComponentHandler.getAutHierarchy().refreshComponentName(widget);
                }
            } else if (data instanceof PreferenceDialog) {
                PreferenceDialog prefDialog = (PreferenceDialog)data;
                prefDialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        RcpSwtComponentNamer.this.addNameDataToPrefPage(event.getSelectedPage());
                    }
                });
                this.addNameDataToPrefPage(prefDialog.getSelectedPage());
            }
            if (generateNames && data instanceof Dialog) {
                Dialog dialog = (Dialog)data;
                this.setNameForDialogButtonBarButtons(dialog);
            }
        }
    }

    private static Object getWidgetData(Widget widget) {
        Composite toolbarParent;
        Object data = widget.getData();
        if (widget instanceof ToolBar && (toolbarParent = ((ToolBar)widget).getParent()) instanceof CoolBar) {
            CoolItem[] coolItems = ((CoolBar)toolbarParent).getItems();
            int i = 0;
            while (i < coolItems.length) {
                CoolItem item = coolItems[i];
                if (item != null && item.getControl() == widget) {
                    data = item.getData();
                }
                ++i;
            }
        }
        return data;
    }

    private void setNameForDialogButtonBarButtons(Dialog dialog) {
        try {
            Method getButtonMethod = Dialog.class.getDeclaredMethod("getButton", Integer.TYPE);
            getButtonMethod.setAccessible(true);
            for (Integer componentID : componentNAMES.keySet()) {
                RcpSwtComponentNamer.invokeNameSetting(dialog, getButtonMethod, componentID, componentNAMES.get(componentID));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    private static void invokeNameSetting(Object useObject, Method methodToInvoke, Integer buttonID, Object buttonName) {
        Button button;
        Object ret = null;
        try {
            ret = methodToInvoke.invoke(useObject, buttonID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (ret instanceof Button && RcpSwtComponentNamer.hasWidgetToBeNamed((Widget)(button = (Button)ret))) {
            RcpSwtComponentNamer.setComponentName((Widget)button, buttonName.toString());
        }
    }

    private void addNameDataToPrefPage(Object selectedPage) {
        if (selectedPage == null) {
            return;
        }
        PreferenceManager prefMan = this.getPreferenceManager();
        if (prefMan == null) {
            return;
        }
        for (IPreferenceNode prefNode : prefMan.getElements(0)) {
            if (!selectedPage.equals(prefNode.getPage())) continue;
            Control pageControl = prefNode.getPage().getControl();
            String prefNodeId = prefNode.getId();
            if (!RcpSwtComponentNamer.hasWidgetToBeNamed((Widget)pageControl) || prefNodeId == null || prefNodeId.trim().length() <= 0) break;
            RcpSwtComponentNamer.setComponentName((Widget)pageControl, prefNodeId);
            Shell prefShell = pageControl.getDisplay().getActiveShell();
            Event activateEvent = new Event();
            activateEvent.time = (int)System.currentTimeMillis();
            activateEvent.type = 26;
            activateEvent.widget = prefShell;
            prefShell.notifyListeners(26, activateEvent);
            break;
        }
    }

    public static boolean hasWidgetToBeNamed(Widget widget) {
        boolean hasToBeNamed = widget != null && !widget.isDisposed() && widget.getData(TEST_RCP_DATA_KEY) == null;
        return hasToBeNamed;
    }

    public static void setComponentName(Widget widget, String id) {
        widget.setData(TEST_RCP_DATA_KEY, (Object)id);
    }

    public static void setToolbarComponentName(Widget partToolbar, String finalPartId) {
        RcpSwtComponentNamer.setComponentName(partToolbar, String.valueOf(finalPartId) + TOOLBAR_ID_SUFFIX);
    }

    protected abstract PreferenceManager getPreferenceManager();
}

