/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ParamNodePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@DiscriminatorValue(value="C")
class CapPO
extends ParamNodePO
implements ICapPO,
PersistenceWeaved,
PersistenceObject {
    private String m_componentNameGuid;
    private String m_componentType;
    private String m_hbmActionName;
    private transient CompSystem m_compSystem = null;
    private transient Component m_metaComponentType = null;
    private transient Action m_metaAction = null;
    static final long serialVersionUID = -2351464651317200360L;

    CapPO() {
    }

    CapPO(String capName, String componentNameGuid, String componentType, String actionName, boolean isGenerated) {
        super(capName, isGenerated);
        this.validateCAP(capName, componentNameGuid, componentType, actionName);
        this.init(componentNameGuid, componentType, actionName);
    }

    CapPO(String capName, String componentNameGuid, String componentType, String actionName, IProjectPO project, boolean isGenerated) {
        this(capName, componentNameGuid, componentType, actionName, isGenerated);
        this.createDefaultValues(project);
        this.setParentProjectId(project.getId());
    }

    CapPO(String capName, String componentNameGuid, String componentType, String actionName, String guid, boolean isGenerated) {
        super(capName, guid, isGenerated);
        this.validateCAP(capName, componentNameGuid, componentType, actionName);
        this.init(componentNameGuid, componentType, actionName);
    }

    CapPO(String capName, String componentNameGuid, String componentType, String actionName, IProjectPO project, String guid, boolean isGenerated) {
        this(capName, componentNameGuid, componentType, actionName, guid, isGenerated);
        this.createDefaultValues(project);
        this.setParentProjectId(project.getId());
    }

    private void init(String componentNameGuid, String componentType, String actionName) {
        this.setComponentName(componentNameGuid);
        this.setComponentType(componentType);
        this.setActionName(actionName);
    }

    private void validateCAP(String capName, String componentName, String componentType, String actionName) {
        Validate.notEmpty((String)capName, (String)Messages.MissingNameForCapPO);
        CompSystem compsys = ComponentBuilder.getInstance().getCompSystem();
        Component comp = compsys.findComponent(componentType);
        boolean hasDefaultMapping = false;
        if (comp.isConcrete()) {
            ConcreteComponent cc = (ConcreteComponent)comp;
            hasDefaultMapping = cc.hasDefaultMapping();
        }
        if (!hasDefaultMapping) {
            Validate.notEmpty((String)componentName, (String)Messages.MissingComponentNameForComponent);
        }
        Validate.notEmpty((String)componentType, (String)Messages.MissingComponentNameForComponent);
        Validate.notEmpty((String)actionName, (String)(String.valueOf(Messages.MissingComponentNameForComponent) + componentName));
        this.getMetaDataFromXmlDescr(componentType, actionName);
    }

    private void getMetaDataFromXmlDescr(String componentType, String actionName) {
        this.m_compSystem = ComponentBuilder.getInstance().getCompSystem();
        this.m_metaComponentType = this.m_compSystem.findComponent(componentType);
        this.m_metaAction = this.m_metaComponentType.findAction(actionName);
    }

    @Override
    @Basic
    @Column(name="COMP_NAME")
    public String getComponentName() {
        return this.m_componentNameGuid;
    }

    @Override
    public void setComponentName(String name) {
        this.m_componentNameGuid = name;
    }

    @Override
    @Basic
    @Column(name="COMP_TYPE", length=4000)
    public String getComponentType() {
        return this.m_componentType;
    }

    @Override
    public void setComponentType(String type) {
        Validate.notEmpty((String)type);
        this.m_componentType = type;
        this.setMetaComponentType(null);
        this.getMetaComponentType();
    }

    @Override
    @Transient
    public Action getMetaAction() {
        if (this.m_metaAction == null) {
            this.m_metaAction = this.getMetaComponentType().findAction(this.getHbmActionName());
        }
        return this.m_metaAction;
    }

    @Override
    @Transient
    public boolean isValid() {
        this.getMetaComponentType();
        return this.m_metaComponentType.isValid();
    }

    private void setMetaAction(Action metaAction) {
        this.m_metaAction = metaAction;
    }

    @Override
    @Transient
    public Component getMetaComponentType() {
        if (this.m_metaComponentType == null) {
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            this.m_metaComponentType = compSystem.findComponent(this.getComponentType());
            Validate.notNull((Object)this.getComponentType(), (String)Messages.ComponentTypeIsNull);
        }
        return this.m_metaComponentType;
    }

    @Basic
    @Column(name="COMP_ACTION", length=4000)
    private String getHbmActionName() {
        return this.m_hbmActionName;
    }

    private void setHbmActionName(String hbmActionName) {
        this.m_hbmActionName = hbmActionName;
    }

    @Override
    @Transient
    public String getActionName() {
        return this.getHbmActionName();
    }

    @Override
    public void setActionName(String actionName) {
        Validate.notEmpty((String)actionName, (String)(String.valueOf(Messages.MissingActionForComponent) + this.getComponentName()));
        this.setHbmActionName(actionName);
        this.setMetaAction(null);
        this.getMetaAction();
        this.initParameterList();
    }

    @Override
    public void addNode(INodePO childNode) {
        childNode.getName();
        Assert.verify((boolean)false, (String)Messages.NotAllowedToAddNodeToCapPO);
    }

    private void initParameterList() {
        this.clearParameterList();
        List paramList = this.getMetaAction().getParams();
        for (Param par : paramList) {
            IParamDescriptionPO desc = PoMaker.createCapParamDescriptionPO(par.getType(), par.getName());
            this.addParameter(desc);
        }
    }

    private void createDefaultValues(IProjectPO project) {
        Action action = CapBP.getAction(this);
        String[] stringArray = action.getParamNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            Param parameter = action.findParam(paramName);
            this.getDataManager().updateCell(parameter.getDefaultValue(), 0, paramName);
            ++n2;
        }
    }

    @Override
    protected void removeParameter(IParamDescriptionPO p) {
        Assert.verify((boolean)false, (String)Messages.ItsNotAllowedToRemoveParametersFromCapPO);
    }

    private void setMetaComponentType(Component metaComponentType) {
        this.m_metaComponentType = metaComponentType;
    }

    @Override
    public void changeCompName(String oldCompNameGuid, String newCompNameGuid) {
        this.setComponentName(newCompNameGuid);
    }

    @Override
    public String getComponentType(IWritableComponentNameCache compNameCache, Collection<Component> availableComponents) {
        return this.getComponentType();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CapPO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "componentType") {
            return this.componentType;
        }
        if (string == "hbmActionName") {
            return this.hbmActionName;
        }
        if (string == "componentName") {
            return this.componentName;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "componentType") {
            this.componentType = (String)object;
            return;
        }
        if (string == "hbmActionName") {
            this.hbmActionName = (String)object;
            return;
        }
        if (string == "componentName") {
            this.componentName = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

