/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.constants.InputCodeHelper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.preferences.utils.InputComboUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ObjectMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 4;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private Button m_showContainerCount = null;
    private Combo m_mappingModifier = null;
    private Combo m_mappingWithParentsModifier = null;
    private DirectCombo<InputCodeHelper.UserInput> m_mappingKey = null;
    private DirectCombo<InputCodeHelper.UserInput> m_mappingWithParentsKey = null;

    public ObjectMappingPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        final Composite composite = new Composite((Composite)scrollComposite, 0);
        this.compositeGridData(composite, 1);
        this.createShowContainerCount(composite);
        this.createShortCutsArea(composite);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageObjectMapContextId");
        this.initPreferences();
        scrollComposite.setContent((Control)composite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setMinSize(composite.computeSize(-1, -1));
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrollComposite.setMinSize(composite.computeSize(-1, -1));
            }
        });
        return scrollComposite;
    }

    private void compositeGridData(Composite composite, int numberOfColumns) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numberOfColumns;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)compositeData);
    }

    private void createShowContainerCount(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite, 4);
        this.m_showContainerCount = new Button(composite, 32);
        this.m_showContainerCount.setText(Messages.ObjectMappingPreferencePageShowContainerCount);
        GridData data2 = new GridData();
        data2.horizontalSpan = 4;
        this.m_showContainerCount.setLayoutData((Object)data2);
    }

    private void createShortCutsArea(Composite parent) {
        InputCodeHelper keys = InputCodeHelper.getInstance();
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite, 4);
        Label label = new Label(composite, 0);
        label.setText(Messages.ObjectMappingPreferencePageCollectShortcut);
        label.setFont(LayoutUtil.BOLD_TAHOMA);
        GridData data2 = new GridData();
        data2.horizontalSpan = 4;
        label.setLayoutData((Object)data2);
        label = new Label(composite, 0);
        this.m_mappingModifier = new Combo(composite, 12);
        this.m_mappingModifier.setItems(keys.getModifierString());
        label = new Label(composite, 0);
        label.setText(" + ");
        this.m_mappingKey = InputComboUtil.createInputCombo(composite, 12);
        label = new Label(composite, 0);
        label.setText(Messages.ObjectMappingPreferencePageCollectWithParentsShortcut);
        label.setFont(LayoutUtil.BOLD_TAHOMA);
        label.setLayoutData((Object)data2);
        label = new Label(composite, 0);
        this.m_mappingWithParentsModifier = new Combo(composite, 12);
        this.m_mappingWithParentsModifier.setItems(keys.getModifierString());
        label = new Label(composite, 0);
        label.setText(" + ");
        this.m_mappingWithParentsKey = InputComboUtil.createInputCombo(composite, 12);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.ObjectMappingPreferencePageDescription);
    }

    protected void performDefaults() {
        this.m_showContainerCount.setSelection(this.getDefaultPrefsBool("SHOWCHILDCOUNT_PREF_KEY"));
        this.m_mappingModifier.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getDefaultPrefsInt("MAPPINGMOD1_PREF_KEY")));
        this.m_mappingWithParentsModifier.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getDefaultPrefsInt("MAPPING_WITH_PARENTS_MOD1_PREF_KEY")));
        InputComboUtil.setSelectedInput(this.m_mappingKey, this.getDefaultPrefsInt("MAPPINGMOD2_PREF_KEY"), this.getDefaultPrefsInt("MAPPINGMOD2_TYPE_PREF_KEY"));
        InputComboUtil.setSelectedInput(this.m_mappingWithParentsKey, this.getDefaultPrefsInt("MAPPING_WITH_PARENTS_MOD2_PREF_KEY"), this.getDefaultPrefsInt("MAPPING_WITH_PARENTS_MOD2_TYPE_PREF_KEY"));
    }

    protected void initPreferences() {
        this.m_showContainerCount.setSelection(this.getPreferenceStore().getBoolean("SHOWCHILDCOUNT_PREF_KEY"));
        this.m_mappingModifier.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getPreferenceStore().getInt("MAPPINGMOD1_PREF_KEY")));
        this.m_mappingWithParentsModifier.select(InputCodeHelper.getInstance().getIndexOfModifier(this.getPreferenceStore().getInt("MAPPING_WITH_PARENTS_MOD1_PREF_KEY")));
        InputComboUtil.setSelectedInput(this.m_mappingKey, this.getPreferenceStore().getInt("MAPPINGMOD2_PREF_KEY"), this.getPreferenceStore().getInt("MAPPINGMOD2_TYPE_PREF_KEY"));
        InputComboUtil.setSelectedInput(this.m_mappingWithParentsKey, this.getPreferenceStore().getInt("MAPPING_WITH_PARENTS_MOD2_PREF_KEY"), this.getPreferenceStore().getInt("MAPPING_WITH_PARENTS_MOD2_TYPE_PREF_KEY"));
    }

    private boolean getDefaultPrefsBool(String key) {
        return this.getPreferenceStore().getDefaultBoolean(key);
    }

    private int getDefaultPrefsInt(String key) {
        return this.getPreferenceStore().getDefaultInt(key);
    }

    public boolean performOk() {
        boolean showCount = this.m_showContainerCount.getSelection();
        this.getPreferenceStore().setValue("SHOWCHILDCOUNT_PREF_KEY", showCount);
        this.getPreferenceStore().setValue("MAPPINGMOD1_PREF_KEY", InputCodeHelper.getInstance().getModifier()[this.m_mappingModifier.getSelectionIndex()]);
        this.getPreferenceStore().setValue("MAPPING_WITH_PARENTS_MOD1_PREF_KEY", InputCodeHelper.getInstance().getModifier()[this.m_mappingWithParentsModifier.getSelectionIndex()]);
        InputComboUtil.setPrefCode(this.m_mappingKey, this.getPreferenceStore(), "MAPPINGMOD2_PREF_KEY");
        InputComboUtil.setPrefType(this.m_mappingKey, this.getPreferenceStore(), "MAPPINGMOD2_TYPE_PREF_KEY");
        InputComboUtil.setPrefCode(this.m_mappingWithParentsKey, this.getPreferenceStore(), "MAPPING_WITH_PARENTS_MOD2_PREF_KEY");
        InputComboUtil.setPrefType(this.m_mappingWithParentsKey, this.getPreferenceStore(), "MAPPING_WITH_PARENTS_MOD2_TYPE_PREF_KEY");
        return super.performOk();
    }
}

