/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.widgets.I18nEnumCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.toolkit.html.Browser;
import org.eclipse.jubula.toolkit.html.BrowserSize;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class HtmlAutConfigComponent
extends AutConfigComponent {
    private Text m_autUrlTextField;
    private Text m_browserTextField;
    private Text m_autIdAttibuteTextField;
    private Button m_browserPathButton;
    private Button m_singleWindowCheckBox;
    private Button m_webdriverCheckBox;
    private I18nEnumCombo<Browser> m_browserCombo;
    private I18nEnumCombo<IAUTConfigPO.ActivationMethod> m_activationMethodCombo;
    private I18nEnumCombo<BrowserSize> m_browserSizeCombo;
    private WidgetModifyListener m_modifyListener;
    private WidgetSelectionListener m_selectionListener;

    public HtmlAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName, true);
    }

    @Override
    protected void createBasicArea(Composite basicAreaComposite) {
        super.createBasicArea(basicAreaComposite);
        Label urlLabel = UIComponentHelper.createLabel((Composite)basicAreaComposite, (String)"WebAutConfigComponent.URL");
        urlLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.urlLabel");
        this.m_autUrlTextField = UIComponentHelper.createTextField((Composite)basicAreaComposite, (int)2);
        this.m_autUrlTextField.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.autUrlTextField");
        Label browserLabel = UIComponentHelper.createLabel((Composite)basicAreaComposite, (String)"WebAutConfigComponent.browser");
        browserLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.browserLabel");
        this.m_browserCombo = UIComponentHelper.createEnumCombo((Composite)basicAreaComposite, (int)2, (String)"WebAutConfigComponent.Browser", Browser.class);
        this.m_browserCombo.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.browserCombo");
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
        super.createAdvancedArea(advancedAreaComposite);
        this.createBrowserPathEditor(advancedAreaComposite);
        this.createWebdriverCheckBox(advancedAreaComposite);
        this.createSingleModeCheckBox(advancedAreaComposite);
        Label browserSizeLabel = UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)"WebAutConfigComponent.BrowserSize");
        browserSizeLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.browserSizeLabel");
        this.m_browserSizeCombo = UIComponentHelper.createEnumCombo((Composite)advancedAreaComposite, (int)2, (String)"WebAutConfigComponent.BrowserSize", BrowserSize.class);
        this.m_browserSizeCombo.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.browserSizeCombo");
    }

    @Override
    protected void createExpertArea(Composite expertAreaComposite) {
        super.createExpertArea(expertAreaComposite);
        Label activationMethodLabel = UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.activationMethod");
        activationMethodLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.activationMethodLabel");
        this.m_activationMethodCombo = UIComponentHelper.createEnumCombo((Composite)expertAreaComposite, (int)2, (String)"AUTConfigComponent.ActivationMethod", IAUTConfigPO.ActivationMethod.class);
        this.m_activationMethodCombo.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.activationMethodCombo");
        Label autIdAttibuteLabel = UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"HTMLAutConfigComponent.AutIdAttibuteLabel");
        autIdAttibuteLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.autIdAttibuteLabel");
        this.m_autIdAttibuteTextField = UIComponentHelper.createTextField((Composite)expertAreaComposite, (int)2);
        this.m_autIdAttibuteTextField.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.autIdAttibuteTextField");
    }

    protected void createBrowserPathEditor(Composite parent) {
        Label browserPathLabel = UIComponentHelper.createLabel((Composite)parent, (String)"WebAutConfigComponent.browserPath");
        browserPathLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.browserPathLabel");
        ControlDecorator.decorateInfo((Control)browserPathLabel, "ControlDecorator.WebBrowserPath", false);
        this.m_browserTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        this.m_browserTextField.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.BrowserTextField");
        this.m_browserPathButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_browserPathButton.setText(I18n.getString((String)"AUTConfigComponent.browse"));
        this.m_browserPathButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_browserPathButton.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.browserPathButton");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.getAUTAgentHostNameCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_autUrlTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autIdAttibuteTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_browserTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_browserPathButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_browserCombo.addSelectionListener((SelectionListener)selectionListener);
        this.m_activationMethodCombo.addSelectionListener((SelectionListener)selectionListener);
        this.m_singleWindowCheckBox.addSelectionListener((SelectionListener)selectionListener);
        this.m_webdriverCheckBox.addSelectionListener((SelectionListener)selectionListener);
        this.m_browserSizeCombo.addSelectionListener((SelectionListener)selectionListener);
    }

    @Override
    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.getAUTAgentHostNameCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_autUrlTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autIdAttibuteTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_browserTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_browserPathButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_browserCombo.removeSelectionListener((SelectionListener)selectionListener);
        this.m_activationMethodCombo.removeSelectionListener((SelectionListener)selectionListener);
        this.m_singleWindowCheckBox.removeSelectionListener((SelectionListener)selectionListener);
        this.m_webdriverCheckBox.removeSelectionListener((SelectionListener)selectionListener);
        this.m_browserSizeCombo.removeSelectionListener((SelectionListener)selectionListener);
    }

    private void handleWebdriverDependentEnablement() {
        if (this.m_webdriverCheckBox.getSelection()) {
            this.m_browserSizeCombo.setEnabled(true);
            this.m_singleWindowCheckBox.setEnabled(false);
        } else {
            this.m_browserSizeCombo.setEnabled(false);
            this.m_singleWindowCheckBox.setEnabled(true);
        }
    }

    @Override
    protected boolean checkLocalhostServer() {
        boolean enable = super.checkLocalhostServer();
        boolean browseEnabled = enable || this.isRemoteRequest();
        this.m_browserPathButton.setEnabled(browseEnabled && this.m_browserTextField.getEnabled());
        return enable;
    }

    protected boolean internetExplorerSelected() {
        boolean enable = super.checkLocalhostServer();
        boolean browseEnabled = enable || this.isRemoteRequest();
        boolean isIE = ((Browser)this.m_browserCombo.getSelectedObject()).equals((Object)Browser.InternetExplorer);
        this.m_browserPathButton.setEnabled(browseEnabled);
        return isIE;
    }

    @Override
    protected void initState() {
        this.m_activationMethodCombo.setEnabled(true);
        this.m_activationMethodCombo.setEnabled(true);
        this.m_autUrlTextField.setEnabled(true);
        this.m_autIdAttibuteTextField.setEnabled(true);
        this.m_browserCombo.setEnabled(true);
        this.m_browserPathButton.setEnabled(true);
        this.m_browserTextField.setEnabled(true);
        this.handleWebdriverDependentEnablement();
        this.checkLocalhostServer();
        this.internetExplorerSelected();
        RemoteFileBrowserBP.clearCache();
    }

    boolean handleActivationComboEvent() {
        this.putConfigValue("ACTIVATION_METHOD", IAUTConfigPO.ActivationMethod.getRCString((IAUTConfigPO.ActivationMethod)((IAUTConfigPO.ActivationMethod)this.m_activationMethodCombo.getSelectedObject())));
        return true;
    }

    DialogStatusParameter modifyUrlTextField() {
        DialogStatusParameter error = null;
        String urlText = this.m_autUrlTextField.getText();
        if (this.m_autUrlTextField.getText().length() == 0) {
            error = this.createErrorStatus(I18n.getString((String)"WebAutConfigComponent.emptyUrl"));
        } else {
            try {
                new URL(urlText);
            }
            catch (MalformedURLException malformedURLException) {
                error = this.createErrorStatus(I18n.getString((String)"WebAutConfigComponent.wrongUrl"));
            }
        }
        this.putConfigValue("AUT_ARGUMENTS", urlText);
        return error;
    }

    DialogStatusParameter modifyIDAttributeTextField() {
        DialogStatusParameter error = null;
        String idText = this.m_autIdAttibuteTextField.getText();
        if (!idText.matches("[a-zA-Z]*")) {
            error = this.createErrorStatus(I18n.getString((String)"HTMLAutConfigComponent.wrongAutIdAttribute"));
        } else {
            this.putConfigValue("WEB_ID_TAG", idText);
        }
        return error;
    }

    DialogStatusParameter modifyBrowserPathTextField() {
        DialogStatusParameter error = null;
        String txt = this.m_browserTextField.getText();
        this.putConfigValue("BROWSER_PATH", txt);
        return error;
    }

    DialogStatusParameter modifyBrowser() {
        Browser browser = (Browser)this.m_browserCombo.getSelectedObject();
        if (browser != null) {
            this.putConfigValue("BROWSER", browser.toString());
        }
        return null;
    }

    DialogStatusParameter modifyBrowserSize() {
        BrowserSize browserSize = (BrowserSize)this.m_browserSizeCombo.getSelectedObject();
        if (browserSize == null || BrowserSize.FULLSCREEN == browserSize) {
            this.putConfigValue("BROWSER_SIZE", BrowserSize.FULLSCREEN.toString());
        } else {
            this.putConfigValue("BROWSER_SIZE", browserSize.toString());
        }
        return null;
    }

    @Override
    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        String browser = data.get("BROWSER");
        if (browser == null) {
            browser = Browser.InternetExplorer.toString();
        }
        this.m_browserCombo.setSelectedObject((Object)Browser.valueOf((String)browser));
        if (!this.isDataNew(data)) {
            this.m_autUrlTextField.setText(StringUtils.defaultString((String)data.get("AUT_ARGUMENTS")));
        }
    }

    @Override
    protected void populateAdvancedArea(Map<String, String> data) {
        if (!this.isDataNew(data)) {
            this.m_browserTextField.setText(StringUtils.defaultString((String)data.get("BROWSER_PATH")));
            String browserSize = data.get("BROWSER_SIZE");
            if (StringUtils.isEmpty((String)browserSize)) {
                this.m_browserSizeCombo.setSelectedObject((Object)BrowserSize.FULLSCREEN);
            } else {
                this.m_browserSizeCombo.setSelectedObject((Object)BrowserSize.valueOf((String)browserSize));
            }
            String selection = data.get("SINGLE_WINDOW_MODE");
            boolean selected = false;
            selected = StringUtils.isEmpty((String)selection) ? true : Boolean.parseBoolean(selection);
            this.m_singleWindowCheckBox.setSelection(selected);
            String webdriverSelection = data.get("WEBDRIVER_MODE");
            boolean webdriverSelected = false;
            webdriverSelected = StringUtils.isEmpty((String)webdriverSelection) ? false : Boolean.parseBoolean(webdriverSelection);
            this.m_webdriverCheckBox.setSelection(webdriverSelected);
        } else {
            this.m_singleWindowCheckBox.setSelection(true);
        }
    }

    @Override
    protected void populateExpertArea(Map<String, String> data) {
        this.m_activationMethodCombo.setSelectedObject((Object)IAUTConfigPO.ActivationMethod.getEnum((String)data.get("ACTIVATION_METHOD")));
        if (!this.isDataNew(data)) {
            String webIdTag = data.get("WEB_ID_TAG");
            if (webIdTag == null) {
                webIdTag = "";
            }
            this.m_autIdAttibuteTextField.setText(webIdTag);
        }
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    private WidgetSelectionListener getSelectionListener() {
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new WidgetSelectionListener();
        }
        return this.m_selectionListener;
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyUrlTextField());
        this.addError(paramList, this.modifyIDAttributeTextField());
        this.addError(paramList, this.modifyBrowser());
        this.addError(paramList, this.modifyBrowserPathTextField());
        this.addError(paramList, this.modifySingleWindowCheckBox());
        this.addError(paramList, this.modifyWebdriverCheckBox());
        this.addError(paramList, this.modifyBrowserSize());
        this.handleActivationComboEvent();
    }

    DialogStatusParameter modifySingleWindowCheckBox() {
        DialogStatusParameter error = null;
        Boolean checked = this.m_singleWindowCheckBox.getSelection();
        this.putConfigValue("SINGLE_WINDOW_MODE", checked.toString());
        return error;
    }

    DialogStatusParameter modifyWebdriverCheckBox() {
        DialogStatusParameter error = null;
        Boolean checked = this.m_webdriverCheckBox.getSelection();
        this.putConfigValue("WEBDRIVER_MODE", checked.toString());
        return error;
    }

    protected void createSingleModeCheckBox(Composite parent) {
        Label singleWindowModeLabel = UIComponentHelper.createLabel((Composite)parent, (String)"WebAutConfigComponent.singleWindowMode");
        singleWindowModeLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.singleWindowModeLabel");
        ControlDecorator.decorateInfo((Control)singleWindowModeLabel, "ControlDecorator.SingleWindowMode", false);
        this.m_singleWindowCheckBox = UIComponentHelper.createToggleButton((Composite)parent, (int)2);
        this.m_singleWindowCheckBox.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.SingleWindowCheckBox");
    }

    protected void createWebdriverCheckBox(Composite parent) {
        Label useWebdriverLabel = UIComponentHelper.createLabel((Composite)parent, (String)"WebAutConfigComponent.webdriverMode");
        useWebdriverLabel.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.WebdriverLabel");
        ControlDecorator.decorateInfo((Control)useWebdriverLabel, "ControlDecorator.WebdriverMode", false);
        this.m_webdriverCheckBox = UIComponentHelper.createToggleButton((Composite)parent, (int)2);
        this.m_webdriverCheckBox.setData("TEST_COMP_NAME", (Object)"org.eclipse.jubula.toolkit.provider.html.gui.HtmlAutConfigComponent.WebdriverCheckBox");
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            boolean checked = false;
            if (source.equals(HtmlAutConfigComponent.this.m_autUrlTextField)) {
                checked = true;
            } else if (source.equals(HtmlAutConfigComponent.this.m_browserTextField)) {
                checked = true;
            } else if (source.equals(HtmlAutConfigComponent.this.m_autIdAttibuteTextField)) {
                checked = true;
            } else if (source.equals(HtmlAutConfigComponent.this.getAUTAgentHostNameCombo())) {
                HtmlAutConfigComponent.this.checkLocalhostServer();
                checked = true;
            } else if (source.equals(HtmlAutConfigComponent.this.m_browserCombo)) {
                HtmlAutConfigComponent.this.internetExplorerSelected();
                checked = true;
            }
            if (checked) {
                HtmlAutConfigComponent.this.checkAll();
                return;
            }
            Assert.notReached((String)"Event activated by unknown widget.");
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            boolean checked = false;
            if (source.equals(HtmlAutConfigComponent.this.m_activationMethodCombo)) {
                checked = true;
            } else if (source.equals(HtmlAutConfigComponent.this.m_browserSizeCombo)) {
                checked = true;
            } else if (source.equals(HtmlAutConfigComponent.this.m_browserCombo)) {
                HtmlAutConfigComponent.this.internetExplorerSelected();
                checked = true;
            } else {
                if (source.equals(HtmlAutConfigComponent.this.m_browserPathButton)) {
                    if (HtmlAutConfigComponent.this.isRemoteRequest()) {
                        HtmlAutConfigComponent.this.remoteBrowse(false, "BROWSER_PATH", HtmlAutConfigComponent.this.m_browserTextField, I18n.getString((String)"WebAutConfigComponent.SelectBrowserPath"));
                    } else {
                        FileDialog fileDialog = new FileDialog(HtmlAutConfigComponent.this.getShell(), 81920);
                        fileDialog.setText(I18n.getString((String)"WebAutConfigComponent.SelectBrowserPath"));
                        String browserFile = fileDialog.open();
                        if (browserFile != null) {
                            HtmlAutConfigComponent.this.m_browserTextField.setText(browserFile);
                        }
                    }
                    return;
                }
                if (source.equals(HtmlAutConfigComponent.this.m_singleWindowCheckBox)) {
                    checked = true;
                } else if (source.equals(HtmlAutConfigComponent.this.m_webdriverCheckBox)) {
                    HtmlAutConfigComponent.this.handleWebdriverDependentEnablement();
                    checked = true;
                }
            }
            if (checked) {
                HtmlAutConfigComponent.this.checkAll();
                return;
            }
            Assert.notReached((String)("Event activated by unknown widget(" + source + ")."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

