/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the GraphicsComponentActionHandler component from the base toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-03-23T08:31:56.617Z")
@Beta
public interface GraphicsComponentActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param textSizeInPoints 
         *        the text size (in points)
         * @param timePerWordInMilliseconds 
         *        the time to wait per word (in milliseconds)
         * @param windowWidthInPixels 
         *        the window width in pixels
         * 
         */
        public void showText(
            @Nullable String text,
            @Nullable Integer textSizeInPoints,
            @Nullable Integer timePerWordInMilliseconds,
            @Nullable Integer windowWidthInPixels
        ) ;
        
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * 
         */
        public void checkExistence(
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * 
         */
        public void checkEnablement(
            @Nullable Boolean enabled
        ) ;
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void checkProperty(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param hasFocus 
         *        whether focus is expected or not
         * 
         */
        public void checkFocus(
            @Nullable Boolean hasFocus
        ) ;
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * 
         */
        public void waitForComponent(
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        ) ;
        
        /**
         * 
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void click(
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void clickInComponent(
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkEnablementOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkEnablementOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkExistenceOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkExistenceOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkSelectionOfContextMenuEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkSelectionOfContextMenuEntryByTextpath(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void drag(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public void drop(
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * Use this to invoke the specified method
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        the arguments of the method
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.0
         */
        public void invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        ) ;
        
} 