/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.base.internal.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class GraphicsComponent
implements org.eclipse.jubula.toolkit.base.components.GraphicsComponent {
    @NonNull
    protected IComponentIdentifier m_componentIdentifier;

    public GraphicsComponent(@NonNull ComponentIdentifier componentIdentifier) {
        Validate.isTrue((boolean)(componentIdentifier instanceof IComponentIdentifier));
        this.m_componentIdentifier = (IComponentIdentifier)componentIdentifier;
    }

    @Override
    @NonNull
    public CAP showText(@NonNull String text, @NonNull Integer textSizeInPoints, @NonNull Integer timePerWordInMilliseconds, @NonNull Integer windowWidthInPixels) throws IllegalArgumentException {
        Validate.notNull((Object)text, (String)"Argument 'text' must not be null");
        Validate.notNull((Object)textSizeInPoints, (String)"Argument 'textSizeInPoints' must not be null");
        Validate.notNull((Object)timePerWordInMilliseconds, (String)"Argument 'timePerWordInMilliseconds' must not be null");
        Validate.notNull((Object)windowWidthInPixels, (String)"Argument 'windowWidthInPixels' must not be null");
        return new CapBuilder("rcShowText").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(text).addParameter(textSizeInPoints).addParameter(timePerWordInMilliseconds).addParameter(windowWidthInPixels).build();
    }

    @Override
    @NonNull
    public CAP checkExistence(@NonNull Boolean exists) throws IllegalArgumentException {
        Validate.notNull((Object)exists, (String)"Argument 'exists' must not be null");
        return new CapBuilder("rcVerifyExists").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(exists).build();
    }

    @Override
    @NonNull
    public CAP checkEnablement(@NonNull Boolean enabled) throws IllegalArgumentException {
        Validate.notNull((Object)enabled, (String)"Argument 'enabled' must not be null");
        return new CapBuilder("rcVerifyEnabled").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(enabled).build();
    }

    @Override
    @NonNull
    public CAP checkProperty(@NonNull String propertyName, @NonNull String propertyValue, @NonNull ValueSets.Operator operator) throws IllegalArgumentException {
        Validate.notNull((Object)propertyName, (String)"Argument 'propertyName' must not be null");
        Validate.notNull((Object)propertyValue, (String)"Argument 'propertyValue' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        return new CapBuilder("rcVerifyProperty").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(propertyName).addParameter(propertyValue).addParameter(operator.rcValue()).build();
    }

    @Override
    @NonNull
    public CAP checkFocus(@NonNull Boolean hasFocus) throws IllegalArgumentException {
        Validate.notNull((Object)hasFocus, (String)"Argument 'hasFocus' must not be null");
        return new CapBuilder("rcVerifyFocus").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(hasFocus).build();
    }

    @Override
    @NonNull
    public CAP waitForComponent(@NonNull Integer timeoutInMs, @NonNull Integer delayAfterVisibility) throws IllegalArgumentException {
        Validate.notNull((Object)timeoutInMs, (String)"Argument 'timeoutInMs' must not be null");
        Validate.notNull((Object)delayAfterVisibility, (String)"Argument 'delayAfterVisibility' must not be null");
        return new CapBuilder("rcWaitForComponent").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(timeoutInMs).addParameter(delayAfterVisibility).build();
    }

    @Override
    @NonNull
    public CAP click(@NonNull Integer numberOfClicks, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)numberOfClicks, (String)"Argument 'numberOfClicks' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcClick").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(numberOfClicks).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP clickInComponent(@NonNull Integer numberOfClicks, @NonNull ValueSets.InteractionMode mouseButton, @NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits) throws IllegalArgumentException {
        Validate.notNull((Object)numberOfClicks, (String)"Argument 'numberOfClicks' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        return new CapBuilder("rcClickDirect").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(numberOfClicks).addParameter(mouseButton.rcIntValue()).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).build();
    }

    @Override
    @NonNull
    public CAP selectContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String menupath, @NonNull ValueSets.Operator operator, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)menupath, (String)"Argument 'menupath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupSelectByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(menupath).addParameter(operator.rcValue()).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP selectContextMenuEntryByIndexpath(@NonNull String indexpath, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupSelectByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(indexpath).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP selectContextMenuEntryByTextpath(@NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupSelectByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(textpath).addParameter(operator.rcValue()).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP selectContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String indexpath, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupSelectByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(indexpath).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkEnablementOfContextMenuEntryByIndexpath(@NonNull String indexpath, @NonNull Boolean enabled, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)enabled, (String)"Argument 'enabled' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyEnabledByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(indexpath).addParameter(enabled).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String indexpath, @NonNull Boolean enabled, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)enabled, (String)"Argument 'enabled' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyEnabledByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(indexpath).addParameter(enabled).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkEnablementOfContextMenuEntryByTextpath(@NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull Boolean enabled, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)enabled, (String)"Argument 'enabled' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyEnabledByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(textpath).addParameter(operator.rcValue()).addParameter(enabled).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull Boolean enabled, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)enabled, (String)"Argument 'enabled' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyEnabledByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(textpath).addParameter(operator.rcValue()).addParameter(enabled).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkExistenceOfContextMenuEntryByIndexpath(@NonNull String indexpath, @NonNull Boolean exists, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)exists, (String)"Argument 'exists' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyExistsByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(indexpath).addParameter(exists).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String indexpath, @NonNull Boolean exists, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)exists, (String)"Argument 'exists' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyExistsByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(indexpath).addParameter(exists).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkExistenceOfContextMenuEntryByTextpath(@NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull Boolean exists, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)exists, (String)"Argument 'exists' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyExistsByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(textpath).addParameter(operator.rcValue()).addParameter(exists).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull Boolean exists, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)exists, (String)"Argument 'exists' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifyExistsByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(textpath).addParameter(operator.rcValue()).addParameter(exists).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkSelectionOfContextMenuEntryByIndexpath(@NonNull String indexpath, @NonNull Boolean selected, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)selected, (String)"Argument 'selected' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifySelectedByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(indexpath).addParameter(selected).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String indexpath, @NonNull Boolean selected, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)indexpath, (String)"Argument 'indexpath' must not be null");
        Validate.notNull((Object)selected, (String)"Argument 'selected' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifySelectedByIndexPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(indexpath).addParameter(selected).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkSelectionOfContextMenuEntryByTextpath(@NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull Boolean selected, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)selected, (String)"Argument 'selected' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifySelectedByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(textpath).addParameter(operator.rcValue()).addParameter(selected).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull String textpath, @NonNull ValueSets.Operator operator, @NonNull Boolean selected, @NonNull ValueSets.InteractionMode mouseButton) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)textpath, (String)"Argument 'textpath' must not be null");
        Validate.notNull((Object)operator, (String)"Argument 'operator' must not be null");
        Validate.notNull((Object)selected, (String)"Argument 'selected' must not be null");
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        return new CapBuilder("rcPopupVerifySelectedByTextPath").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(textpath).addParameter(operator.rcValue()).addParameter(selected).addParameter(mouseButton.rcIntValue()).build();
    }

    @Override
    @NonNull
    public CAP drag(@NonNull ValueSets.InteractionMode mouseButton, @NonNull ValueSets.Modifier[] modifierKeys, @NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits) throws IllegalArgumentException {
        Validate.notNull((Object)mouseButton, (String)"Argument 'mouseButton' must not be null");
        Validate.notNull((Object)modifierKeys, (String)"Argument 'modifierKeys' must not be null");
        Validate.noNullElements((Object[])modifierKeys, (String)"Elements of argument 'modifierKeys' must not be null");
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        return new CapBuilder("rcDrag").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(mouseButton.rcIntValue()).addParameter(StringUtils.join((Object[])modifierKeys, (String)" ")).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).build();
    }

    @Override
    @NonNull
    public CAP drop(@NonNull Integer xPosition, @NonNull ValueSets.Unit xUnits, @NonNull Integer yPosition, @NonNull ValueSets.Unit yUnits, @NonNull Integer delayBeforeDropMilliseconds) throws IllegalArgumentException {
        Validate.notNull((Object)xPosition, (String)"Argument 'xPosition' must not be null");
        Validate.notNull((Object)xUnits, (String)"Argument 'xUnits' must not be null");
        Validate.notNull((Object)yPosition, (String)"Argument 'yPosition' must not be null");
        Validate.notNull((Object)yUnits, (String)"Argument 'yUnits' must not be null");
        Validate.notNull((Object)delayBeforeDropMilliseconds, (String)"Argument 'delayBeforeDropMilliseconds' must not be null");
        return new CapBuilder("rcDrop").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(xPosition).addParameter(xUnits.rcValue()).addParameter(yPosition).addParameter(yUnits.rcValue()).addParameter(delayBeforeDropMilliseconds).build();
    }

    @Override
    @NonNull
    public CAP invokeMethod(@NonNull String fullyQualifiedClassName, @NonNull String methodName, @Nullable String methodSignature, @Nullable String methodArguments, @Nullable String methodArgumentSeparator, @NonNull Integer timeoutInMs) throws IllegalArgumentException {
        Validate.notNull((Object)fullyQualifiedClassName, (String)"Argument 'fullyQualifiedClassName' must not be null");
        Validate.notNull((Object)methodName, (String)"Argument 'methodName' must not be null");
        Validate.notNull((Object)timeoutInMs, (String)"Argument 'timeoutInMs' must not be null");
        return new CapBuilder("rcInvokeMethod").setDefaultMapping(Boolean.valueOf(false)).setComponentIdentifier((ComponentIdentifier)this.m_componentIdentifier).addParameter(fullyQualifiedClassName).addParameter(methodName).addOptionalParameter(methodSignature).addOptionalParameter(methodArguments).addOptionalParameter(methodArgumentSeparator).addParameter(timeoutInMs).build();
    }
}

