/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the LocatorActionHandler component from the html toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-03T13:48:08.715Z")
@Beta
public interface LocatorActionHandler {
    
    
        /**
         * 
         * @param xPath 
         *        the XPath to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @since 4.0
         */
        public void checkXPathCount(
            @Nullable String xPath,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable Integer count
        ) ;
        
        /**
         * 
         * @param cSSPath 
         *        the CSS path to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @since 4.0
         */
        public void checkCSSPathCount(
            @Nullable String cSSPath,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable Integer count
        ) ;
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @param operator 
         *        the operator used for comparison
         * @param text 
         *        the text to use
         * 
         */
        public void checkText(
            @Nullable String locator,
            @Nullable Operator operator,
            @Nullable String text
        ) ;
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * 
         */
        public void click(
            @Nullable String locator
        ) ;
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @param locator 
         *        the locator to use
         * 
         */
        public void waitForComponent(
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility,
            @Nullable String locator
        ) ;
        
} 