/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the PickerActionHandler component from the ios toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-03T13:48:08.742Z")
@Beta
public interface PickerActionHandler extends org.eclipse.jubula.toolkit.concrete.components.handler.ComboComponentActionHandler {
    
    
        /**
         * 
         * @param direction 
         *        the direction
         * 
         */
        public void swipe(
            @Nullable Direction direction
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param column 
         *        the column
         * 
         */
        public void checkExistenceOfEntryByValueInColumn(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer column
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param column 
         *        the column
         * 
         */
        public void checkSelectionOfEntryByIndexInColumn(
            @Nullable String index,
            @Nullable Boolean selected,
            @Nullable Integer column
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param column 
         *        the column
         * 
         */
        public void selectEntryByIndexInColumn(
            @Nullable String index,
            @Nullable Integer column
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param column 
         *        the column
         * 
         */
        public void selectEntryByValueInColumn(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType,
            @Nullable Integer column
        ) ;
        
} 