/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.javafx.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the {@link javafx.scene.control.TreeTableView} component from the javafx toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-03T13:48:08.794Z")
@Beta
public interface TreeTableViewActionHandler extends org.eclipse.jubula.toolkit.javafx.components.handler.TreeViewActionHandler {
    
    
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */@Deprecated
        public void selectEntryByTextpathSpecifyColumn(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer column,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public void selectEntryByTextpathSpecifyColumnPath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */@Deprecated
        public void selectEntryByIndexpathSpecifyColumn(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable Integer column,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public void selectEntryByIndexpathSpecifyColumnPath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable String column,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * 
         */@Deprecated
        public void checkSelectionByValueSSpecifyColumn(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer column
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @since 4.0
         */
        public void checkSelectionByValueSSpecifyColumnPath(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * Use this action to check the text in a cell based on the current position of the cursor
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.0
         */
        public void checkTextOfCellMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.0
         */
        public void checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * Use this action to check whether a cell at the current mouse position is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.0
         */
        public void checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable
        ) ;
        
        /**
         * Use this action to check whether the currently selected cell is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.0
         */
        public void checkEditabilityOfSelectedCell(
            @Nullable Boolean editable
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.0
         */
        public void checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.0
         */
        public void checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.0
         */
        public void checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public void selectCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public void selectValueFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public void selectValueFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @since 4.0
         */
        public void checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists
        ) ;
        
} 