/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.concrete.Tree")
@TesterClass(testerClass="org.eclipse.jubula.rc.swt.tester.TreeTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-03T13:48:08.837Z")
@Beta
public class TreeActionHandler extends org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TreeComponentActionHandler implements org.eclipse.jubula.toolkit.swt.components.handler.TreeActionHandler {
            public TreeActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param checked 
         *        Checked
         * 
         */
        public void checkSelectionOfCheckboxOnSelectedNode(
            @Nullable Boolean checked
        )  {
            if (checked == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void toggleCheckboxOnNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        )  {
            if (pathType == null) return;
            
            if (preAscend == null) return;
            
            if (textpath == null) return;
            
            if (operator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggleCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public void toggleCheckboxOnNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        )  {
            if (pathType == null) return;
            
            if (preAscend == null) return;
            
            if (indexpath == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggleCheckboxByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * 
         */
        public void checkSelectionOfCheckboxByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean checked
        )  {
            if (pathType == null) return;
            
            if (preAscend == null) return;
            
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (checked == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(checked)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * 
         */
        public void checkSelectionOfCheckboxByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean checked
        )  {
            if (pathType == null) return;
            
            if (preAscend == null) return;
            
            if (indexpath == null) return;
            
            if (checked == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(checked)
                            .build(), null);
        }
        
} 