/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="org.eclipse.swt.widgets.Tree")
@TesterClass(testerClass="org.eclipse.jubula.rc.swt.tester.TreeTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-03T13:48:08.839Z")
@Beta
public class TreeTableActionHandler extends org.eclipse.jubula.toolkit.swt.internal.impl.handler.TreeActionHandler implements org.eclipse.jubula.toolkit.swt.components.handler.TreeTableActionHandler {
            public TreeTableActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @since 4.0
         */
        public void checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists
        )  {
            if (column == null) return;
            
            if (columnOperator == null) return;
            
            if (exists == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckExistenceOfColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(exists)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectEntryByTextpathSpecifyColumn(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer column,
            @Nullable InteractionMode mouseButton
        )  {
            if (pathType == null) return;
            
            if (preAscend == null) return;
            
            if (textpath == null) return;
            
            if (operator == null) return;
            
            if (numberOfClicks == null) return;
            
            if (column == null) return;
            
            if (mouseButton == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelect")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(column)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public void selectEntryByIndexpathSpecifyColumn(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable Integer column,
            @Nullable InteractionMode mouseButton
        )  {
            if (pathType == null) return;
            
            if (preAscend == null) return;
            
            if (indexpath == null) return;
            
            if (numberOfClicks == null) return;
            
            if (column == null) return;
            
            if (mouseButton == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(numberOfClicks)
                            .addParameter(column)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * 
         */
        public void checkSelectionByValueSSpecifyColumn(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer column
        )  {
            if (text == null) return;
            
            if (operator == null) return;
            
            if (column == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(column)
                            .build(), null);
        }
        
} 